/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.image;

import boofcv.alg.distort.DistortImageOps;
import boofcv.alg.interpolate.InterpolatePixel;
import boofcv.alg.interpolate.TypeInterpolate;
import boofcv.core.image.ConvertBufferedImage;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.gui.ListDisplayPanel;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.pyramid.ImagePyramid;
import java.awt.Dimension;
import java.awt.image.BufferedImage;

public class ImagePyramidPanel<T extends ImageSingleBand>
extends ListDisplayPanel {
    ImagePyramid<T> pyramid;
    InterpolatePixel<T> interp;
    T upscale;
    boolean scaleUp;
    boolean showScales = true;

    public ImagePyramidPanel(ImagePyramid<T> pyramid, boolean scaleUp) {
        this.set(pyramid, scaleUp);
        this.render();
        this.setPreferredSize(new Dimension(pyramid.getWidth(0), pyramid.getHeight(0)));
    }

    public ImagePyramidPanel() {
    }

    public void setShowScales(boolean showScales) {
        this.showScales = showScales;
    }

    public void set(ImagePyramid<T> pyramid, boolean scaleUp) {
        this.pyramid = pyramid;
        this.scaleUp = scaleUp;
    }

    public void render() {
        this.reset();
        if (this.pyramid == null) {
            return;
        }
        if (this.scaleUp) {
            this.scaleUpLayers();
        } else {
            this.doNotScaleLayers();
        }
    }

    private void doNotScaleLayers() {
        int N = this.pyramid.getNumLayers();
        for (int i = 0; i < N; ++i) {
            BufferedImage b = ConvertBufferedImage.convertTo(this.pyramid.getLayer(i), null);
            this.addImage(b, String.format("%5.2f", this.pyramid.getScale(i)));
        }
    }

    private void scaleUpLayers() {
        ImageSingleBand l = (ImageSingleBand)this.pyramid.getLayer(0);
        if (this.upscale == null) {
            this.interp = FactoryInterpolation.nearestNeighborPixel(l.getClass());
            this.upscale = (ImageSingleBand)l._createNew(l.width, l.height);
        } else {
            ((ImageSingleBand)this.upscale).reshape(l.width, l.height);
        }
        int N = this.pyramid.getNumLayers();
        for (int i = 0; i < N; ++i) {
            DistortImageOps.scale(this.pyramid.getLayer(i), this.upscale, TypeInterpolate.NEAREST_NEIGHBOR);
            BufferedImage b = ConvertBufferedImage.convertTo(this.upscale, null);
            if (this.showScales) {
                this.addImage(b, String.format("%5.2f", this.pyramid.getScale(i)));
                continue;
            }
            this.addImage(b, String.format("%5.2f", this.pyramid.getSigma(i)));
        }
    }
}

