/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.image;

import boofcv.alg.misc.GImageStatistics;
import boofcv.alg.misc.ImageStatistics;
import boofcv.core.image.ConvertBufferedImage;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInteger;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;
import java.awt.image.BufferedImage;

public class VisualizeImageData {
    public static BufferedImage standard(ImageSingleBand<?> src, BufferedImage dst) {
        if (src.getTypeInfo().isInteger()) {
            ImageInteger srcInt = (ImageInteger)src;
            if (src.getTypeInfo().isSigned()) {
                double max = GImageStatistics.maxAbs(srcInt);
                return VisualizeImageData.colorizeSign(srcInt, dst, (int)max);
            }
            if (src.getTypeInfo().getNumBits() == 8) {
                dst = ConvertBufferedImage.convertTo((ImageUInt8)src, dst);
            } else {
                double max = GImageStatistics.maxAbs(srcInt);
                dst = VisualizeImageData.grayUnsigned(srcInt, dst, (int)max);
            }
        } else if (ImageFloat32.class.isAssignableFrom(src.getClass())) {
            ImageFloat32 img = (ImageFloat32)src;
            float max = ImageStatistics.maxAbs(img);
            boolean hasNegative = false;
            block0: for (int i = 0; i < img.getHeight(); ++i) {
                for (int j = 0; j < img.getWidth(); ++j) {
                    if (!(img.get(j, i) < 0.0f)) continue;
                    hasNegative = true;
                    continue block0;
                }
            }
            if (hasNegative) {
                return VisualizeImageData.colorizeSign(img, dst, (float)((int)max));
            }
            return VisualizeImageData.grayMagnitude((ImageFloat32)src, dst, max);
        }
        return dst;
    }

    public static BufferedImage colorizeSign(ImageSingleBand src, BufferedImage dst, double normalize) {
        dst = VisualizeImageData.checkInputs(src, dst);
        if (normalize <= 0.0) {
            normalize = GImageStatistics.maxAbs(src);
        }
        if (normalize == 0.0) {
            ConvertBufferedImage.convertTo(src, dst);
            return dst;
        }
        if (src.getClass().isAssignableFrom(ImageFloat32.class)) {
            return VisualizeImageData.colorizeSign((ImageFloat32)src, dst, (float)normalize);
        }
        return VisualizeImageData.colorizeSign((ImageInteger)src, dst, (int)normalize);
    }

    private static BufferedImage colorizeSign(ImageInteger src, BufferedImage dst, int normalize) {
        for (int y = 0; y < src.height; ++y) {
            for (int x = 0; x < src.width; ++x) {
                int v = src.get(x, y);
                int rgb = v > 0 ? 255 * v / normalize << 16 : -(255 * v / normalize << 8);
                dst.setRGB(x, y, rgb);
            }
        }
        return dst;
    }

    public static BufferedImage grayUnsigned(ImageInteger src, BufferedImage dst, int normalize) {
        dst = VisualizeImageData.checkInputs(src, dst);
        if (src.getTypeInfo().isSigned()) {
            throw new IllegalArgumentException("Can only convert unsigned images.");
        }
        for (int y = 0; y < src.height; ++y) {
            for (int x = 0; x < src.width; ++x) {
                int v = src.get(x, y);
                int rgb = 255 * v / normalize;
                dst.setRGB(x, y, rgb << 16 | rgb << 8 | rgb);
            }
        }
        return dst;
    }

    public static BufferedImage grayMagnitude(ImageSingleBand src, BufferedImage dst, double normalize) {
        if (normalize < 0.0) {
            normalize = GImageStatistics.maxAbs(src);
        }
        dst = VisualizeImageData.checkInputs(src, dst);
        if (src.getTypeInfo().isInteger()) {
            return VisualizeImageData.grayMagnitude((ImageInteger)src, dst, (int)normalize);
        }
        return VisualizeImageData.grayMagnitude((ImageFloat32)src, dst, (float)normalize);
    }

    public static BufferedImage grayMagnitudeTemp(ImageSingleBand src, BufferedImage dst, double normalize) {
        if (normalize < 0.0) {
            normalize = GImageStatistics.maxAbs(src);
        }
        dst = VisualizeImageData.checkInputs(src, dst);
        if (src.getTypeInfo().isInteger()) {
            return VisualizeImageData.grayMagnitudeTemp((ImageInteger)src, dst, (int)normalize);
        }
        throw new RuntimeException("Add support");
    }

    private static BufferedImage grayMagnitude(ImageInteger src, BufferedImage dst, int maxValue) {
        for (int y = 0; y < src.height; ++y) {
            for (int x = 0; x < src.width; ++x) {
                int v = Math.abs(src.get(x, y));
                int rgb = 255 * v / maxValue;
                dst.setRGB(x, y, rgb << 16 | rgb << 8 | rgb);
            }
        }
        return dst;
    }

    private static BufferedImage grayMagnitudeTemp(ImageInteger src, BufferedImage dst, int maxValue) {
        int halfValue = maxValue / 2 + maxValue % 2;
        for (int y = 0; y < src.height; ++y) {
            for (int x = 0; x < src.width; ++x) {
                int b;
                int r;
                int v = Math.abs(src.get(x, y));
                if (v >= halfValue) {
                    r = 255 * (v - halfValue) / halfValue;
                    b = 0;
                } else {
                    r = 0;
                    b = 255 * v / halfValue;
                }
                if (v == 0) {
                    b = 0;
                    r = 0;
                } else {
                    r = 255 * v / maxValue;
                    b = 255 * (maxValue - v) / maxValue;
                }
                dst.setRGB(x, y, r << 16 | b);
            }
        }
        return dst;
    }

    public static BufferedImage disparity(ImageSingleBand disparity, BufferedImage dst, int minDisparity, int maxDisparity, int invalidColor) {
        if (dst == null) {
            dst = new BufferedImage(disparity.getWidth(), disparity.getHeight(), 1);
        }
        if (disparity.getTypeInfo().isInteger()) {
            return VisualizeImageData.disparity((ImageInteger)disparity, dst, minDisparity, maxDisparity, invalidColor);
        }
        if (disparity instanceof ImageFloat32) {
            return VisualizeImageData.disparity((ImageFloat32)disparity, dst, minDisparity, maxDisparity, invalidColor);
        }
        throw new RuntimeException("Add support");
    }

    private static BufferedImage disparity(ImageInteger src, BufferedImage dst, int minValue, int maxValue, int invalidColor) {
        int range = maxValue - minValue;
        for (int y = 0; y < src.height; ++y) {
            for (int x = 0; x < src.width; ++x) {
                int r;
                int b;
                int v = src.unsafe_get(x, y);
                if (v > range) {
                    dst.setRGB(x, y, invalidColor);
                    continue;
                }
                if (v == 0) {
                    b = 0;
                    r = 0;
                } else {
                    r = 255 * v / maxValue;
                    b = 255 * (maxValue - v) / maxValue;
                }
                dst.setRGB(x, y, r << 16 | b);
            }
        }
        return dst;
    }

    private static BufferedImage disparity(ImageFloat32 src, BufferedImage dst, int minValue, int maxValue, int invalidColor) {
        float range = maxValue - minValue;
        for (int y = 0; y < src.height; ++y) {
            for (int x = 0; x < src.width; ++x) {
                int r;
                int b;
                float v = src.unsafe_get(x, y);
                if (v > range) {
                    dst.setRGB(x, y, invalidColor);
                    continue;
                }
                if (v == 0.0f) {
                    b = 0;
                    r = 0;
                } else {
                    r = (int)(255.0f * v / (float)maxValue);
                    b = (int)(255.0f * ((float)maxValue - v) / (float)maxValue);
                }
                dst.setRGB(x, y, r << 16 | b);
            }
        }
        return dst;
    }

    private static BufferedImage colorizeSign(ImageFloat32 src, BufferedImage dst, float maxAbsValue) {
        for (int y = 0; y < src.height; ++y) {
            for (int x = 0; x < src.width; ++x) {
                float v = src.get(x, y);
                int rgb = v > 0.0f ? (int)(255.0f * v / maxAbsValue) << 16 : (int)(-255.0f * v / maxAbsValue) << 8;
                dst.setRGB(x, y, rgb);
            }
        }
        return dst;
    }

    public static BufferedImage graySign(ImageFloat32 src, BufferedImage dst, float maxAbsValue) {
        dst = VisualizeImageData.checkInputs(src, dst);
        if (maxAbsValue < 0.0f) {
            maxAbsValue = ImageStatistics.maxAbs(src);
        }
        for (int y = 0; y < src.height; ++y) {
            for (int x = 0; x < src.width; ++x) {
                float v = src.get(x, y);
                int rgb = 127 + (int)(127.0f * v / maxAbsValue);
                dst.setRGB(x, y, rgb << 16 | rgb << 8 | rgb);
            }
        }
        return dst;
    }

    private static BufferedImage grayMagnitude(ImageFloat32 src, BufferedImage dst, float maxAbsValue) {
        for (int y = 0; y < src.height; ++y) {
            for (int x = 0; x < src.width; ++x) {
                float v = Math.abs(src.get(x, y));
                int rgb = (int)(255.0f * v / maxAbsValue);
                dst.setRGB(x, y, rgb << 16 | rgb << 8 | rgb);
            }
        }
        return dst;
    }

    private static BufferedImage checkInputs(ImageBase src, BufferedImage dst) {
        if (dst != null) {
            if (dst.getWidth() != src.getWidth() || dst.getHeight() != src.getHeight()) {
                throw new IllegalArgumentException("image dimension are different");
            }
        } else {
            dst = new BufferedImage(src.getWidth(), src.getHeight(), 1);
        }
        return dst;
    }
}

