/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.wrapper;

import boofcv.io.MediaManager;
import boofcv.io.VideoCallBack;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.image.UtilImageIO;
import boofcv.io.video.VideoMjpegCodec;
import boofcv.io.wrapper.images.ImageStreamSequence;
import boofcv.io.wrapper.images.JpegByteImageSequence;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultMediaManager
implements MediaManager {
    public static final DefaultMediaManager INSTANCE = new DefaultMediaManager();
    Map<String, BufferedImage> cachedImage = new HashMap<String, BufferedImage>();

    @Override
    public Reader openFile(String fileName) {
        try {
            return new FileReader(fileName);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    @Override
    public BufferedImage openImage(String fileName) {
        BufferedImage b = this.cachedImage.get(fileName);
        if (b == null) {
            b = UtilImageIO.loadImage(fileName);
            if (b == null) {
                throw new RuntimeException("Image cannot be found! " + fileName);
            }
            this.cachedImage.put(fileName, b);
        }
        BufferedImage c = new BufferedImage(b.getWidth(), b.getHeight(), b.getType());
        Graphics2D g2 = c.createGraphics();
        g2.drawImage((Image)b, 0, 0, null);
        return c;
    }

    @Override
    public <T extends ImageBase> SimpleImageSequence<T> openVideo(String fileName, ImageDataType<T> type) {
        if (fileName.endsWith("mjpeg") || fileName.endsWith("MJPEG")) {
            try {
                VideoMjpegCodec codec = new VideoMjpegCodec();
                List<byte[]> data = codec.read(new FileInputStream(fileName));
                return new JpegByteImageSequence<T>(type, data, false);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (fileName.endsWith("mpng") || fileName.endsWith("MPNG")) {
            try {
                return new ImageStreamSequence<T>(fileName, true, type);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Unknown movie type.  Must be an mjpeg");
    }

    @Override
    public <T extends ImageBase> boolean openCamera(String device, int width, int height, VideoCallBack<T> callback) {
        throw new RuntimeException("Not supported");
    }
}

