/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.ImageAccessException;
import boofcv.struct.image.ImageInteger;
import boofcv.struct.image.ImageTypeInfo;

public abstract class ImageInt8<T extends ImageInt8>
extends ImageInteger<T> {
    public byte[] data;

    public ImageInt8(int width, int height) {
        super(width, height);
    }

    public ImageInt8() {
    }

    @Override
    public void set(int x, int y, int value) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds: " + x + " " + y);
        }
        this.data[this.getIndex((int)x, (int)y)] = (byte)value;
    }

    @Override
    public void unsafe_set(int x, int y, int value) {
        this.data[this.getIndex((int)x, (int)y)] = (byte)value;
    }

    @Override
    protected Object _getData() {
        return this.data;
    }

    @Override
    protected void _setData(Object data) {
        this.data = (byte[])data;
    }

    @Override
    public ImageTypeInfo<T> getTypeInfo() {
        return ImageTypeInfo.I8;
    }
}

