/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.ImageAccessException;
import boofcv.struct.image.ImageInteger;
import boofcv.struct.image.ImageTypeInfo;

public class ImageSInt32
extends ImageInteger<ImageSInt32> {
    public int[] data;

    public ImageSInt32(int width, int height) {
        super(width, height);
    }

    public ImageSInt32() {
    }

    @Override
    public void unsafe_set(int x, int y, int value) {
        this.data[this.getIndex((int)x, (int)y)] = value;
    }

    @Override
    public int unsafe_get(int x, int y) {
        return this.data[this.getIndex(x, y)];
    }

    @Override
    public void set(int x, int y, int value) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds");
        }
        this.data[this.getIndex((int)x, (int)y)] = value;
    }

    @Override
    public ImageTypeInfo<ImageSInt32> getTypeInfo() {
        return ImageTypeInfo.S32;
    }

    @Override
    protected Object _getData() {
        return this.data;
    }

    @Override
    protected void _setData(Object data) {
        this.data = (int[])data;
    }

    @Override
    public ImageSInt32 _createNew(int imgWidth, int imgHeight) {
        if (imgWidth == -1 || imgHeight == -1) {
            return new ImageSInt32();
        }
        return new ImageSInt32(imgWidth, imgHeight);
    }
}

