/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageTypeInfo;
import java.lang.reflect.Array;

public abstract class ImageSingleBand<T extends ImageSingleBand>
extends ImageBase<T> {
    protected ImageSingleBand(int width, int height) {
        this._setData(Array.newInstance(this.getTypeInfo().getDataType(), width * height));
        this.startIndex = 0;
        this.stride = width;
        this.width = width;
        this.height = height;
    }

    protected ImageSingleBand() {
    }

    @Override
    public T subimage(int x0, int y0, int x1, int y1) {
        if (x0 < 0 || y0 < 0) {
            throw new IllegalArgumentException("x0 or y0 is less than zero");
        }
        if (x1 < x0 || y1 < y0) {
            throw new IllegalArgumentException("x1 or y1 is less than x0 or y0 respectively");
        }
        if (x1 > this.width || y1 > this.height) {
            throw new IllegalArgumentException("x1 or y1 is more than the width or height respectively");
        }
        ImageSingleBand ret = (ImageSingleBand)this._createNew(-1, -1);
        ret._setData(this._getData());
        ret.stride = Math.max(this.width, this.stride);
        ret.width = x1 - x0;
        ret.height = y1 - y0;
        ret.startIndex = this.startIndex + y0 * this.stride + x0;
        return (T)ret;
    }

    @Override
    public void reshape(int width, int height) {
        if (this.isSubimage()) {
            throw new IllegalArgumentException("Can't reshape sub-images");
        }
        Object data = this._getData();
        if (Array.getLength(data) < width * height) {
            ImageSingleBand a = (ImageSingleBand)this._createNew(width, height);
            this._setData(a._getData());
        }
        this.stride = width;
        this.width = width;
        this.height = height;
    }

    @Override
    public void setTo(T orig) {
        if (((ImageSingleBand)orig).width != this.width || ((ImageSingleBand)orig).height != this.height) {
            throw new IllegalArgumentException("The width and/or height of 'orig' is not the same as this class");
        }
        if (!((ImageBase)orig).isSubimage() && !this.isSubimage()) {
            System.arraycopy(((ImageSingleBand)orig)._getData(), ((ImageSingleBand)orig).startIndex, this._getData(), this.startIndex, this.stride * this.height);
        } else {
            int indexSrc = ((ImageSingleBand)orig).startIndex;
            int indexDst = this.startIndex;
            for (int y = 0; y < this.height; ++y) {
                System.arraycopy(((ImageSingleBand)orig)._getData(), indexSrc, this._getData(), indexDst, this.width);
                indexSrc += ((ImageSingleBand)orig).stride;
                indexDst += this.stride;
            }
        }
    }

    public T clone() {
        ImageSingleBand ret = (ImageSingleBand)this._createNew(this.width, this.height);
        ret.setTo((T)this);
        return (T)ret;
    }

    protected abstract Object _getData();

    public abstract ImageTypeInfo<T> getTypeInfo();

    protected abstract void _setData(Object var1);
}

