/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.multilabel;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import moa.classifiers.Classifier;
import moa.classifiers.core.attributeclassobservers.AttributeClassObserver;
import moa.classifiers.multilabel.HoeffdingTreeClassifLeaves;
import moa.classifiers.trees.HoeffdingTree;
import moa.core.InstancesHeader;
import moa.core.utils.Converter;
import weka.core.Instance;
import weka.core.Instances;

public class MultilabelHoeffdingTree
extends HoeffdingTreeClassifLeaves {
    private static final long serialVersionUID = 1L;
    public int m_L = -1;
    protected Converter converter = null;

    @Override
    public void setModelContext(InstancesHeader raw_header) {
        this.modelContext = raw_header;
    }

    public MultilabelHoeffdingTree() {
        this.removePoorAttsOption = null;
    }

    @Override
    protected HoeffdingTree.LearningNode newLearningNode(double[] initialClassObservations) {
        return new MultilabelLearningNodeClassifier(initialClassObservations, null, this);
    }

    @Override
    protected HoeffdingTree.LearningNode newLearningNode(double[] initialClassObservations, Classifier cl) {
        return new MultilabelLearningNodeClassifier(initialClassObservations, cl, this);
    }

    @Override
    protected void deactivateLearningNode(HoeffdingTree.ActiveLearningNode toDeactivate, HoeffdingTree.SplitNode parent, int parentBranch) {
        MultilabelInactiveLearningNode newLeaf = new MultilabelInactiveLearningNode(toDeactivate.getObservedClassDistribution());
        if (parent == null) {
            this.treeRoot = newLeaf;
        } else {
            parent.setChild(parentBranch, newLeaf);
        }
        --this.activeLeafNodeCount;
        ++this.inactiveLeafNodeCount;
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        int L = inst.classIndex() + 1;
        if (this.m_L != L) {
            this.m_L = L;
            this.converter = new Converter(this.m_L);
            try {
                this.converter.createTemplate(new Instances((Reader)new StringReader(this.modelContext.toString()), 0));
            }
            catch (Exception e) {
                System.err.println("Error, failed to create a multi-label Instances template with L = " + this.m_L);
                System.out.println("Instances: " + this.modelContext.toString());
                e.printStackTrace();
                System.exit(1);
            }
        }
        if (this.treeRoot != null) {
            HoeffdingTree.FoundNode foundNode = this.treeRoot.filterInstanceToLeaf(inst, null, -1);
            HoeffdingTree.Node leafNode = foundNode.node;
            if (leafNode == null) {
                leafNode = foundNode.parent;
            }
            return leafNode.getClassVotes(inst, this);
        }
        return new double[this.m_L];
    }

    public class MultilabelLearningNodeClassifier
    extends HoeffdingTreeClassifLeaves.LearningNodeClassifier {
        private static final long serialVersionUID = 1L;

        public MultilabelLearningNodeClassifier(double[] initialClassObservations, Classifier cl, MultilabelHoeffdingTree ht) {
            super(MultilabelHoeffdingTree.this, initialClassObservations);
            if (cl == null) {
                this.classifier = ((Classifier)MultilabelHoeffdingTree.this.getPreparedClassOption(ht.learnerOption)).copy();
                this.classifier.resetLearning();
                InstancesHeader raw_header = ht.getModelContext();
                this.classifier.setModelContext(raw_header);
            } else {
                this.classifier = cl.copy();
            }
        }

        @Override
        public double[] getClassVotes(Instance inst, HoeffdingTree ht) {
            if (this.classifier == null) {
                return new double[((MultilabelHoeffdingTree)ht).converter.getL()];
            }
            return this.classifier.getVotesForInstance(inst);
        }

        @Override
        public void disableAttribute(int attIndex) {
        }

        @Override
        public Classifier getClassifier() {
            return this.classifier;
        }

        @Override
        public void learnFromInstance(Instance mlinst, HoeffdingTree ht) {
            this.classifier.trainOnInstance(mlinst);
            MultilabelHoeffdingTree mht = (MultilabelHoeffdingTree)ht;
            List<Integer> labels = mht.converter.getRelevantLabels(mlinst);
            for (int l : labels) {
                this.observedClassDistribution.addToValue(l, mlinst.weight());
            }
            Instance inst = mht.converter.formatInstance(mlinst);
            for (int i = 0; i < inst.numAttributes() - 1; ++i) {
                int instAttIndex = MultilabelHoeffdingTree.modelAttIndexToInstanceAttIndex(i, inst);
                AttributeClassObserver obs = (AttributeClassObserver)this.attributeObservers.get(i);
                if (obs == null) {
                    obs = inst.attribute(instAttIndex).isNominal() ? mht.newNominalClassObserver() : mht.newNumericClassObserver();
                    this.attributeObservers.set(i, obs);
                }
                for (int l : labels) {
                    obs.observeAttributeClass(inst.value(instAttIndex), l, inst.weight());
                }
            }
        }
    }

    public static class MultilabelInactiveLearningNode
    extends HoeffdingTree.InactiveLearningNode {
        private static final long serialVersionUID = 1L;

        public MultilabelInactiveLearningNode(double[] initialClassObservations) {
            super(initialClassObservations);
        }

        @Override
        public void learnFromInstance(Instance inst, HoeffdingTree ht) {
            List<Integer> labels = ((MultilabelHoeffdingTree)ht).converter.getRelevantLabels(inst);
            for (int l : labels) {
                this.observedClassDistribution.addToValue(l, inst.weight());
            }
        }
    }
}

