/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules;

import java.util.ArrayList;
import java.util.Collections;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.core.attributeclassobservers.AttributeClassObserver;
import moa.classifiers.core.attributeclassobservers.BinaryTreeNumericAttributeClassObserver;
import moa.classifiers.core.attributeclassobservers.GaussianNumericAttributeClassObserver;
import moa.classifiers.core.attributeclassobservers.NominalAttributeClassObserver;
import moa.classifiers.rules.Predicates;
import moa.classifiers.rules.Rule;
import moa.core.AutoExpandVector;
import moa.core.DoubleVector;
import moa.core.Measurement;
import moa.core.StringUtils;
import moa.options.FlagOption;
import moa.options.FloatOption;
import moa.options.IntOption;
import moa.options.MultiChoiceOption;
import weka.core.Instance;
import weka.core.Utils;

public class RuleClassifier
extends AbstractClassifier {
    private static final long serialVersionUID = 1L;
    protected Instance instance;
    protected AutoExpandVector<AttributeClassObserver> attributeObservers;
    protected AutoExpandVector<AttributeClassObserver> attributeObserversGauss;
    protected AutoExpandVector<AttributeClassObserver> observersTemp = new AutoExpandVector();
    protected DoubleVector observedClassDistribution;
    protected DoubleVector saveBestEntropy = new DoubleVector();
    protected DoubleVector saveBestEntropyNominalAttrib = new DoubleVector();
    protected ArrayList<Integer> ruleClassIndex = new ArrayList();
    protected ArrayList<ArrayList<Double>> saveBestValGlobalEntropy = new ArrayList();
    protected ArrayList<Double> saveBestGlobalEntropy = new ArrayList();
    protected ArrayList<Double> saveTheBest = new ArrayList();
    protected ArrayList<ArrayList<Integer>> majority = new ArrayList();
    protected ArrayList<String> ruleClassName = new ArrayList();
    protected ArrayList<Rule> ruleSet = new ArrayList();
    double minEntropyTemp = Double.MAX_VALUE;
    double cutPointTemp = 0.0;
    double minEntropyNominalAttrib = Double.MAX_VALUE;
    double symbol = 0.0;
    int numTotalInstance = 0;
    int numAttributes = 0;
    int numClass = 0;
    BinaryTreeNumericAttributeClassObserver.Node root;
    Predicates pred;
    public FloatOption PminOption = new FloatOption("Pmin", 'p', "Percentage of the total number of example seen in the node.", 0.1, 0.0, 1.0);
    public FloatOption splitConfidenceOption = new FloatOption("splitConfidence", 'c', "The allowable error in split decision, values closer to 0 will take longer to decide.", 1.0E-6, 0.0, 1.0);
    public FloatOption tieThresholdOption = new FloatOption("tieThreshold", 't', "Threshold below which a split will be forced to break ties.", 0.05, 0.0, 1.0);
    public IntOption gracePeriodOption = new IntOption("gracePeriod", 'g', "The number of instances a leaf should observe between split attempts.", 200, 0, Integer.MAX_VALUE);
    public MultiChoiceOption predictionFunctionOption = new MultiChoiceOption("predictionFunctionOption", 'z', "The prediction function to use.", new String[]{"firstHit", "weightedSum", "weightedMax"}, new String[]{"first Hit", "weighted Sum", "weighted Max"}, 0);
    public FlagOption orderedRulesOption = new FlagOption("orderedRules", 'r', "orderedRules.");

    @Override
    public String getPurposeString() {
        return "Rule Classifier.";
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        double[] votes = new double[this.observedClassDistribution.numValues()];
        switch (this.predictionFunctionOption.getChosenIndex()) {
            case 0: {
                votes = this.firstHit(inst);
                break;
            }
            case 1: {
                votes = this.weightedSum(inst);
                break;
            }
            case 2: {
                votes = this.weightedMax(inst);
            }
        }
        return votes;
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return null;
    }

    @Override
    public void resetLearningImpl() {
        this.observedClassDistribution = new DoubleVector();
        this.attributeObservers = new AutoExpandVector();
        this.attributeObserversGauss = new AutoExpandVector();
    }

    public double getWeightSeen() {
        return this.observedClassDistribution.sumOfValues();
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        int numInstanciaObservers = 0;
        int countRuleFiredTrue = 0;
        int remainder = Integer.MAX_VALUE;
        boolean ruleFired = false;
        this.instance = inst;
        this.numAttributes = this.instance.numAttributes() - 1;
        this.numClass = this.instance.numClasses();
        ++this.numTotalInstance;
        for (int j = 0; j < this.ruleSet.size(); ++j) {
            if (!this.ruleSet.get(j).ruleEvaluate(inst)) continue;
            ++countRuleFiredTrue;
            this.saveBestValGlobalEntropy = new ArrayList();
            this.saveBestGlobalEntropy = new ArrayList();
            this.saveTheBest = new ArrayList();
            this.minEntropyTemp = Double.MAX_VALUE;
            this.minEntropyNominalAttrib = Double.MAX_VALUE;
            this.ruleSet.get((int)j).obserClassDistrib.addToValue((int)inst.classValue(), inst.weight());
            for (int i = 0; i < inst.numAttributes() - 1; ++i) {
                int instAttIndex = RuleClassifier.modelAttIndexToInstanceAttIndex(i, inst);
                AttributeClassObserver obs = this.ruleSet.get((int)j).observers.get(i);
                AttributeClassObserver obsGauss = this.ruleSet.get((int)j).observersGauss.get(i);
                if (obs == null) {
                    obs = inst.attribute(instAttIndex).isNominal() ? this.newNominalClassObserver() : this.newNumericClassObserver();
                    this.ruleSet.get((int)j).observers.set(i, obs);
                }
                if (obsGauss == null) {
                    obsGauss = inst.attribute(instAttIndex).isNumeric() ? this.newNumericClassObserver2() : null;
                    this.ruleSet.get((int)j).observersGauss.set(i, obsGauss);
                }
                obs.observeAttributeClass(inst.value(instAttIndex), (int)inst.classValue(), inst.weight());
                if (!inst.attribute(instAttIndex).isNumeric()) continue;
                obsGauss.observeAttributeClass(inst.value(instAttIndex), (int)inst.classValue(), inst.weight());
            }
            int count = this.getCount(inst, this.ruleSet.get((int)j).predicateSet);
            if (count == this.ruleSet.get((int)j).predicateSet.size()) {
                this.getRuleClass(inst, j);
            }
            if ((numInstanciaObservers = this.observersNumberInstance(inst, this.ruleSet.get((int)j).observers)) != 0 && this.gracePeriodOption.getValue() != 0) {
                remainder = numInstanciaObservers % this.gracePeriodOption.getValue();
            }
            if (remainder == 0) {
                this.observersTemp = this.ruleSet.get((int)j).observers;
                this.theBestAttributes(inst, this.observersTemp);
                Collections.sort(this.saveBestGlobalEntropy);
                boolean HB = this.checkBestAttrib(numInstanciaObservers, inst, this.ruleSet.get((int)j).observers);
                if (HB) {
                    double attributeValue = this.saveTheBest.get(3);
                    double symbol = this.saveTheBest.get(2);
                    double value = this.saveTheBest.get(0);
                    this.pred = new Predicates(attributeValue, symbol, value);
                    int countPred = 0;
                    for (int i = 0; i < this.ruleSet.get((int)j).predicateSet.size(); ++i) {
                        if (this.pred.getSymbol() == 0.0) {
                            if (this.ruleSet.get((int)j).predicateSet.get(i).getAttributeValue() == this.pred.getAttributeValue()) continue;
                            ++countPred;
                            continue;
                        }
                        if (this.ruleSet.get((int)j).predicateSet.get(i).getAttributeValue() == this.pred.getAttributeValue() && this.ruleSet.get((int)j).predicateSet.get(i).getSymbol() == this.pred.getSymbol() && this.ruleSet.get((int)j).predicateSet.get(i).getValue() == this.pred.getValue()) continue;
                        ++countPred;
                    }
                    if (countPred == this.ruleSet.get((int)j).predicateSet.size()) {
                        int countDifPred = 0;
                        ArrayList<Predicates> predicSetTemp = new ArrayList<Predicates>();
                        for (int x = 0; x < this.ruleSet.get((int)j).predicateSet.size(); ++x) {
                            predicSetTemp.add(this.ruleSet.get((int)j).predicateSet.get(x));
                        }
                        predicSetTemp.add(this.pred);
                        for (int f = 0; f < this.ruleSet.size(); ++f) {
                            int countDifPredTemp = 0;
                            if (this.ruleSet.get((int)f).predicateSet.size() == predicSetTemp.size()) {
                                for (int x = 0; x < this.ruleSet.get((int)f).predicateSet.size(); ++x) {
                                    if (this.ruleSet.get((int)f).predicateSet.get(x).getAttributeValue() != ((Predicates)predicSetTemp.get(x)).getAttributeValue() || this.ruleSet.get((int)f).predicateSet.get(x).getSymbol() != ((Predicates)predicSetTemp.get(x)).getSymbol() || this.ruleSet.get((int)f).predicateSet.get(x).getValue() != ((Predicates)predicSetTemp.get(x)).getValue()) continue;
                                    ++countDifPredTemp;
                                }
                                if (countDifPredTemp == predicSetTemp.size()) break;
                                ++countDifPred;
                                continue;
                            }
                            ++countDifPred;
                        }
                        if (countDifPred == this.ruleSet.size()) {
                            int f;
                            int countIqualPred;
                            if (this.pred.getSymbol() == 0.0) {
                                this.ruleSet.get((int)j).predicateSet.add(this.pred);
                                this.majority.get(j).clear();
                                this.ruleSet.get((int)j).obserClassDistrib = new DoubleVector();
                                this.ruleSet.get((int)j).observers = new AutoExpandVector();
                                this.ruleSet.get((int)j).observersGauss = new AutoExpandVector();
                            } else if (this.pred.getSymbol() == 1.0) {
                                countIqualPred = 0;
                                for (f = 0; f < this.ruleSet.get((int)j).predicateSet.size(); ++f) {
                                    if (this.pred.getAttributeValue() != this.ruleSet.get((int)j).predicateSet.get(f).getAttributeValue() || this.pred.getSymbol() != this.ruleSet.get((int)j).predicateSet.get(f).getSymbol()) continue;
                                    ++countIqualPred;
                                    if (!(this.pred.getValue() > this.ruleSet.get((int)j).predicateSet.get(f).getValue())) continue;
                                    this.ruleSet.get((int)j).predicateSet.remove(f);
                                    this.ruleSet.get((int)j).predicateSet.add(this.pred);
                                    this.majority.get(j).clear();
                                    this.ruleSet.get((int)j).obserClassDistrib = new DoubleVector();
                                    this.ruleSet.get((int)j).observers = new AutoExpandVector();
                                    this.ruleSet.get((int)j).observersGauss = new AutoExpandVector();
                                }
                                if (countIqualPred == 0) {
                                    this.ruleSet.get((int)j).predicateSet.add(this.pred);
                                    this.majority.get(j).clear();
                                    this.ruleSet.get((int)j).obserClassDistrib = new DoubleVector();
                                    this.ruleSet.get((int)j).observers = new AutoExpandVector();
                                    this.ruleSet.get((int)j).observersGauss = new AutoExpandVector();
                                }
                            } else {
                                countIqualPred = 0;
                                for (f = 0; f < this.ruleSet.get((int)j).predicateSet.size(); ++f) {
                                    if (this.pred.getAttributeValue() != this.ruleSet.get((int)j).predicateSet.get(f).getAttributeValue() || this.pred.getSymbol() != this.ruleSet.get((int)j).predicateSet.get(f).getSymbol()) continue;
                                    ++countIqualPred;
                                    if (!(this.pred.getValue() < this.ruleSet.get((int)j).predicateSet.get(f).getValue())) continue;
                                    this.ruleSet.get((int)j).predicateSet.remove(f);
                                    this.ruleSet.get((int)j).predicateSet.add(this.pred);
                                    this.majority.get(j).clear();
                                    this.ruleSet.get((int)j).obserClassDistrib = new DoubleVector();
                                    this.ruleSet.get((int)j).observers = new AutoExpandVector();
                                    this.ruleSet.get((int)j).observersGauss = new AutoExpandVector();
                                }
                                if (countIqualPred == 0) {
                                    this.ruleSet.get((int)j).predicateSet.add(this.pred);
                                    this.majority.get(j).clear();
                                    this.ruleSet.get((int)j).obserClassDistrib = new DoubleVector();
                                    this.ruleSet.get((int)j).observers = new AutoExpandVector();
                                    this.ruleSet.get((int)j).observersGauss = new AutoExpandVector();
                                }
                            }
                        }
                    }
                }
            }
            if (this.orderedRulesOption.isSet()) break;
        }
        if (!(ruleFired = countRuleFiredTrue > 0)) {
            this.saveBestValGlobalEntropy = new ArrayList();
            this.saveBestGlobalEntropy = new ArrayList();
            this.saveTheBest = new ArrayList();
            this.minEntropyTemp = Double.MAX_VALUE;
            this.minEntropyNominalAttrib = Double.MAX_VALUE;
            this.observedClassDistribution.addToValue((int)inst.classValue(), inst.weight());
            for (int i = 0; i < inst.numAttributes() - 1; ++i) {
                int instAttIndex = RuleClassifier.modelAttIndexToInstanceAttIndex(i, inst);
                AttributeClassObserver obs = this.attributeObservers.get(i);
                AttributeClassObserver obsGauss = this.attributeObserversGauss.get(i);
                if (obs == null) {
                    obs = inst.attribute(instAttIndex).isNominal() ? this.newNominalClassObserver() : this.newNumericClassObserver();
                    this.attributeObservers.set(i, obs);
                }
                if (obsGauss == null) {
                    obsGauss = inst.attribute(instAttIndex).isNumeric() ? this.newNumericClassObserver2() : null;
                    this.attributeObserversGauss.set(i, obsGauss);
                }
                obs.observeAttributeClass(inst.value(instAttIndex), (int)inst.classValue(), inst.weight());
                if (!inst.attribute(instAttIndex).isNumeric()) continue;
                obsGauss.observeAttributeClass(inst.value(instAttIndex), (int)inst.classValue(), inst.weight());
            }
            numInstanciaObservers = this.observersNumberInstance(inst, this.attributeObservers);
            if (numInstanciaObservers != 0 && this.gracePeriodOption.getValue() != 0) {
                remainder = numInstanciaObservers % this.gracePeriodOption.getValue();
            }
            if (remainder == 0) {
                this.observersTemp = this.attributeObservers;
                this.theBestAttributes(inst, this.observersTemp);
                Collections.sort(this.saveBestGlobalEntropy);
                boolean HB = this.checkBestAttrib(numInstanciaObservers, inst, this.attributeObservers);
                if (HB) {
                    int countDifRule = 0;
                    double attributeValue = this.saveTheBest.get(3);
                    double symbol = this.saveTheBest.get(2);
                    double value = this.saveTheBest.get(0);
                    this.pred = new Predicates(attributeValue, symbol, value);
                    Rule Rl = new Rule();
                    Rl.predicateSet.add(this.pred);
                    for (int i = 0; i < this.ruleSet.size(); ++i) {
                        if (this.ruleSet.get((int)i).predicateSet.size() == 1) {
                            if (this.ruleSet.get((int)i).predicateSet.get(0).getAttributeValue() == Rl.predicateSet.get(0).getAttributeValue() && this.ruleSet.get((int)i).predicateSet.get(0).getSymbol() == Rl.predicateSet.get(0).getSymbol() && this.ruleSet.get((int)i).predicateSet.get(0).getValue() == Rl.predicateSet.get(0).getValue()) continue;
                            ++countDifRule;
                            continue;
                        }
                        if (this.ruleSet.get((int)i).predicateSet.size() <= 1) continue;
                        ++countDifRule;
                    }
                    if (countDifRule == this.ruleSet.size() || this.ruleSet.isEmpty()) {
                        this.ruleSet.add(Rl);
                        this.majority.add(new ArrayList());
                        if (Rl.predicateSet.get(0).getSymbol() == -1.0 || Rl.predicateSet.get(0).getSymbol() == 1.0) {
                            double posClassDouble = this.saveTheBest.get(4);
                            int posClassInt = (int)posClassDouble;
                            this.ruleClassIndex.add(posClassInt);
                            String classe = inst.classAttribute().value(posClassInt);
                            this.ruleClassName.add(classe);
                        }
                    }
                    this.attributeObservers = new AutoExpandVector();
                    this.attributeObserversGauss = new AutoExpandVector();
                }
            }
        }
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
        StringUtils.appendNewline(out);
        StringUtils.appendIndented(out, indent, "Number of Rule: " + this.ruleSet.size());
        StringUtils.appendNewline(out);
        StringUtils.appendNewline(out);
        for (int k = 0; k < this.ruleSet.size(); ++k) {
            StringUtils.appendIndented(out, indent, "Rule " + (k + 1) + ": ");
            for (int i = 0; i < this.ruleSet.get((int)k).predicateSet.size(); ++i) {
                String nam;
                String val;
                if (this.ruleSet.get((int)k).predicateSet.size() == 1) {
                    if (this.ruleSet.get((int)k).predicateSet.get(i).getSymbol() == 0.0) {
                        String nam2 = this.instance.attribute((int)this.ruleSet.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                        val = this.instance.attribute((int)this.ruleSet.get((int)k).predicateSet.get(i).getAttributeValue()).value((int)this.ruleSet.get((int)k).predicateSet.get(i).getValue());
                        StringUtils.appendIndented(out, indent, nam2 + " = " + val + " --> " + this.getRuleMajorityClass(k, this.instance));
                        StringUtils.appendNewline(out);
                        continue;
                    }
                    if (this.ruleSet.get((int)k).predicateSet.get(i).getSymbol() == -1.0) {
                        String nam3 = this.instance.attribute((int)this.ruleSet.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                        StringUtils.appendIndented(out, indent, nam3 + " <= " + this.ruleSet.get((int)k).predicateSet.get(i).getValue() + " --> " + this.ruleClassName.get(k));
                        StringUtils.appendNewline(out);
                        continue;
                    }
                    String nam4 = this.instance.attribute((int)this.ruleSet.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                    StringUtils.appendIndented(out, indent, nam4 + " > " + this.ruleSet.get((int)k).predicateSet.get(i).getValue() + " --> " + this.ruleClassName.get(k));
                    StringUtils.appendNewline(out);
                    continue;
                }
                if (this.ruleSet.get((int)k).predicateSet.get(i).getSymbol() == 0.0) {
                    nam = this.instance.attribute((int)this.ruleSet.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                    val = this.instance.attribute((int)this.ruleSet.get((int)k).predicateSet.get(i).getAttributeValue()).value((int)this.ruleSet.get((int)k).predicateSet.get(i).getValue());
                    StringUtils.appendIndented(out, indent, nam + " = " + val + " ");
                } else if (this.ruleSet.get((int)k).predicateSet.get(i).getSymbol() == -1.0) {
                    nam = this.instance.attribute((int)this.ruleSet.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                    StringUtils.appendIndented(out, indent, nam + " <= " + this.ruleSet.get((int)k).predicateSet.get(i).getValue() + " ");
                } else {
                    nam = this.instance.attribute((int)this.ruleSet.get((int)k).predicateSet.get(i).getAttributeValue()).name();
                    StringUtils.appendIndented(out, indent, nam + " > " + this.ruleSet.get((int)k).predicateSet.get(i).getValue() + " ");
                }
                if (i < this.ruleSet.get((int)k).predicateSet.size() - 1) {
                    StringUtils.appendIndented(out, indent, "and ");
                    continue;
                }
                int count = this.getCountNominalAttrib(this.ruleSet.get((int)k).predicateSet);
                if (this.ruleSet.get((int)k).predicateSet.get(i).getSymbol() == 0.0 || count != 0) {
                    StringUtils.appendIndented(out, indent, " --> " + this.getRuleMajorityClass(k, this.instance));
                    StringUtils.appendNewline(out);
                    continue;
                }
                StringUtils.appendIndented(out, indent, " --> " + this.ruleClassName.get(k));
                StringUtils.appendNewline(out);
            }
            StringUtils.appendNewline(out);
        }
    }

    @Override
    public boolean isRandomizable() {
        return false;
    }

    public int getCountNominalAttrib(ArrayList<Predicates> predicateSet) {
        int count = 0;
        for (int i = 0; i < predicateSet.size(); ++i) {
            if (predicateSet.get(i).getSymbol() != 0.0) continue;
            ++count;
            break;
        }
        return count;
    }

    public void theBestAttributes(Instance instance, AutoExpandVector<AttributeClassObserver> observersParameter) {
        for (int z = 0; z < instance.numAttributes() - 1; ++z) {
            int instAttIndex = RuleClassifier.modelAttIndexToInstanceAttIndex(z, instance);
            ArrayList<Double> attribBest = new ArrayList<Double>();
            if (instance.attribute(instAttIndex).isNominal()) {
                this.minEntropyNominalAttrib = Double.MAX_VALUE;
                AutoExpandVector<DoubleVector> attribNominal = ((NominalAttributeClassObserver)observersParameter.get((int)z)).attValDistPerClass;
                this.findBestValEntropyNominalAtt(attribNominal);
                attribBest.add(this.saveBestEntropyNominalAttrib.getValue(0));
                attribBest.add(this.saveBestEntropyNominalAttrib.getValue(1));
                attribBest.add(this.saveBestEntropyNominalAttrib.getValue(2));
                this.saveBestValGlobalEntropy.add(attribBest);
                this.saveBestGlobalEntropy.add(this.saveBestEntropyNominalAttrib.getValue(1));
                continue;
            }
            this.root = ((BinaryTreeNumericAttributeClassObserver)observersParameter.get((int)z)).root;
            this.mainFindBestValEntropy(this.root);
            attribBest.add(this.saveBestEntropy.getValue(0));
            attribBest.add(this.saveBestEntropy.getValue(1));
            attribBest.add(this.saveBestEntropy.getValue(2));
            attribBest.add(this.saveBestEntropy.getValue(4));
            this.saveBestValGlobalEntropy.add(attribBest);
            this.saveBestGlobalEntropy.add(this.saveBestEntropy.getValue(1));
        }
    }

    public double nominalAttributeEntropy(ArrayList<Double> valorDistClassE) {
        double entropy = 0.0;
        double sum = 0.0;
        for (double d : valorDistClassE) {
            if (!(d > 0.0)) continue;
            entropy -= d * Utils.log2((double)d);
            sum += d;
        }
        return sum > 0.0 ? (entropy + sum * Utils.log2((double)sum)) / sum : 0.0;
    }

    public double entropy(DoubleVector ValorDistClassE) {
        double entropy = 0.0;
        double sum = 0.0;
        for (double d : ValorDistClassE.getArrayCopy()) {
            if (!(d > 0.0)) continue;
            entropy -= d * Utils.log2((double)d);
            sum += d;
        }
        return sum > 0.0 ? (entropy + sum * Utils.log2((double)sum)) / sum : 0.0;
    }

    public void findBestValEntropy(BinaryTreeNumericAttributeClassObserver.Node node, DoubleVector classCountL, DoubleVector classCountR, boolean status, double minEntropy, ArrayList<Double> parentCCLeft) {
        if (this.root != null) {
            double numInst = this.root.classCountsLeft.sumOfValues() + this.root.classCountsRight.sumOfValues();
            if (node != null) {
                double classCountREntropy;
                double classCountLEntropy;
                int numClass = 0;
                DoubleVector classCountLTemp = new DoubleVector();
                DoubleVector classCountRTemp = new DoubleVector();
                DoubleVector parentCCL = new DoubleVector();
                ArrayList<Double> parentCCLParameter = new ArrayList<Double>();
                for (int f = 0; f < node.classCountsLeft.numValues(); ++f) {
                    parentCCLParameter.add(node.classCountsLeft.getValue(f));
                }
                for (int p = 0; p < parentCCLeft.size(); ++p) {
                    parentCCL.addToValue(p, parentCCLeft.get(p));
                }
                numClass = classCountL.numValues() >= classCountR.numValues() ? classCountL.numValues() : classCountR.numValues();
                if (node.cut_point != this.root.cut_point) {
                    for (int i = 0; i < numClass; ++i) {
                        if (status) {
                            double parentss = parentCCL.getValue(i) - (node.classCountsLeft.getValue(i) + node.classCountsRight.getValue(i));
                            double left = classCountL.getValue(i) - node.classCountsRight.getValue(i) - parentss;
                            double right = classCountR.getValue(i) + node.classCountsRight.getValue(i) + parentss;
                            classCountLTemp.addToValue(i, left);
                            classCountRTemp.addToValue(i, right);
                        }
                        if (status) continue;
                        double left = classCountL.getValue(i) + node.classCountsLeft.getValue(i);
                        double right = classCountR.getValue(i) - node.classCountsLeft.getValue(i);
                        classCountLTemp.addToValue(i, left);
                        classCountRTemp.addToValue(i, right);
                    }
                } else {
                    classCountLTemp = classCountL;
                    classCountRTemp = classCountR;
                }
                double classCountLSum = classCountLTemp.sumOfValues();
                double classCountRSum = classCountRTemp.sumOfValues();
                if (classCountLSum > this.PminOption.getValue() * numInst && classCountRSum > this.PminOption.getValue() * numInst && classCountLSum / numInst * (classCountLEntropy = this.entropy(classCountLTemp)) + classCountRSum / numInst * (classCountREntropy = this.entropy(classCountRTemp)) <= minEntropy) {
                    this.minEntropyTemp = classCountLSum / numInst * classCountLEntropy + classCountRSum / numInst * classCountREntropy;
                    this.cutPointTemp = node.cut_point;
                    if (classCountLEntropy <= classCountREntropy) {
                        this.symbol = -1.0;
                        double value = 0.0;
                        double index = 0.0;
                        for (int h = 0; h < numClass; ++h) {
                            if (!(value <= classCountLTemp.getValue(h))) continue;
                            value = classCountLTemp.getValue(h);
                            index = h;
                        }
                        this.saveBestEntropy.setValue(0, this.cutPointTemp);
                        this.saveBestEntropy.setValue(1, classCountLEntropy);
                        this.saveBestEntropy.setValue(2, this.symbol);
                        this.saveBestEntropy.setValue(4, index);
                    } else {
                        this.symbol = 1.0;
                        double value = 0.0;
                        double index = 0.0;
                        for (int h = 0; h < numClass; ++h) {
                            if (!(value <= classCountRTemp.getValue(h))) continue;
                            value = classCountRTemp.getValue(h);
                            index = h;
                        }
                        this.saveBestEntropy.setValue(0, this.cutPointTemp);
                        this.saveBestEntropy.setValue(1, classCountREntropy);
                        this.saveBestEntropy.setValue(2, this.symbol);
                        this.saveBestEntropy.setValue(4, index);
                    }
                }
                this.findBestValEntropy(node.left, classCountLTemp, classCountRTemp, true, this.minEntropyTemp, parentCCLParameter);
                this.findBestValEntropy(node.right, classCountLTemp, classCountRTemp, false, this.minEntropyTemp, parentCCLParameter);
            }
        }
    }

    public void mainFindBestValEntropy(BinaryTreeNumericAttributeClassObserver.Node root) {
        if (root != null) {
            ArrayList<Double> parentClassCL = new ArrayList<Double>();
            DoubleVector classCountL = root.classCountsLeft;
            DoubleVector classCountR = root.classCountsRight;
            double numInst = root.classCountsLeft.sumOfValues() + root.classCountsRight.sumOfValues();
            double classCountLSum = root.classCountsLeft.sumOfValues();
            double classCountRSum = root.classCountsRight.sumOfValues();
            double classCountLEntropy = this.entropy(classCountL);
            double classCountREntropy = this.entropy(classCountR);
            this.minEntropyTemp = classCountLSum / numInst * classCountLEntropy + classCountRSum / numInst * classCountREntropy;
            for (int f = 0; f < root.classCountsLeft.numValues(); ++f) {
                parentClassCL.add(root.classCountsLeft.getValue(f));
            }
            this.findBestValEntropy(root, classCountL, classCountR, true, this.minEntropyTemp, parentClassCL);
        }
    }

    public void findBestValEntropyNominalAtt(AutoExpandVector<DoubleVector> attrib) {
        double sumValue = 0.0;
        int classNumVal = 0;
        ArrayList distClassValue = new ArrayList();
        this.saveBestEntropyNominalAttrib = new DoubleVector();
        for (int v = 0; v < attrib.size(); ++v) {
            if (attrib.get(v) == null || attrib.get(v).numValues() <= classNumVal) continue;
            classNumVal = attrib.get(v).numValues();
        }
        for (int d = 0; d < attrib.size(); ++d) {
            distClassValue.add(new ArrayList());
            double count = 0.0;
            if (attrib.get(d) == null) continue;
            for (int e = 0; e < classNumVal; ++e) {
                double valor = attrib.get(d).getValue(e);
                count += valor;
                ((ArrayList)distClassValue.get(d)).add(valor);
            }
        }
        for (int l = 0; l < distClassValue.size(); ++l) {
            if (!((ArrayList)distClassValue.get(l)).isEmpty()) continue;
            for (int h = 0; h < classNumVal; ++h) {
                ((ArrayList)distClassValue.get(l)).add(0.0);
            }
        }
        for (int i = 0; i < ((ArrayList)distClassValue.get(0)).size(); ++i) {
            ArrayList<Double> saveVal = new ArrayList<Double>();
            for (int j = 0; j < distClassValue.size(); ++j) {
                double valor = (Double)((ArrayList)distClassValue.get(j)).get(i);
                saveVal.add(valor);
            }
            sumValue = this.getSumOfValue(saveVal);
            double entropyVal = this.nominalAttributeEntropy(saveVal);
            if (!(entropyVal <= this.minEntropyNominalAttrib)) continue;
            this.minEntropyNominalAttrib = entropyVal;
            this.saveBestEntropyNominalAttrib.setValue(0, i);
            this.saveBestEntropyNominalAttrib.setValue(1, entropyVal);
            this.saveBestEntropyNominalAttrib.setValue(2, 0.0);
        }
    }

    public double getSumOfValue(ArrayList<Double> values) {
        double sum = 0.0;
        for (int w = 0; w < values.size(); ++w) {
            sum += values.get(w).doubleValue();
        }
        return sum;
    }

    public double ComputeHoeffdingBound(double range, double confidence, double n) {
        return Math.sqrt(range * range * Math.log(1.0 / confidence) / (2.0 * n));
    }

    public boolean checkBestAttrib(double n, Instance inst, AutoExpandVector<AttributeClassObserver> observerss) {
        double h0 = this.globalEntropy(inst, observerss);
        boolean isTheBest = false;
        double bestEntropy = this.saveBestGlobalEntropy.get(0);
        double secondBestEntropy = this.saveBestGlobalEntropy.get(1);
        double range = Utils.log2((double)this.numClass);
        double hoeffdingBound = this.ComputeHoeffdingBound(range, this.splitConfidenceOption.getValue(), n);
        if (h0 > bestEntropy && (secondBestEntropy - bestEntropy > hoeffdingBound || hoeffdingBound < this.tieThresholdOption.getValue())) {
            for (int i = 0; i < this.saveBestValGlobalEntropy.size(); ++i) {
                if (bestEntropy != this.saveBestValGlobalEntropy.get(i).get(1)) continue;
                this.saveTheBest.add(this.saveBestValGlobalEntropy.get(i).get(0));
                this.saveTheBest.add(this.saveBestValGlobalEntropy.get(i).get(1));
                this.saveTheBest.add(this.saveBestValGlobalEntropy.get(i).get(2));
                this.saveTheBest.add(Double.valueOf(i));
                if (this.saveTheBest.get(2) == 0.0) continue;
                this.saveTheBest.add(this.saveBestValGlobalEntropy.get(i).get(3));
            }
            isTheBest = true;
        } else {
            isTheBest = false;
        }
        return isTheBest;
    }

    protected int observersNumberInstance(Instance inst, AutoExpandVector<AttributeClassObserver> observerss) {
        int numberInstance = 0;
        for (int z = 0; z < inst.numAttributes() - 1; ++z) {
            numberInstance = 0;
            int instAttIndex = RuleClassifier.modelAttIndexToInstanceAttIndex(z, inst);
            if (inst.attribute(instAttIndex).isNumeric()) {
                BinaryTreeNumericAttributeClassObserver.Node rootNode = ((BinaryTreeNumericAttributeClassObserver)observerss.get((int)z)).root;
                if (rootNode == null) continue;
                numberInstance = (int)(rootNode.classCountsLeft.sumOfValues() + rootNode.classCountsRight.sumOfValues());
                break;
            }
            AutoExpandVector<DoubleVector> nominalAttrib = ((NominalAttributeClassObserver)observerss.get((int)z)).attValDistPerClass;
            for (int d = 0; d < nominalAttrib.size(); ++d) {
                if (nominalAttrib.get(d) == null) continue;
                for (int e = 0; e < nominalAttrib.get(d).numValues(); ++e) {
                    double value = nominalAttrib.get(d).getValue(e);
                    numberInstance += (int)value;
                }
            }
        }
        return numberInstance;
    }

    protected Integer getCount(Instance inst, ArrayList<Predicates> PredSet) {
        int count = 0;
        for (int y = 0; y < PredSet.size(); ++y) {
            int i = (int)PredSet.get(y).getAttributeValue();
            int instAttIndex = RuleClassifier.modelAttIndexToInstanceAttIndex(i, inst);
            if (inst.attribute(instAttIndex).isNominal()) {
                String val;
                if (PredSet.get(y).getSymbol() != 0.0 || (val = inst.attribute((int)PredSet.get(y).getAttributeValue()).value((int)PredSet.get(y).getValue())) != inst.stringValue(i) || inst.attribute(i).index() != inst.attribute((int)PredSet.get(y).getAttributeValue()).index()) continue;
                ++count;
                continue;
            }
            if (PredSet.get(y).getSymbol() == -1.0) {
                if (!(inst.value(i) <= PredSet.get(y).getValue()) || inst.attribute(i).index() != inst.attribute((int)PredSet.get(y).getAttributeValue()).index()) continue;
                ++count;
                continue;
            }
            if (PredSet.get(y).getSymbol() != 1.0 || !(inst.value(i) > PredSet.get(y).getValue()) || inst.attribute(i).index() != inst.attribute((int)PredSet.get(y).getAttributeValue()).index()) continue;
            ++count;
        }
        return count;
    }

    protected void getRuleClass(Instance inst, int ruleIndex) {
        double classID = inst.classValue();
        int pos = (int)classID;
        if (this.majority.get(ruleIndex).isEmpty()) {
            for (int i = 0; i < inst.numClasses(); ++i) {
                this.majority.get(ruleIndex).add(0);
            }
        }
        this.majority.get(ruleIndex).set(pos, this.majority.get(ruleIndex).get(pos) + 1);
    }

    protected String getRuleMajorityClass(int ruleIndex, Instance inst) {
        ArrayList<Integer> ruleClassOrdered = new ArrayList<Integer>();
        ArrayList<Integer> ruleClass = new ArrayList<Integer>();
        for (int j = 0; j < this.majority.get(ruleIndex).size(); ++j) {
            ruleClassOrdered.add(this.majority.get(ruleIndex).get(j));
            ruleClass.add(this.majority.get(ruleIndex).get(j));
        }
        Collections.sort(ruleClassOrdered);
        int maiorValor = (Integer)ruleClassOrdered.get(ruleClassOrdered.size() - 1);
        int posMaxValor = ruleClass.indexOf(maiorValor);
        String classe = inst.classAttribute().value(posMaxValor);
        return classe;
    }

    protected ArrayList<Double> oberversDistrib(Instance inst, AutoExpandVector<AttributeClassObserver> observerss) {
        ArrayList<Double> classDistrib = new ArrayList<Double>();
        for (int z = 0; z < inst.numAttributes() - 1; ++z) {
            classDistrib = new ArrayList();
            int instAttIndex = RuleClassifier.modelAttIndexToInstanceAttIndex(z, inst);
            if (inst.attribute(instAttIndex).isNumeric()) {
                BinaryTreeNumericAttributeClassObserver.Node rootNode = ((BinaryTreeNumericAttributeClassObserver)observerss.get((int)z)).root;
                if (rootNode == null) continue;
                for (int i = 0; i < rootNode.classCountsRight.numValues(); ++i) {
                    double sum = rootNode.classCountsLeft.getValue(i) + rootNode.classCountsRight.getValue(i);
                    classDistrib.add(sum);
                }
            } else {
                AutoExpandVector<DoubleVector> atribNominal = ((NominalAttributeClassObserver)observerss.get((int)z)).attValDistPerClass;
                for (int d = 0; d < atribNominal.size(); ++d) {
                    double sumValue = 0.0;
                    if (atribNominal.get(d) == null) continue;
                    for (int e = 0; e < atribNominal.get(d).numValues(); ++e) {
                        double value = atribNominal.get(d).getValue(e);
                        sumValue += (double)((int)value);
                    }
                    classDistrib.add(sumValue);
                }
            }
            break;
        }
        return classDistrib;
    }

    protected double globalEntropy(Instance inst, AutoExpandVector<AttributeClassObserver> observerss) {
        ArrayList<Double> classDistrib = this.oberversDistrib(inst, observerss);
        double globalEntropy = this.nominalAttributeEntropy(classDistrib);
        return globalEntropy;
    }

    protected double[] oberversDistribProb(Instance inst, AutoExpandVector<AttributeClassObserver> observerss) {
        double[] votes = new double[this.observedClassDistribution.numValues()];
        double sum = 0.0;
        ArrayList<Double> classDistrib = this.oberversDistrib(inst, observerss);
        for (int k = 0; k < classDistrib.size(); ++k) {
            sum += classDistrib.get(k).doubleValue();
        }
        for (int z = 0; z < classDistrib.size(); ++z) {
            votes[z] = classDistrib.get(z) / sum;
        }
        return votes;
    }

    protected double[] firstHit(Instance inst) {
        boolean fired = false;
        int countFired = 0;
        double[] votes = new double[this.observedClassDistribution.numValues()];
        for (int j = 0; j < this.ruleSet.size(); ++j) {
            if (!this.ruleSet.get(j).ruleEvaluate(inst)) continue;
            ++countFired;
            for (int z = 0; z < this.majority.get(j).size(); ++z) {
                votes[z] = this.ruleSet.get((int)j).obserClassDistrib.getValue(z) / this.ruleSet.get((int)j).obserClassDistrib.sumOfValues();
            }
            return votes;
        }
        fired = countFired > 0;
        if (!fired) {
            votes = this.oberversDistribProb(inst, this.attributeObservers);
        }
        return votes;
    }

    protected double[] weightedMax(Instance inst) {
        int countFired = 0;
        boolean fired = false;
        double highest = 0.0;
        double[] votes = new double[this.observedClassDistribution.numValues()];
        ArrayList<Double> ruleSetVotes = new ArrayList<Double>();
        ArrayList majorityProb = new ArrayList();
        for (int j = 0; j < this.ruleSet.size(); ++j) {
            ArrayList<Double> ruleProb = new ArrayList<Double>();
            if (!this.ruleSet.get(j).ruleEvaluate(inst)) continue;
            ++countFired;
            for (int z = 0; z < this.majority.get(j).size(); ++z) {
                ruleSetVotes.add(this.ruleSet.get((int)j).obserClassDistrib.getValue(z) / this.ruleSet.get((int)j).obserClassDistrib.sumOfValues());
                ruleProb.add(this.ruleSet.get((int)j).obserClassDistrib.getValue(z) / this.ruleSet.get((int)j).obserClassDistrib.sumOfValues());
            }
            majorityProb.add(ruleProb);
        }
        if (countFired > 0) {
            fired = true;
            Collections.sort(ruleSetVotes);
            highest = (Double)ruleSetVotes.get(ruleSetVotes.size() - 1);
            block2: for (int t = 0; t < majorityProb.size(); ++t) {
                for (int m = 0; m < ((ArrayList)majorityProb.get(t)).size(); ++m) {
                    if ((Double)((ArrayList)majorityProb.get(t)).get(m) != highest) continue;
                    for (int h = 0; h < ((ArrayList)majorityProb.get(t)).size(); ++h) {
                        votes[h] = (Double)((ArrayList)majorityProb.get(t)).get(h);
                    }
                    continue block2;
                }
            }
        } else {
            fired = false;
        }
        if (!fired) {
            votes = this.oberversDistribProb(inst, this.attributeObservers);
        }
        return votes;
    }

    protected double[] weightedSum(Instance inst) {
        boolean fired = false;
        int countFired = 0;
        double[] votes = new double[this.observedClassDistribution.numValues()];
        ArrayList<Double> weightSum = new ArrayList<Double>();
        ArrayList majorityProb = new ArrayList();
        for (int j = 0; j < this.ruleSet.size(); ++j) {
            ArrayList<Double> ruleProb = new ArrayList<Double>();
            if (!this.ruleSet.get(j).ruleEvaluate(inst)) continue;
            ++countFired;
            for (int z = 0; z < this.majority.get(j).size(); ++z) {
                ruleProb.add(this.ruleSet.get((int)j).obserClassDistrib.getValue(z) / this.ruleSet.get((int)j).obserClassDistrib.sumOfValues());
            }
            majorityProb.add(ruleProb);
        }
        if (countFired > 0) {
            fired = true;
            for (int m = 0; m < ((ArrayList)majorityProb.get(0)).size(); ++m) {
                double sum = 0.0;
                for (int t = 0; t < majorityProb.size(); ++t) {
                    sum += ((Double)((ArrayList)majorityProb.get(t)).get(m)).doubleValue();
                }
                weightSum.add(sum);
            }
            for (int h = 0; h < weightSum.size(); ++h) {
                votes[h] = (Double)weightSum.get(h) / (double)majorityProb.size();
            }
        } else {
            fired = false;
        }
        if (!fired) {
            votes = this.oberversDistribProb(inst, this.attributeObservers);
        }
        return votes;
    }

    protected AttributeClassObserver newNominalClassObserver() {
        return new NominalAttributeClassObserver();
    }

    protected AttributeClassObserver newNumericClassObserver() {
        return new BinaryTreeNumericAttributeClassObserver();
    }

    protected AttributeClassObserver newNumericClassObserver2() {
        return new GaussianNumericAttributeClassObserver();
    }

    public void manageMemory(int currentByteSize, int maxByteSize) {
    }
}

