/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules;

import java.util.ArrayList;
import java.util.Collections;
import moa.classifiers.bayes.NaiveBayes;
import moa.classifiers.rules.Rule;
import moa.classifiers.rules.RuleClassifier;
import moa.options.IntOption;
import weka.core.Instance;

public class RuleClassifierNBayes
extends RuleClassifier {
    private static final long serialVersionUID = 1L;
    public IntOption nbThresholdOption = new IntOption("nbThreshold", 'q', "The number of instances a leaf should observe before permitting Naive Bayes.", 0, 0, Integer.MAX_VALUE);

    @Override
    public double[] getVotesForInstance(Instance inst) {
        double[] votes = new double[this.observedClassDistribution.numValues()];
        switch (this.predictionFunctionOption.getChosenIndex()) {
            case 0: {
                votes = this.firstHitNB(inst);
                break;
            }
            case 1: {
                votes = this.weightedSumNB(inst);
                break;
            }
            case 2: {
                votes = this.weightedMaxNB(inst);
            }
        }
        return votes;
    }

    protected double[] firstHitNB(Instance inst) {
        int countFired = 0;
        boolean fired = false;
        double[] votes = new double[this.observedClassDistribution.numValues()];
        for (int j = 0; j < this.ruleSet.size(); ++j) {
            if (!((Rule)this.ruleSet.get(j)).ruleEvaluate(inst)) continue;
            ++countFired;
            if (((Rule)this.ruleSet.get((int)j)).obserClassDistrib.sumOfValues() >= (double)this.nbThresholdOption.getValue()) {
                votes = NaiveBayes.doNaiveBayesPredictionLog(inst, ((Rule)this.ruleSet.get((int)j)).obserClassDistrib, ((Rule)this.ruleSet.get((int)j)).observers, ((Rule)this.ruleSet.get((int)j)).observersGauss);
                votes = this.exponential(votes);
                votes = this.normalize(votes);
                break;
            }
            for (int z = 0; z < ((ArrayList)this.majority.get(j)).size(); ++z) {
                votes[z] = ((Rule)this.ruleSet.get((int)j)).obserClassDistrib.getValue(z) / ((Rule)this.ruleSet.get((int)j)).obserClassDistrib.sumOfValues();
            }
            break;
        }
        if (!(fired = countFired > 0)) {
            if (super.getWeightSeen() >= (double)this.nbThresholdOption.getValue()) {
                votes = NaiveBayes.doNaiveBayesPredictionLog(inst, this.observedClassDistribution, this.attributeObservers, this.attributeObserversGauss);
                votes = this.exponential(votes);
                votes = this.normalize(votes);
            } else {
                votes = super.oberversDistribProb(inst, this.attributeObservers);
            }
        }
        return votes;
    }

    protected double[] weightedMaxNB(Instance inst) {
        int countFired = 0;
        int count = 0;
        boolean fired = false;
        double highest = 0.0;
        double[] votes = new double[this.observedClassDistribution.numValues()];
        ArrayList<Double> ruleSetVotes = new ArrayList<Double>();
        ArrayList majorityProb = new ArrayList();
        for (int j = 0; j < this.ruleSet.size(); ++j) {
            ArrayList<Double> ruleClassDistribProb = new ArrayList<Double>();
            if (!((Rule)this.ruleSet.get(j)).ruleEvaluate(inst)) continue;
            ++countFired;
            if (((Rule)this.ruleSet.get((int)j)).obserClassDistrib.sumOfValues() >= (double)this.nbThresholdOption.getValue()) {
                votes = NaiveBayes.doNaiveBayesPredictionLog(inst, ((Rule)this.ruleSet.get((int)j)).obserClassDistrib, ((Rule)this.ruleSet.get((int)j)).observers, ((Rule)this.ruleSet.get((int)j)).observersGauss);
                votes = this.exponential(votes);
                votes = this.normalize(votes);
                continue;
            }
            ++count;
            for (int z = 0; z < ((ArrayList)this.majority.get(j)).size(); ++z) {
                ruleSetVotes.add(((Rule)this.ruleSet.get((int)j)).obserClassDistrib.getValue(z) / ((Rule)this.ruleSet.get((int)j)).obserClassDistrib.sumOfValues());
                ruleClassDistribProb.add(((Rule)this.ruleSet.get((int)j)).obserClassDistrib.getValue(z) / ((Rule)this.ruleSet.get((int)j)).obserClassDistrib.sumOfValues());
            }
            majorityProb.add(ruleClassDistribProb);
        }
        if (count > 0) {
            Collections.sort(ruleSetVotes);
            highest = (Double)ruleSetVotes.get(ruleSetVotes.size() - 1);
            block2: for (int t = 0; t < majorityProb.size(); ++t) {
                for (int m = 0; m < ((ArrayList)majorityProb.get(t)).size(); ++m) {
                    if ((Double)((ArrayList)majorityProb.get(t)).get(m) != highest) continue;
                    for (int h = 0; h < ((ArrayList)majorityProb.get(t)).size(); ++h) {
                        votes[h] = (Double)((ArrayList)majorityProb.get(t)).get(h);
                    }
                    continue block2;
                }
            }
        }
        if (!(fired = countFired > 0)) {
            if (super.getWeightSeen() >= (double)this.nbThresholdOption.getValue()) {
                votes = NaiveBayes.doNaiveBayesPredictionLog(inst, this.observedClassDistribution, this.attributeObservers, this.attributeObserversGauss);
                votes = this.exponential(votes);
                votes = this.normalize(votes);
            } else {
                votes = super.oberversDistribProb(inst, this.attributeObservers);
            }
        }
        return votes;
    }

    protected double[] weightedSumNB(Instance inst) {
        int countFired = 0;
        int count = 0;
        boolean fired = false;
        double[] votes = new double[this.observedClassDistribution.numValues()];
        ArrayList<Double> weightSum = new ArrayList<Double>();
        ArrayList majorityProb = new ArrayList();
        for (int j = 0; j < this.ruleSet.size(); ++j) {
            ArrayList<Double> ruleClassDistribProb = new ArrayList<Double>();
            if (!((Rule)this.ruleSet.get(j)).ruleEvaluate(inst)) continue;
            ++countFired;
            if (((Rule)this.ruleSet.get((int)j)).obserClassDistrib.sumOfValues() >= (double)this.nbThresholdOption.getValue()) {
                votes = NaiveBayes.doNaiveBayesPredictionLog(inst, ((Rule)this.ruleSet.get((int)j)).obserClassDistrib, ((Rule)this.ruleSet.get((int)j)).observers, ((Rule)this.ruleSet.get((int)j)).observersGauss);
                votes = this.exponential(votes);
                votes = this.normalize(votes);
                continue;
            }
            ++count;
            for (int z = 0; z < ((ArrayList)this.majority.get(j)).size(); ++z) {
                ruleClassDistribProb.add(((Rule)this.ruleSet.get((int)j)).obserClassDistrib.getValue(z) / ((Rule)this.ruleSet.get((int)j)).obserClassDistrib.sumOfValues());
            }
            majorityProb.add(ruleClassDistribProb);
        }
        if (count > 0) {
            for (int m = 0; m < ((ArrayList)majorityProb.get(0)).size(); ++m) {
                double sum = 0.0;
                for (int t = 0; t < majorityProb.size(); ++t) {
                    sum += ((Double)((ArrayList)majorityProb.get(t)).get(m)).doubleValue();
                }
                weightSum.add(sum);
            }
            for (int h = 0; h < weightSum.size(); ++h) {
                votes[h] = (Double)weightSum.get(h) / (double)majorityProb.size();
            }
        }
        if (!(fired = countFired > 0)) {
            if (super.getWeightSeen() >= (double)this.nbThresholdOption.getValue()) {
                votes = NaiveBayes.doNaiveBayesPredictionLog(inst, this.observedClassDistribution, this.attributeObservers, this.attributeObserversGauss);
                votes = this.exponential(votes);
                votes = this.normalize(votes);
            } else {
                votes = super.oberversDistribProb(inst, this.attributeObservers);
            }
        }
        return votes;
    }

    protected double[] normalize(double[] votes) {
        double sum = 0.0;
        for (int i = 0; i < votes.length; ++i) {
            sum += votes[i];
        }
        for (int j = 0; j < votes.length; ++j) {
            votes[j] = votes[j] / sum;
        }
        return votes;
    }

    protected double[] exponential(double[] votes) {
        for (int i = 0; i < votes.length; ++i) {
            votes[i] = Math.exp(votes[i]);
        }
        return votes;
    }
}

