/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import java.util.ArrayList;
import java.util.HashMap;
import moa.cluster.Clustering;
import moa.core.AutoExpandVector;
import moa.gui.visualization.DataPoint;
import weka.core.Instance;

public class CMM_GTAnalysis {
    private Clustering gtClustering;
    private ArrayList<CMMPoint> cmmpoints;
    private ArrayList<GTCluster> gt0Clusters;
    private ArrayList<Integer> noise;
    private int numPoints;
    private int numGTClusters;
    private int numGTClasses;
    private int numGT0Classes;
    private int numDims;
    private HashMap<Integer, Integer> mapTrueLabelToWorkLabel;
    private int[] mergeMap;
    private int noiseErrorByModel;
    private int pointErrorByModel;
    private boolean debug = false;
    private int knnNeighbourhood = 2;
    private double tauConnection = 0.5;
    private double clusterConnectionMaxPoints = this.knnNeighbourhood;
    private boolean useExpConnectivity = false;
    private double lambdaConnRefXValue = 0.01;
    private double lambdaConnX = 4.0;
    private double lamdaConn;

    public CMM_GTAnalysis(Clustering trueClustering, ArrayList<DataPoint> points, boolean enableClassMerge) {
        int p;
        int i;
        if (this.debug) {
            System.out.println("GT Analysis Debug Output");
        }
        this.noiseErrorByModel = 0;
        this.pointErrorByModel = 0;
        if (!enableClassMerge) {
            this.tauConnection = 1.0;
        }
        this.lamdaConn = -Math.log(this.lambdaConnRefXValue) / Math.log(2.0) / this.lambdaConnX;
        this.gtClustering = trueClustering;
        this.numPoints = points.size();
        this.numDims = points.get(0).numAttributes() - 1;
        this.numGTClusters = this.gtClustering.size();
        this.mapTrueLabelToWorkLabel = new HashMap();
        this.gt0Clusters = new ArrayList();
        int numWorkClasses = 0;
        for (i = 0; i < this.numGTClusters; ++i) {
            int label = (int)this.gtClustering.get(i).getGroundTruth();
            if (!this.mapTrueLabelToWorkLabel.containsKey(label)) {
                this.gt0Clusters.add(new GTCluster(numWorkClasses, label, i));
                this.mapTrueLabelToWorkLabel.put(label, numWorkClasses);
                ++numWorkClasses;
                continue;
            }
            this.gt0Clusters.get(this.mapTrueLabelToWorkLabel.get(label)).clusterRepresentations.add(i);
        }
        this.numGTClasses = numWorkClasses;
        this.mergeMap = new int[this.numGTClasses];
        for (i = 0; i < this.numGTClasses; ++i) {
            this.mergeMap[i] = i;
        }
        this.cmmpoints = new ArrayList();
        for (p = 0; p < points.size(); ++p) {
            CMMPoint cmdp = new CMMPoint(points.get(p), p);
            this.cmmpoints.add(cmdp);
        }
        this.noise = new ArrayList();
        for (p = 0; p < this.numPoints; ++p) {
            if (this.cmmpoints.get(p).isNoise()) {
                this.noise.add(p);
                continue;
            }
            this.gt0Clusters.get(this.cmmpoints.get(p).workclass()).points.add(p);
        }
        for (GTCluster gtc : this.gt0Clusters) {
            gtc.calculateKnn();
        }
        this.calculateGTClusterConnections();
        this.calculateGTPointQualities();
        if (this.debug) {
            System.out.println("GT Analysis Debug End");
        }
    }

    protected double getConnectionValue(CMMPoint cmmp, int clusterID) {
        AutoExpandVector<Double> knnDist = new AutoExpandVector<Double>();
        AutoExpandVector<Integer> knnPointIndex = new AutoExpandVector<Integer>();
        this.getKnnInCluster(cmmp, this.knnNeighbourhood, this.gt0Clusters.get(clusterID).points, knnDist, knnPointIndex);
        double avgDist = 0.0;
        for (int i = 0; i < knnDist.size(); ++i) {
            avgDist += knnDist.get(i).doubleValue();
        }
        if (knnDist.size() != 0) {
            avgDist /= (double)knnDist.size();
        } else {
            return 0.0;
        }
        double upperKnn = this.gt0Clusters.get(clusterID).knnMeanAvg + this.gt0Clusters.get(clusterID).knnDevAvg;
        if (avgDist < upperKnn) {
            return 1.0;
        }
        double conn = this.useExpConnectivity ? Math.pow(2.0, -this.lamdaConn * (avgDist - upperKnn) / upperKnn) : upperKnn / avgDist;
        if (Double.isNaN(conn)) {
            System.out.println("Connectivity NaN at " + cmmp.p.getTimestamp());
        }
        return conn;
    }

    private void getKnnInCluster(CMMPoint cmmp, int k, ArrayList<Integer> pointIDs, AutoExpandVector<Double> knnDist, AutoExpandVector<Integer> knnPointIndex) {
        for (int p1 = 0; p1 < pointIDs.size(); ++p1) {
            int index;
            int pid = pointIDs.get(p1);
            if (cmmp.pID == pid) continue;
            double dist = this.distance((Instance)cmmp, (Instance)this.cmmpoints.get(pid));
            if (knnDist.size() >= k && !(dist < knnDist.get(knnDist.size() - 1))) continue;
            for (index = 0; index < knnDist.size() && dist > knnDist.get(index); ++index) {
            }
            knnDist.add(index, dist);
            knnPointIndex.add(index, pid);
            if (knnDist.size() <= k) continue;
            knnDist.remove(knnDist.size() - 1);
            knnPointIndex.remove(knnPointIndex.size() - 1);
        }
    }

    private void calculateGTPointQualities() {
        for (int p = 0; p < this.numPoints; ++p) {
            CMMPoint cmdp = this.cmmpoints.get(p);
            if (cmdp.isNoise()) continue;
            cmdp.connectivity = this.getConnectionValue(cmdp, cmdp.workclass());
            cmdp.p.setMeasureValue("Connectivity", cmdp.connectivity);
        }
    }

    private void calculateGTClusterConnections() {
        for (int c0 = 0; c0 < this.gt0Clusters.size(); ++c0) {
            for (int c1 = 0; c1 < this.gt0Clusters.size(); ++c1) {
                this.gt0Clusters.get(c0).calculateClusterConnection(c1, true);
            }
        }
        boolean changedConnection = true;
        while (changedConnection) {
            if (this.debug) {
                System.out.println("Cluster Connection");
                for (int c = 0; c < this.gt0Clusters.size(); ++c) {
                    System.out.print("C" + this.gt0Clusters.get(c).label + " --> ");
                    for (int c1 = 0; c1 < this.gt0Clusters.get(c).connections.size(); ++c1) {
                        System.out.print(" C" + this.gt0Clusters.get(c1).label + ": " + this.gt0Clusters.get(c).connections.get(c1));
                    }
                    System.out.println("");
                }
                System.out.println("");
            }
            double max = 0.0;
            int maxIndexI = -1;
            int maxIndexJ = -1;
            changedConnection = false;
            for (int c0 = 0; c0 < this.gt0Clusters.size(); ++c0) {
                for (int c1 = c0 + 1; c1 < this.gt0Clusters.size(); ++c1) {
                    double min;
                    if (c0 == c1 || !((min = Math.min((Double)this.gt0Clusters.get(c0).connections.get(c1), (Double)this.gt0Clusters.get(c1).connections.get(c0))) > max)) continue;
                    max = min;
                    maxIndexI = c0;
                    maxIndexJ = c1;
                }
            }
            if (maxIndexI == -1 || !(max > this.tauConnection)) continue;
            this.gt0Clusters.get(maxIndexI).mergeCluster(maxIndexJ);
            if (this.debug) {
                System.out.println("Merging " + maxIndexI + " and " + maxIndexJ + " because of connection " + max);
            }
            changedConnection = true;
        }
        this.numGT0Classes = this.gt0Clusters.size();
    }

    public double getClassSeparability() {
        return (double)this.numGT0Classes / (double)this.numGTClasses;
    }

    public double getNoiseSeparability() {
        if (this.noise.isEmpty()) {
            return 1.0;
        }
        double connectivity = 0.0;
        for (int p : this.noise) {
            CMMPoint npoint = this.cmmpoints.get(p);
            double maxConnection = 0.0;
            for (int c = 0; c < this.gt0Clusters.size(); ++c) {
                double connection = this.getConnectionValue(npoint, c);
                if (!(connection > maxConnection)) continue;
                maxConnection = connection;
            }
            connectivity += maxConnection;
            npoint.p.setMeasureValue("MaxConnection", maxConnection);
        }
        return 1.0 - connectivity / (double)this.noise.size();
    }

    public double getModelQuality() {
        block0: for (int p = 0; p < this.numPoints; ++p) {
            CMMPoint cmdp = this.cmmpoints.get(p);
            for (int hc = 0; hc < this.numGTClusters; ++hc) {
                if (this.gtClustering.get(hc).getGroundTruth() == (double)cmdp.trueClass || !(this.gtClustering.get(hc).getInclusionProbability((Instance)cmdp) >= 1.0)) continue;
                if (!cmdp.isNoise()) {
                    ++this.pointErrorByModel;
                    continue block0;
                }
                ++this.noiseErrorByModel;
                continue block0;
            }
        }
        if (this.debug) {
            System.out.println("Error by model: noise " + this.noiseErrorByModel + " point " + this.pointErrorByModel);
        }
        return 1.0 - (double)(this.pointErrorByModel + this.noiseErrorByModel) / (double)this.numPoints;
    }

    protected CMMPoint getPoint(int index) {
        return this.cmmpoints.get(index);
    }

    protected GTCluster getGT0Cluster(int index) {
        return this.gt0Clusters.get(index);
    }

    protected int getNumberOfGT0Classes() {
        return this.numGT0Classes;
    }

    private double distance(Instance inst1, Instance inst2) {
        return this.distance(inst1, inst2.toDoubleArray());
    }

    private double distance(Instance inst1, double[] inst2) {
        double distance = 0.0;
        for (int i = 0; i < this.numDims; ++i) {
            double d = inst1.value(i) - inst2[i];
            distance += d * d;
        }
        return Math.sqrt(distance);
    }

    public String getParameterString() {
        String para = "";
        para = para + "k=" + this.knnNeighbourhood + ";";
        if (this.useExpConnectivity) {
            para = para + "lambdaConnX=" + this.lambdaConnX + ";";
            para = para + "lambdaConn=" + this.lamdaConn + ";";
            para = para + "lambdaConnRef=" + this.lambdaConnRefXValue + ";";
        }
        para = para + "m=" + this.clusterConnectionMaxPoints + ";";
        para = para + "tauConn=" + this.tauConnection + ";";
        return para;
    }

    protected class GTCluster {
        private ArrayList<Integer> points = new ArrayList();
        private ArrayList<Integer> clusterRepresentations = new ArrayList();
        private int workclass;
        private final int orgWorkClass;
        private final int label;
        private ArrayList<Integer> mergedWorkLabels = null;
        private double knnMeanAvg = 0.0;
        private double knnDevAvg = 0.0;
        private ArrayList<Double> connections = new ArrayList();

        private GTCluster(int workclass, int label, int gtClusteringID) {
            this.orgWorkClass = workclass;
            this.workclass = workclass;
            this.label = label;
            this.clusterRepresentations.add(gtClusteringID);
        }

        protected int getLabel() {
            return this.label;
        }

        protected double getInclusionProbability(CMMPoint point) {
            double prob = Double.MIN_VALUE;
            for (int c = 0; c < this.clusterRepresentations.size(); ++c) {
                double tmp_prob = CMM_GTAnalysis.this.gtClustering.get(this.clusterRepresentations.get(c)).getInclusionProbability((Instance)point);
                if (!(tmp_prob > prob)) continue;
                prob = tmp_prob;
            }
            return prob;
        }

        private void calculateKnn() {
            for (int p0 : this.points) {
                CMMPoint cmdp = (CMMPoint)((Object)CMM_GTAnalysis.this.cmmpoints.get(p0));
                if (cmdp.isNoise()) continue;
                AutoExpandVector knnDist = new AutoExpandVector();
                AutoExpandVector<Integer> knnPointIndex = new AutoExpandVector<Integer>();
                CMM_GTAnalysis.this.getKnnInCluster(cmdp, CMM_GTAnalysis.this.knnNeighbourhood, this.points, knnDist, knnPointIndex);
                double avgKnn = 0.0;
                for (int i = 0; i < knnDist.size(); ++i) {
                    avgKnn += ((Double)knnDist.get(i)).doubleValue();
                }
                if (knnDist.size() != 0) {
                    avgKnn /= (double)knnDist.size();
                }
                cmdp.knnInCluster = avgKnn;
                cmdp.knnIndices = knnPointIndex;
                cmdp.p.setMeasureValue("knnAvg", cmdp.knnInCluster);
                this.knnMeanAvg += avgKnn;
                this.knnDevAvg += Math.pow(avgKnn, 2.0);
            }
            this.knnMeanAvg /= (double)this.points.size();
            this.knnDevAvg /= (double)this.points.size();
            double variance = this.knnDevAvg - Math.pow(this.knnMeanAvg, 2.0);
            if (variance <= 0.0) {
                variance = 1.0E-50;
            }
            this.knnDevAvg = Math.sqrt(variance);
        }

        private void calculateClusterConnection(int otherCid, boolean initial) {
            double avgConnection = 0.0;
            if (this.workclass == otherCid) {
                avgConnection = 1.0;
            } else {
                AutoExpandVector<Double> kmax = new AutoExpandVector<Double>();
                AutoExpandVector<Integer> kmaxIndexes = new AutoExpandVector<Integer>();
                for (int p : this.points) {
                    int index;
                    CMMPoint cmdp = (CMMPoint)((Object)CMM_GTAnalysis.this.cmmpoints.get(p));
                    double con_p_Cj = CMM_GTAnalysis.this.getConnectionValue((CMMPoint)((Object)CMM_GTAnalysis.this.cmmpoints.get(p)), otherCid);
                    double connection = cmdp.connectivity * con_p_Cj;
                    if (initial) {
                        cmdp.p.setMeasureValue("Connection to C" + otherCid, con_p_Cj);
                    }
                    if (!((double)kmax.size() < CMM_GTAnalysis.this.clusterConnectionMaxPoints) && !(connection > (Double)kmax.get(kmax.size() - 1))) continue;
                    for (index = 0; index < kmax.size() && connection < (Double)kmax.get(index); ++index) {
                    }
                    kmax.add(index, connection);
                    kmaxIndexes.add(index, p);
                    if (!((double)kmax.size() > CMM_GTAnalysis.this.clusterConnectionMaxPoints)) continue;
                    kmax.remove(kmax.size() - 1);
                    kmaxIndexes.add(kmaxIndexes.size() - 1);
                }
                for (int k = 0; k < kmax.size(); ++k) {
                    avgConnection += ((Double)kmax.get(k)).doubleValue();
                }
                avgConnection /= (double)kmax.size();
            }
            if (otherCid < this.connections.size()) {
                this.connections.set(otherCid, avgConnection);
            } else if (this.connections.size() == otherCid) {
                this.connections.add(avgConnection);
            } else {
                System.out.println("Something is going really wrong with the connection listing!" + CMM_GTAnalysis.this.knnNeighbourhood + " " + CMM_GTAnalysis.this.tauConnection);
            }
        }

        private void mergeCluster(int mergeID) {
            if (mergeID < CMM_GTAnalysis.this.gt0Clusters.size()) {
                int c;
                for (int i = 0; i < CMM_GTAnalysis.this.numGTClasses; ++i) {
                    if (CMM_GTAnalysis.this.mergeMap[i] == mergeID) {
                        ((CMM_GTAnalysis)CMM_GTAnalysis.this).mergeMap[i] = this.workclass;
                    }
                    if (CMM_GTAnalysis.this.mergeMap[i] <= mergeID) continue;
                    int[] nArray = CMM_GTAnalysis.this.mergeMap;
                    int n = i;
                    nArray[n] = nArray[n] - 1;
                }
                GTCluster gtcMerge = (GTCluster)CMM_GTAnalysis.this.gt0Clusters.get(mergeID);
                if (CMM_GTAnalysis.this.debug) {
                    System.out.println("Merging C" + gtcMerge.workclass + " into C" + this.workclass + " with Con " + this.connections.get(mergeID) + " / " + gtcMerge.connections.get(this.workclass));
                }
                CMM_GTAnalysis.this.mapTrueLabelToWorkLabel.put(gtcMerge.label, this.workclass);
                for (Integer key : CMM_GTAnalysis.this.mapTrueLabelToWorkLabel.keySet()) {
                    int value = (Integer)CMM_GTAnalysis.this.mapTrueLabelToWorkLabel.get(key);
                    if (value == mergeID) {
                        CMM_GTAnalysis.this.mapTrueLabelToWorkLabel.put(key, this.workclass);
                    }
                    if (value <= mergeID) continue;
                    CMM_GTAnalysis.this.mapTrueLabelToWorkLabel.put(key, value - 1);
                }
                this.points.addAll(gtcMerge.points);
                this.clusterRepresentations.addAll(gtcMerge.clusterRepresentations);
                if (this.mergedWorkLabels == null) {
                    this.mergedWorkLabels = new ArrayList();
                }
                this.mergedWorkLabels.add(gtcMerge.orgWorkClass);
                if (gtcMerge.mergedWorkLabels != null) {
                    this.mergedWorkLabels.addAll(gtcMerge.mergedWorkLabels);
                }
                CMM_GTAnalysis.this.gt0Clusters.remove(mergeID);
                for (c = mergeID; c < CMM_GTAnalysis.this.gt0Clusters.size(); ++c) {
                    ((GTCluster)((CMM_GTAnalysis)CMM_GTAnalysis.this).gt0Clusters.get((int)c)).workclass = c;
                }
                this.calculateKnn();
                for (c = 0; c < CMM_GTAnalysis.this.gt0Clusters.size(); ++c) {
                    ((GTCluster)((CMM_GTAnalysis)CMM_GTAnalysis.this).gt0Clusters.get((int)c)).connections.remove(mergeID);
                    ((GTCluster)CMM_GTAnalysis.this.gt0Clusters.get(c)).calculateClusterConnection(this.workclass, false);
                    ((GTCluster)CMM_GTAnalysis.this.gt0Clusters.get(this.workclass)).calculateClusterConnection(c, false);
                }
            } else {
                System.out.println("Merge indices are not valid");
            }
        }
    }

    protected class CMMPoint
    extends DataPoint {
        protected DataPoint p;
        protected int pID;
        protected int trueClass;
        protected double connectivity;
        protected double knnInCluster;
        protected ArrayList<Integer> knnIndices;

        public CMMPoint(DataPoint point, int id) {
            super((Instance)point, point.getTimestamp());
            this.p = null;
            this.pID = 0;
            this.trueClass = -1;
            this.connectivity = 1.0;
            this.knnInCluster = 0.0;
            this.p = point;
            this.pID = id;
            this.trueClass = (int)point.classValue();
        }

        protected int workclass() {
            if (this.trueClass == -1) {
                return -1;
            }
            return (Integer)CMM_GTAnalysis.this.mapTrueLabelToWorkLabel.get(this.trueClass);
        }

        protected boolean isNoise() {
            return this.trueClass == -1;
        }
    }
}

