/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import java.util.ArrayList;
import moa.cluster.Clustering;
import moa.cluster.SphereCluster;
import moa.evaluation.MeasureCollection;
import moa.gui.visualization.DataPoint;
import weka.core.Instance;

public class General
extends MeasureCollection {
    private int numPoints;
    private int numFClusters;
    private int numDims;
    private double pointInclusionProbThreshold = 0.8;
    private Clustering clustering;
    private ArrayList<DataPoint> points;

    @Override
    protected String[] getNames() {
        String[] names = new String[]{"GPrecision", "GRecall", "Redundancy", "numCluster", "numClasses"};
        return names;
    }

    @Override
    public void evaluateClustering(Clustering clustering, Clustering trueClustering, ArrayList<DataPoint> points) throws Exception {
        this.points = points;
        this.clustering = clustering;
        this.numPoints = points.size();
        this.numFClusters = clustering.size();
        this.numDims = points.get(0).numAttributes() - 1;
        int totalRedundancy = 0;
        int trueCoverage = 0;
        int totalCoverage = 0;
        int numNoise = 0;
        for (int p = 0; p < this.numPoints; ++p) {
            int coverage = 0;
            for (int c = 0; c < this.numFClusters; ++c) {
                if (!(clustering.get(c).getInclusionProbability((Instance)points.get(p)) >= this.pointInclusionProbThreshold)) continue;
                ++coverage;
            }
            if (points.get(p).classValue() == -1.0) {
                ++numNoise;
            } else if (coverage > 0) {
                ++trueCoverage;
            }
            if (coverage > 0) {
                ++totalCoverage;
            }
            if (coverage <= 1) continue;
            ++totalRedundancy;
        }
        this.addValue("numCluster", (double)clustering.size());
        this.addValue("numClasses", (double)trueClustering.size());
        this.addValue("Redundancy", (double)totalRedundancy / (double)this.numPoints);
        this.addValue("GPrecision", totalCoverage == 0 ? 0.0 : (double)trueCoverage / (double)totalCoverage);
        this.addValue("GRecall", (double)trueCoverage / (double)(this.numPoints - numNoise));
    }

    private double computeOverlap() {
        for (int c = 0; c < this.numFClusters; ++c) {
            if (this.clustering.get(c) instanceof SphereCluster) continue;
            System.out.println("Overlap only supports Sphere Cluster. Found: " + this.clustering.get(c).getClass());
            return Double.NaN;
        }
        boolean[] overlap = new boolean[this.numFClusters];
        for (int c0 = 0; c0 < this.numFClusters; ++c0) {
            if (overlap[c0]) continue;
            SphereCluster s0 = (SphereCluster)this.clustering.get(c0);
            for (int c1 = c0; c1 < this.clustering.size(); ++c1) {
                SphereCluster s1;
                if (c1 == c0 || !(s0.overlapRadiusDegree(s1 = (SphereCluster)this.clustering.get(c1)) > 0.0)) continue;
                overlap[c1] = true;
                overlap[c0] = true;
            }
        }
        double totalOverlap = 0.0;
        for (int c0 = 0; c0 < this.numFClusters; ++c0) {
            if (!overlap[c0]) continue;
            totalOverlap += 1.0;
        }
        if (this.numFClusters > 0) {
            totalOverlap /= (double)this.numFClusters;
        }
        return totalOverlap;
    }

    private double computeCompactness() {
        if (this.numFClusters == 0) {
            return 0.0;
        }
        for (int c = 0; c < this.numFClusters; ++c) {
            if (this.clustering.get(c) instanceof SphereCluster) continue;
            System.out.println("Compactness only supports Sphere Cluster. Found: " + this.clustering.get(c).getClass());
            return Double.NaN;
        }
        double totalCompactness = 0.0;
        for (int c = 0; c < this.numFClusters; ++c) {
            ArrayList<DataPoint> containedPoints = new ArrayList<DataPoint>();
            for (int p = 0; p < this.numPoints; ++p) {
                if (!(this.clustering.get(c).getInclusionProbability((Instance)this.points.get(p)) >= this.pointInclusionProbThreshold)) continue;
                containedPoints.add(this.points.get(p));
            }
            double compactness = 0.0;
            if (containedPoints.size() > 1) {
                double cfRadius;
                SphereCluster minEnclosingCluster = new SphereCluster(containedPoints, this.numDims);
                double minRadius = minEnclosingCluster.getRadius();
                if (Math.abs(minRadius - (cfRadius = ((SphereCluster)this.clustering.get(c)).getRadius())) < 1.0E-11) {
                    compactness = 1.0;
                } else if (minRadius < cfRadius) {
                    compactness = minRadius / cfRadius;
                } else {
                    System.out.println("Optimal radius bigger then real one (" + (cfRadius - minRadius) + "), this is really wrong");
                    compactness = 1.0;
                }
            } else {
                double cfRadius = ((SphereCluster)this.clustering.get(c)).getRadius();
                if (cfRadius == 0.0) {
                    compactness = 1.0;
                }
            }
            totalCompactness += compactness;
            this.clustering.get(c).setMeasureValue("Compactness", Double.toString(compactness));
        }
        return totalCompactness / (double)this.numFClusters;
    }
}

