/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.generators;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import moa.core.InstancesHeader;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.options.FlagOption;
import moa.options.IntOption;
import moa.streams.InstanceStream;
import moa.tasks.TaskMonitor;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class STAGGERGenerator
extends AbstractOptionHandler
implements InstanceStream {
    private static final long serialVersionUID = 1L;
    public IntOption instanceRandomSeedOption = new IntOption("instanceRandomSeed", 'i', "Seed for random generation of instances.", 1);
    public IntOption functionOption = new IntOption("function", 'f', "Classification function used, as defined in the original paper.", 1, 1, 3);
    public FlagOption balanceClassesOption = new FlagOption("balanceClasses", 'b', "Balance the number of instances of each class.");
    protected static ClassFunction[] classificationFunctions = new ClassFunction[]{new ClassFunction(){

        @Override
        public int determineClass(int size, int color, int shape) {
            return size == 0 && color == 0 ? 0 : 1;
        }
    }, new ClassFunction(){

        @Override
        public int determineClass(int size, int color, int shape) {
            return color == 2 || shape == 1 ? 0 : 1;
        }
    }, new ClassFunction(){

        @Override
        public int determineClass(int size, int color, int shape) {
            return size == 1 || size == 2 ? 0 : 1;
        }
    }};
    protected InstancesHeader streamHeader;
    protected Random instanceRandom;
    protected boolean nextClassShouldBeZero;

    @Override
    public String getPurposeString() {
        return "Generates STAGGER Concept functions.";
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        FastVector attributes = new FastVector();
        FastVector sizeLabels = new FastVector();
        sizeLabels.addElement((Object)"small");
        sizeLabels.addElement((Object)"medium");
        sizeLabels.addElement((Object)"large");
        attributes.addElement((Object)new Attribute("size", (List)sizeLabels));
        FastVector colorLabels = new FastVector();
        colorLabels.addElement((Object)"red");
        colorLabels.addElement((Object)"blue");
        colorLabels.addElement((Object)"green");
        attributes.addElement((Object)new Attribute("color", (List)colorLabels));
        FastVector shapeLabels = new FastVector();
        shapeLabels.addElement((Object)"circle");
        shapeLabels.addElement((Object)"square");
        shapeLabels.addElement((Object)"triangle");
        attributes.addElement((Object)new Attribute("shape", (List)shapeLabels));
        FastVector classLabels = new FastVector();
        classLabels.addElement((Object)"false");
        classLabels.addElement((Object)"true");
        attributes.addElement((Object)new Attribute("class", (List)classLabels));
        this.streamHeader = new InstancesHeader(new Instances(this.getCLICreationString(InstanceStream.class), (ArrayList)attributes, 0));
        this.streamHeader.setClassIndex(this.streamHeader.numAttributes() - 1);
        this.restart();
    }

    @Override
    public long estimatedRemainingInstances() {
        return -1L;
    }

    @Override
    public InstancesHeader getHeader() {
        return this.streamHeader;
    }

    @Override
    public boolean hasMoreInstances() {
        return true;
    }

    @Override
    public boolean isRestartable() {
        return true;
    }

    @Override
    public Instance nextInstance() {
        int size = 0;
        int color = 0;
        int shape = 0;
        int group = 0;
        boolean desiredClassFound = false;
        while (!desiredClassFound) {
            size = this.instanceRandom.nextInt(3);
            color = this.instanceRandom.nextInt(3);
            shape = this.instanceRandom.nextInt(3);
            group = classificationFunctions[this.functionOption.getValue() - 1].determineClass(size, color, shape);
            if (!this.balanceClassesOption.isSet()) {
                desiredClassFound = true;
                continue;
            }
            if ((!this.nextClassShouldBeZero || group != 0) && (this.nextClassShouldBeZero || group != 1)) continue;
            desiredClassFound = true;
            this.nextClassShouldBeZero = !this.nextClassShouldBeZero;
        }
        InstancesHeader header = this.getHeader();
        DenseInstance inst = new DenseInstance(header.numAttributes());
        inst.setValue(0, (double)size);
        inst.setValue(1, (double)color);
        inst.setValue(2, (double)shape);
        inst.setDataset((Instances)header);
        inst.setClassValue((double)group);
        return inst;
    }

    @Override
    public void restart() {
        this.instanceRandom = new Random(this.instanceRandomSeedOption.getValue());
        this.nextClassShouldBeZero = false;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    protected static interface ClassFunction {
        public int determineClass(int var1, int var2, int var3);
    }
}

