/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks;

import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.tasks.NullMonitor;
import moa.tasks.Task;
import moa.tasks.TaskMonitor;

public abstract class AbstractTask
extends AbstractOptionHandler
implements Task {
    public String getTaskName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Object doTask() {
        return this.doTask(new NullMonitor(), null);
    }

    @Override
    public Object doTask(TaskMonitor monitor, ObjectRepository repository) {
        monitor.setCurrentActivity("Preparing options to " + this.getTaskName() + "...", -1.0);
        this.prepareClassOptions(monitor, repository);
        if (monitor.taskShouldAbort()) {
            return null;
        }
        monitor.setCurrentActivity("Doing task " + this.getTaskName() + "...", -1.0);
        Object result = this.doTaskImpl(monitor, repository);
        monitor.setCurrentActivity("Task " + this.getTaskName() + " complete.", 1.0);
        this.classOptionNamesToPreparedObjects = null;
        return result;
    }

    protected abstract Object doTaskImpl(TaskMonitor var1, ObjectRepository var2);

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }
}

