/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net;

import adams.core.Properties;
import adams.core.base.BasePassword;
import adams.env.Environment;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.standalone.TwitterConnection;
import twitter4j.Twitter;
import twitter4j.TwitterFactory;
import twitter4j.TwitterStream;

public class TwitterHelper {
    public static final String FILENAME = "Twitter.props";
    public static final String CONSUMER_KEY = "ConsumerKey";
    public static final String CONSUMER_SECRET = "ConsumerSecret";
    public static final String ACCESS_TOKEN = "AccessToken";
    public static final String ACCESS_TOKEN_SECRET = "AccessTokenSecret";
    protected static Properties m_Properties;

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            try {
                m_Properties = Environment.getInstance().read("twitter");
            }
            catch (Exception e) {
                m_Properties = new Properties();
            }
        }
        return m_Properties;
    }

    public static synchronized boolean writeProperties() {
        return TwitterHelper.writeProperties(TwitterHelper.getProperties());
    }

    public static synchronized boolean writeProperties(Properties props) {
        boolean result = Environment.getInstance().write("twitter", props);
        m_Properties = null;
        return result;
    }

    public static String getConsumerKey() {
        return TwitterHelper.getProperties().getPath(CONSUMER_KEY, "");
    }

    public static BasePassword getConsumerSecret() {
        return new BasePassword(TwitterHelper.getProperties().getPath(CONSUMER_SECRET, ""));
    }

    public static String getAccessToken() {
        return TwitterHelper.getProperties().getPath(ACCESS_TOKEN, "");
    }

    public static BasePassword getAccessTokenSecret() {
        return new BasePassword(TwitterHelper.getProperties().getPath(ACCESS_TOKEN_SECRET, ""));
    }

    protected static TwitterConnection getTwitterConnectionActor(AbstractActor actor) {
        return (TwitterConnection)ActorUtils.findClosestType((AbstractActor)actor, TwitterConnection.class, (boolean)true);
    }

    public static Twitter getTwitterConnection(AbstractActor actor) {
        TwitterConnection conn = TwitterHelper.getTwitterConnectionActor(actor);
        Twitter result = conn == null ? new TwitterFactory().getInstance() : conn.getTwitterConnection();
        return result;
    }

    public static TwitterStream getTwitterStreamConnection(AbstractActor actor) {
        TwitterStream result = null;
        TwitterConnection conn = TwitterHelper.getTwitterConnectionActor(actor);
        if (conn != null) {
            result = conn.getTwitterStreamConnection();
        }
        return result;
    }
}

