/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.GlobalActorHelper;
import adams.flow.core.GlobalActorReference;
import adams.flow.core.MutableActorHandler;
import adams.flow.processor.AbstractModifyingProcessor;
import adams.flow.processor.CleanUpProcessor;
import adams.flow.source.MOAClustererSetup;
import adams.flow.standalone.GlobalActors;
import adams.flow.transformer.MOAClusterer;
import adams.flow.transformer.MOATrainClusterer;
import java.util.List;

public class FixDeprecatedMOAClusterer
extends AbstractModifyingProcessor
implements CleanUpProcessor {
    private static final long serialVersionUID = -4170658262349662939L;

    public String globalInfo() {
        return "Replaces the MOAClusterer transformer with MOAClustererSetup and MOATrainClusterer instances";
    }

    protected void processActor(AbstractActor actor) {
        List clusterers = ActorUtils.enumerate((AbstractActor)actor, (Class[])new Class[]{MOAClusterer.class});
        for (AbstractActor clusterer : clusterers) {
            MOAClusterer cactor = (MOAClusterer)clusterer;
            String var = cactor.getOptionManager().getVariableForProperty("clusterer");
            if (cactor.getParent() instanceof GlobalActors) {
                MOAClustererSetup setup = new MOAClustererSetup();
                setup.setClusterer(cactor.getClusterer());
                if (var != null) {
                    setup.getOptionManager().setVariableForProperty("clusterer", var);
                }
                setup.setName(cactor.getName());
                ((MutableActorHandler)cactor.getParent()).set(cactor.index(), (AbstractActor)setup);
                this.m_Modified = true;
                continue;
            }
            GlobalActors global = GlobalActorHelper.createGlobalActors((AbstractActor)cactor, (boolean)true);
            MOAClustererSetup setup = new MOAClustererSetup();
            setup.setClusterer(cactor.getClusterer());
            if (var != null) {
                setup.getOptionManager().setVariableForProperty("clusterer", var);
            }
            global.add((AbstractActor)setup);
            MOATrainClusterer train = new MOATrainClusterer();
            train.setClusterer(new GlobalActorReference(setup.getName()));
            train.setOutputInterval(cactor.getOutputInterval());
            train.setName(cactor.getName());
            ((MutableActorHandler)cactor.getParent()).set(cactor.index(), (AbstractActor)train);
            this.m_Modified = true;
        }
    }
}

