/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.alg;

import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import org.ddogleg.nn.alg.KdTree;
import org.ddogleg.nn.alg.KdTreeSearch;

public class KdTreeSearchBbf
implements KdTreeSearch {
    int maxNodesSearched;
    int N;
    double maxDistance = Double.MAX_VALUE;
    PriorityQueue<Helper> queue = new PriorityQueue();
    KdTree[] trees;
    int numNodesSearched;
    double bestDistanceSq;
    KdTree.Node bestNode;
    List<Helper> unused = new ArrayList<Helper>();

    public KdTreeSearchBbf(int maxNodesSearched) {
        this.maxNodesSearched = maxNodesSearched;
    }

    @Override
    public void setTree(KdTree tree) {
        this.trees = new KdTree[]{tree};
        this.N = tree.N;
    }

    public void setTrees(KdTree[] trees) {
        this.trees = trees;
        this.N = trees[0].N;
    }

    @Override
    public void setMaxDistance(double maxDistance) {
        this.maxDistance = maxDistance;
    }

    @Override
    public KdTree.Node findClosest(double[] target) {
        this.numNodesSearched = 0;
        this.bestDistanceSq = this.maxDistance * this.maxDistance;
        this.bestNode = null;
        for (int i = 0; i < this.trees.length; ++i) {
            KdTree.Node root = this.trees[i].root;
            if (root == null) continue;
            this.searchNode(target, root);
        }
        while (!this.queue.isEmpty() && this.numNodesSearched++ < this.maxNodesSearched) {
            Helper h = (Helper)this.queue.remove();
            KdTree.Node n = h.node;
            this.recycle(h);
            if (h.closestPossibleSq >= this.bestDistanceSq) continue;
            this.searchNode(target, n);
        }
        this.unused.addAll(this.queue);
        this.queue.clear();
        return this.bestNode;
    }

    @Override
    public double getDistance() {
        return this.bestDistanceSq;
    }

    protected void searchNode(double[] target, KdTree.Node n) {
        while (true) {
            KdTree.Node further;
            KdTree.Node nearer;
            this.checkBestDistance(n, target);
            if (n.isLeaf()) break;
            double splitValue = n.point[n.split];
            if (target[n.split] <= splitValue) {
                nearer = n.left;
                further = n.right;
            } else {
                nearer = n.right;
                further = n.left;
            }
            double dx = splitValue - target[n.split];
            if (dx * dx < this.bestDistanceSq) {
                this.addToQueue(dx * dx, further, target);
            }
            n = nearer;
        }
    }

    private void addToQueue(double closestDistanceSq, KdTree.Node node, double[] target) {
        if (!node.isLeaf()) {
            Helper h = this.unused.isEmpty() ? new Helper() : this.unused.remove(this.unused.size() - 1);
            h.closestPossibleSq = closestDistanceSq;
            h.node = node;
            this.queue.add(h);
        } else {
            this.checkBestDistance(node, target);
        }
    }

    private void checkBestDistance(KdTree.Node node, double[] target) {
        double distanceSq = KdTree.distanceSq(node, target, this.N);
        if (distanceSq < this.bestDistanceSq) {
            this.bestDistanceSq = distanceSq;
            this.bestNode = node;
        }
    }

    private void recycle(Helper h) {
        this.unused.add(h);
    }

    private static class Helper
    implements Comparable<Helper> {
        double closestPossibleSq;
        KdTree.Node node;

        private Helper() {
        }

        @Override
        public int compareTo(Helper o) {
            if (this.closestPossibleSq < o.closestPossibleSq) {
                return -1;
            }
            if (this.closestPossibleSq > o.closestPossibleSq) {
                return 1;
            }
            return 0;
        }
    }
}

