/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.impl;

import org.ddogleg.optimization.impl.DoglegStepFtF;
import org.ddogleg.optimization.impl.TrustRegionStep;
import org.ejml.alg.dense.mult.VectorVectorMult;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.LinearSolver;
import org.ejml.factory.LinearSolverFactory;
import org.ejml.ops.CommonOps;
import org.ejml.ops.NormOps;
import org.ejml.ops.SpecializedOps;

public class DoglegStepF
implements TrustRegionStep {
    LinearSolver<DenseMatrix64F> pinv;
    private DenseMatrix64F gradient;
    private DenseMatrix64F residualsNeg = new DenseMatrix64F(1, 1);
    private double predicted;
    private boolean maxStep;
    protected DenseMatrix64F stepCauchy = new DenseMatrix64F(1, 1);
    private double distanceCauchy;
    private double alpha;
    protected DenseMatrix64F stepGN = new DenseMatrix64F(1, 1);
    private double distanceGN;
    double gnorm;
    DenseMatrix64F Jg = new DenseMatrix64F(1, 1);

    public DoglegStepF(LinearSolver<DenseMatrix64F> pinv) {
        this.pinv = pinv;
    }

    public DoglegStepF() {
        this((LinearSolver<DenseMatrix64F>)LinearSolverFactory.leastSquaresQrPivot((boolean)true, (boolean)false));
    }

    @Override
    public void init(int numParam, int numFunctions) {
        this.stepCauchy.reshape(numParam, 1);
        this.stepGN.reshape(numParam, 1);
        this.residualsNeg.reshape(numFunctions, 1);
        this.Jg.reshape(numFunctions, 1);
    }

    @Override
    public void setInputs(DenseMatrix64F x, DenseMatrix64F residuals, DenseMatrix64F J, DenseMatrix64F gradient, double fx) {
        this.gradient = gradient;
        if (!this.pinv.setA((Matrix64F)J)) {
            throw new RuntimeException("Solver failed");
        }
        CommonOps.scale((double)-1.0, (D1Matrix64F)residuals, (D1Matrix64F)this.residualsNeg);
        this.pinv.solve((Matrix64F)this.residualsNeg, (Matrix64F)this.stepGN);
        this.distanceGN = NormOps.normF((D1Matrix64F)this.stepGN);
        CommonOps.mult((RowD1Matrix64F)J, (RowD1Matrix64F)gradient, (RowD1Matrix64F)this.Jg);
        this.alpha = SpecializedOps.elementSumSq((D1Matrix64F)gradient) / SpecializedOps.elementSumSq((D1Matrix64F)this.Jg);
        this.gnorm = NormOps.normF((D1Matrix64F)gradient);
        this.distanceCauchy = this.alpha * this.gnorm;
    }

    @Override
    public void computeStep(double regionRadius, DenseMatrix64F step) {
        if (this.distanceGN <= regionRadius) {
            step.set((D1Matrix64F)this.stepGN);
            this.maxStep = this.distanceGN == regionRadius;
            this.predicted = -0.5 * VectorVectorMult.innerProd((D1Matrix64F)this.stepGN, (D1Matrix64F)this.gradient);
        } else if (this.distanceCauchy >= regionRadius) {
            this.cauchyStep(regionRadius, step);
        } else {
            this.combinedStep(regionRadius, step);
            this.maxStep = true;
        }
    }

    protected void cauchyStep(double regionRadius, DenseMatrix64F step) {
        double dist;
        if (this.distanceCauchy >= regionRadius) {
            this.maxStep = true;
            dist = regionRadius;
        } else {
            this.maxStep = false;
            dist = this.distanceCauchy;
        }
        CommonOps.scale((double)(-dist / this.gnorm), (D1Matrix64F)this.gradient, (D1Matrix64F)step);
        this.predicted = regionRadius * (2.0 * this.alpha * this.gnorm - regionRadius) / (2.0 * this.alpha);
    }

    protected void combinedStep(double regionRadius, DenseMatrix64F step) {
        CommonOps.scale((double)(-this.distanceCauchy / this.gnorm), (D1Matrix64F)this.gradient, (D1Matrix64F)this.stepCauchy);
        double beta = DoglegStepFtF.combinedStep(this.stepCauchy, this.stepGN, regionRadius, step);
        double predictedGN = -0.5 * VectorVectorMult.innerProd((D1Matrix64F)this.stepGN, (D1Matrix64F)this.gradient);
        this.predicted = 0.5 * this.alpha * (1.0 - beta) * (1.0 - beta) * this.gnorm * this.gnorm + beta * (2.0 - beta) * predictedGN;
    }

    @Override
    public double predictedReduction() {
        return this.predicted;
    }

    @Override
    public boolean isMaxStep() {
        return this.maxStep;
    }
}

