/*
 * Decompiled with CFR 0.152.
 */
package org.im4java.core;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.im4java.core.IMOperation;
import org.im4java.core.IdentifyCmd;
import org.im4java.core.InfoException;
import org.im4java.process.ArrayListOutputConsumer;

public class Info {
    private Hashtable<String, String> iAttributes = new Hashtable();
    private int iOldIndent = 0;
    private String iPrefix = "";

    public Info(String string) throws InfoException {
        this.getCompleteInfo(string);
    }

    public Info(String string, boolean bl) throws InfoException {
        if (!bl) {
            this.getCompleteInfo(string);
        } else {
            this.getBaseInfo(string);
        }
    }

    private void getCompleteInfo(String string) throws InfoException {
        IMOperation iMOperation = new IMOperation();
        iMOperation.verbose();
        iMOperation.addImage(string);
        try {
            IdentifyCmd identifyCmd = new IdentifyCmd();
            ArrayListOutputConsumer arrayListOutputConsumer = new ArrayListOutputConsumer();
            identifyCmd.setOutputConsumer(arrayListOutputConsumer);
            identifyCmd.run(iMOperation, new Object[0]);
            ArrayList<String> arrayList = arrayListOutputConsumer.getOutput();
            for (String string2 : arrayList) {
                this.parseLine(string2);
            }
        }
        catch (Exception exception) {
            throw new InfoException(exception);
        }
    }

    private void parseLine(String string) {
        int n = string.indexOf(string.trim()) / 2;
        String[] stringArray = string.trim().split(": ", 2);
        if (n < this.iOldIndent) {
            int n2 = this.iPrefix.length() - 1;
            for (int i = 0; i < this.iOldIndent - n; ++i) {
                n2 = this.iPrefix.lastIndexOf(58, n2 - 1);
            }
            this.iPrefix = n2 == -1 ? "" : this.iPrefix.substring(0, n2 + 1);
        }
        this.iOldIndent = n;
        if (stringArray.length == 1) {
            this.iPrefix = this.iPrefix + stringArray[0];
        } else {
            this.iAttributes.put(this.iPrefix + stringArray[0], stringArray[1]);
        }
    }

    private void getBaseInfo(String string) throws InfoException {
        IMOperation iMOperation = new IMOperation();
        iMOperation.ping();
        iMOperation.format("%m\n%W\n%H\n%g\n%z\n%r");
        iMOperation.addImage(string);
        try {
            IdentifyCmd identifyCmd = new IdentifyCmd();
            ArrayListOutputConsumer arrayListOutputConsumer = new ArrayListOutputConsumer();
            identifyCmd.setOutputConsumer(arrayListOutputConsumer);
            identifyCmd.run(iMOperation, new Object[0]);
            ArrayList<String> arrayList = arrayListOutputConsumer.getOutput();
            Iterator<String> iterator = arrayList.iterator();
            this.iAttributes.put("Format", iterator.next());
            this.iAttributes.put("Width", iterator.next());
            this.iAttributes.put("Height", iterator.next());
            this.iAttributes.put("Geometry", iterator.next());
            this.iAttributes.put("Depth", iterator.next());
            this.iAttributes.put("Class", iterator.next());
        }
        catch (Exception exception) {
            throw new InfoException(exception);
        }
    }

    public String getImageFormat() {
        return this.iAttributes.get("Format");
    }

    public int getImageWidth() throws InfoException {
        try {
            return Integer.parseInt(this.iAttributes.get("Width"));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InfoException(numberFormatException);
        }
    }

    public int getImageHeight() throws InfoException {
        try {
            return Integer.parseInt(this.iAttributes.get("Height"));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InfoException(numberFormatException);
        }
    }

    public int getImageDepth() throws InfoException {
        try {
            return Integer.parseInt(this.iAttributes.get("Depth"));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InfoException(numberFormatException);
        }
    }

    public String getImageGeometry() {
        return this.iAttributes.get("Geometry");
    }

    public String getImageClass() {
        return this.iAttributes.get("Class");
    }

    public String getProperty(String string) {
        return this.iAttributes.get(string);
    }

    public Enumeration<String> getPropertyNames() {
        return this.iAttributes.keys();
    }
}

