/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.data.image.AbstractImage;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.Serializable;
import java.util.Arrays;

@MixedCopyright(copyright="2011 Florian Brucker, http://www.florianbrucker.de", license=License.GPL3, url="http://www.florianbrucker.de/content/lbp/lbp.zip", note="Original classname: de.florianbrucker.ml.lbp.LBPSubModel")
public class LBP
implements Serializable {
    private static final long serialVersionUID = 7341236906408210443L;
    protected int r;
    protected int p;
    protected int b;
    protected float[] patternHist = null;
    protected float[] varHist = null;
    protected int imageCount = 0;

    public LBP(int p) {
        this(p, 1);
    }

    public LBP(int p, int r) {
        this(p, r, 0);
    }

    public LBP(int p, int r, int b) {
        this.p = p;
        this.r = r;
        this.b = b;
    }

    public void incorporate(AbstractImage image, boolean uniform) {
        this.incorporate(image.toBufferedImage().getData(), uniform);
    }

    public void incorporate(BufferedImage image, boolean uniform) {
        this.incorporate(image.getData(), uniform);
    }

    public void incorporate(Raster raster, boolean uniform) {
        if (uniform) {
            this.incorporateUniform(raster);
        } else {
            this.incorporateSimple(raster);
        }
    }

    protected void incorporateUniform(Raster raster) {
        int width = raster.getWidth();
        int height = raster.getHeight();
        float[] vars = null;
        if (this.b > 0) {
            int numPixels = (width - 2 * this.r) * (height - 2 * this.r);
            vars = new float[numPixels];
        }
        float[] g = new float[this.p];
        int[] s = new int[this.p];
        long[] rawPatternHist = new long[this.p + 2];
        Arrays.fill(rawPatternHist, 0L);
        for (int x = this.r; x < width - this.r; ++x) {
            for (int y = this.r; y < height - this.r; ++y) {
                float gc = raster.getSampleFloat(x, y, 0) / 255.0f;
                LBP.loadCircle(this.r, raster, x, y, g);
                int n = LBP.lbpriu2(gc, g, s);
                rawPatternHist[n] = rawPatternHist[n] + 1L;
                if (this.b <= 0) continue;
                int i = (x - this.r) * (height - 2 * this.r) + (y - this.r);
                vars[i] = LBP.var(g);
            }
        }
        this.updatePatternHistogram(rawPatternHist);
        if (this.b > 0) {
            this.updateVarianceHistogram(vars);
        }
        ++this.imageCount;
    }

    protected void incorporateSimple(Raster raster) {
        int width = raster.getWidth();
        int height = raster.getHeight();
        float[] vars = null;
        if (this.b > 0) {
            int numPixels = (width - 2 * this.r) * (height - 2 * this.r);
            vars = new float[numPixels];
        }
        float[] g = new float[this.p];
        int[] s = new int[this.p];
        long[] rawPatternHist = new long[this.p];
        Arrays.fill(rawPatternHist, 0L);
        for (int x = this.r; x < width - this.r; ++x) {
            for (int y = this.r; y < height - this.r; ++y) {
                float gc = raster.getSampleFloat(x, y, 0) / 255.0f;
                LBP.loadCircle(this.r, raster, x, y, g);
                int n = LBP.lbp(gc, g, s);
                rawPatternHist[n] = rawPatternHist[n] + 1L;
                if (this.b <= 0) continue;
                int i = (x - this.r) * (height - 2 * this.r) + (y - this.r);
                vars[i] = LBP.var(g);
            }
        }
        this.updatePatternHistogram(rawPatternHist);
        if (this.b > 0) {
            this.updateVarianceHistogram(vars);
        }
        ++this.imageCount;
    }

    protected void updatePatternHistogram(long[] rawHist) {
        int i;
        long sum = 0L;
        for (i = 0; i < this.p + 2; ++i) {
            sum += rawHist[i];
        }
        if (this.imageCount == 0) {
            this.patternHist = new float[this.p + 2];
            for (i = 0; i < this.p + 2; ++i) {
                this.patternHist[i] = (float)((double)rawHist[i] / (double)sum);
            }
        } else {
            for (i = 0; i < this.p + 2; ++i) {
                float x = (float)((double)rawHist[i] / (double)sum);
                this.patternHist[i] = ((float)this.imageCount * this.patternHist[i] + x) / (float)(this.imageCount + 1);
            }
        }
    }

    protected float[] createVarianceHistogram(float[] vars) {
        int i;
        float[] h = new float[this.b];
        for (i = 0; i < vars.length; ++i) {
            int bin;
            float f = (float)(Math.max(Math.log10(vars[i]), -6.0) + 6.0) / 6.0f;
            int n = bin = (int)((double)((float)this.b * f) - 1.0E-6);
            h[n] = h[n] + 1.0f;
        }
        i = 0;
        while (i < this.b) {
            int n = i++;
            h[n] = h[n] / (float)vars.length;
        }
        return h;
    }

    protected void updateVarianceHistogram(float[] vars) {
        if (this.imageCount == 0) {
            this.varHist = this.createVarianceHistogram(vars);
        } else {
            float[] newHist = this.createVarianceHistogram(vars);
            for (int i = 0; i < this.b; ++i) {
                this.varHist[i] = ((float)this.imageCount * this.varHist[i] + newHist[i]) / (float)(this.imageCount + 1);
            }
        }
    }

    public int getImageCount() {
        return this.imageCount;
    }

    public float[] getPatternHistogram() {
        return this.patternHist;
    }

    public float[] getVarianceHistogram() {
        return this.varHist;
    }

    public String toString() {
        int i;
        StringBuilder s = new StringBuilder("");
        for (i = 0; i < this.p + 2; ++i) {
            s.append(this.patternHist[i]);
            if (i >= this.p + 1) continue;
            s.append("/");
        }
        s.append(":");
        for (i = 0; i < this.b; ++i) {
            s.append(this.varHist[i]);
            if (i >= this.b - 1) continue;
            s.append("/");
        }
        return s.toString();
    }

    public static int getHistogramLength(int p, boolean uniform) {
        if (uniform) {
            return p + 2;
        }
        return p;
    }

    protected static float interpolate(Raster raster, float x, float y, int b) {
        int y2;
        int y1;
        int x2;
        int x1;
        int xr = Math.round(x);
        if ((double)Math.abs(x - (float)xr) < 1.0E-4) {
            x1 = xr;
            x2 = xr;
            x = 0.0f;
        } else {
            x1 = (int)Math.floor(x);
            x2 = x1 + 1;
            x -= (float)x1;
        }
        int yr = Math.round(y);
        if ((double)Math.abs(y - (float)yr) < 1.0E-4) {
            y1 = yr;
            y2 = yr;
            y = 0.0f;
        } else {
            y1 = (int)Math.floor(y);
            y2 = y1 + 1;
            y -= (float)y1;
        }
        float ll = raster.getSampleFloat(x1, y1, b) / 255.0f;
        float ul = raster.getSampleFloat(x1, y2, b) / 255.0f;
        float lr = raster.getSampleFloat(x2, y1, b) / 255.0f;
        float ur = raster.getSampleFloat(x2, y2, b) / 255.0f;
        return ll * (1.0f - x) * (1.0f - y) + lr * x * (1.0f - y) + ul * (1.0f - x) * y + ur * x * y;
    }

    protected static void loadCircle(int r, Raster raster, int x, int y, float[] g) {
        int p = g.length;
        float f = (float)Math.PI * 2 / (float)p;
        for (int i = 0; i < p; ++i) {
            float gx = (float)x - (float)r * (float)Math.sin((float)i * f);
            float gy = (float)y + (float)r * (float)Math.cos((float)i * f);
            g[i] = LBP.interpolate(raster, gx, gy, 0);
        }
    }

    protected static int lbp(float gc, float[] g, int[] s) {
        int p = g.length;
        for (int i = 0; i < p; ++i) {
            s[i] = g[i] - gc >= 0.0f ? 1 : 0;
        }
        int sum = 0;
        for (int i = 0; i < p; ++i) {
            sum += s[i];
        }
        return sum;
    }

    protected static int lbpriu2(float gc, float[] g, int[] s) {
        int p = g.length;
        for (int i = 0; i < p; ++i) {
            s[i] = g[i] - gc >= 0.0f ? 1 : 0;
        }
        int u = 0;
        for (int i = 0; i < p; ++i) {
            u += s[i] == s[(i + 1) % p] ? 0 : 1;
        }
        if (u <= 2) {
            int sum = 0;
            for (int i = 0; i < p; ++i) {
                sum += s[i];
            }
            return sum;
        }
        return p + 1;
    }

    protected static float var(float[] g) {
        float mu = 0.0f;
        int p = g.length;
        for (int i = 0; i < p; ++i) {
            mu += g[i];
        }
        mu /= (float)p;
        float v = 0.0f;
        for (int i = 0; i < p; ++i) {
            v += (g[i] - mu) * (g[i] - mu);
        }
        return v / (float)p;
    }
}

