/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagej.transformer.crop;

import adams.data.imagej.transformer.crop.AbstractCropAlgorithm;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.process.ImageProcessor;

public class FrameCropAlgorithm
extends AbstractCropAlgorithm {
    private static final long serialVersionUID = -4663715509860132916L;
    protected static final int X = 0;
    protected static final int Y = 1;
    protected Roi m_CropArea;
    protected int m_XCropMax;
    protected int m_XCropMin;
    protected int m_YCropMax;
    protected int m_YCropMin;
    protected int m_Threshold;
    protected int m_Background;
    protected int m_Foreground;

    public String globalInfo() {
        return "this class crops a framed image. It can't crop a special object!";
    }

    @Override
    protected ImagePlus doCrop(ImagePlus img) {
        ImagePlus imp = img.duplicate();
        ImageProcessor ip = imp.getProcessor().convertToByte(true);
        ImageProcessor original = img.getProcessor();
        int width = imp.getProcessor().getWidth();
        int height = imp.getProcessor().getHeight();
        this.m_Threshold = ip.getAutoThreshold();
        this.m_XCropMax = this.findMaximum(ip, width, height, 0);
        this.m_XCropMin = this.findMinimum(ip, width, height, 0);
        this.m_YCropMax = this.findMaximum(ip, height, width, 1);
        this.m_YCropMin = this.findMinimum(ip, height, width, 1);
        if (this.m_XCropMax == -1 || this.m_XCropMin == -1 || this.m_YCropMax == -1 || this.m_YCropMin == -1) {
            return img;
        }
        this.m_CropArea = new Roi(this.m_XCropMin, this.m_YCropMin, this.m_XCropMax - this.m_XCropMin, this.m_YCropMax - this.m_YCropMin);
        original.setRoi(this.m_CropArea);
        original = original.crop();
        img.setProcessor(original);
        return img;
    }

    protected int findMinimum(ImageProcessor ip, int outerLoop, int innerLoop, int dimension) {
        for (int i = 0; i < outerLoop; ++i) {
            for (int j = 0; j < innerLoop; ++j) {
                if (dimension == 1) {
                    if (ip.getPixel(j, i) < this.m_Threshold) {
                        ++this.m_Background;
                        continue;
                    }
                    ++this.m_Foreground;
                    continue;
                }
                if (dimension == 0) {
                    if (ip.getPixel(i, j) < this.m_Threshold) {
                        ++this.m_Background;
                        continue;
                    }
                    ++this.m_Foreground;
                    continue;
                }
                return -1;
            }
            if (this.m_Foreground > this.m_Background) {
                return i;
            }
            this.m_Background = 0;
            this.m_Foreground = 0;
        }
        this.m_Background = 0;
        this.m_Foreground = 0;
        return -1;
    }

    protected int findMaximum(ImageProcessor ip, int outerLoop, int innerLoop, int dimension) {
        for (int i = outerLoop - 1; i >= 0; --i) {
            for (int j = 0; j < innerLoop; ++j) {
                if (dimension == 1) {
                    if (ip.getPixel(j, i) < this.m_Threshold) {
                        ++this.m_Background;
                        continue;
                    }
                    ++this.m_Foreground;
                    continue;
                }
                if (dimension == 0) {
                    if (ip.getPixel(i, j) < this.m_Threshold) {
                        ++this.m_Background;
                        continue;
                    }
                    ++this.m_Foreground;
                    continue;
                }
                return -1;
            }
            if (this.m_Foreground > this.m_Background) {
                return i;
            }
            this.m_Background = 0;
            this.m_Foreground = 0;
        }
        this.m_Background = 0;
        this.m_Foreground = 0;
        return -1;
    }

    @Override
    public int getXValue() {
        return this.m_XCropMin;
    }

    @Override
    public int getYValue() {
        return this.m_YCropMin;
    }
}

