/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.plugins;

import adams.data.image.AbstractImage;
import adams.data.image.BufferedImageContainer;
import adams.data.jai.transformer.AbstractJAITransformer;
import adams.data.jai.transformer.PassThrough;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.visualization.image.plugins.AbstractImageFilter;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.image.BufferedImage;

public class JAITransformer
extends AbstractImageFilter {
    private static final long serialVersionUID = -3146372359577147914L;

    public String getCaption() {
        return "JAI transformer...";
    }

    protected BufferedImage filter(BufferedImage image) {
        BufferedImage result = null;
        GenericObjectEditorDialog dialog = this.m_CurrentPanel.getParentDialog() != null ? new GenericObjectEditorDialog(this.m_CurrentPanel.getParentDialog()) : new GenericObjectEditorDialog(this.m_CurrentPanel.getParentFrame());
        dialog.getGOEEditor().setClassType(AbstractJAITransformer.class);
        dialog.getGOEEditor().setCanChangeClassInDialog(true);
        if (this.hasLastSetup()) {
            dialog.setCurrent(this.getLastSetup());
        } else {
            dialog.setCurrent((Object)new PassThrough());
        }
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.setLocationRelativeTo((Component)this.m_CurrentPanel);
        dialog.setVisible(true);
        if (dialog.getResult() != 0) {
            this.m_CanceledByUser = true;
            return result;
        }
        this.setLastSetup(dialog.getCurrent());
        AbstractJAITransformer transformer = (AbstractJAITransformer)((Object)dialog.getCurrent());
        BufferedImageContainer input = new BufferedImageContainer();
        input.setImage((Object)image);
        BufferedImageContainer[] transformed = (BufferedImageContainer[])transformer.transform((AbstractImage)input);
        if (transformed.length == 0) {
            this.m_FilterError = "No filtered image generated!";
        }
        if (transformed.length > 1) {
            this.getLogger().warning("Generated more than one image, using only first one.");
        }
        if (transformed.length >= 1) {
            result = (BufferedImage)transformed[0].getImage();
        }
        return result;
    }
}

