/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.selection;

import adams.gui.visualization.image.selection.AbstractSelectionProcessor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

public abstract class AbstractPaintingSelectionProcessor
extends AbstractSelectionProcessor {
    private static final long serialVersionUID = 5301544099367524209L;
    protected Color m_Color;
    protected float m_StrokeThickness;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("color", "color", (Object)this.getDefaultColor());
        this.m_OptionManager.add("stroke-thickness", "strokeThickness", (Object)Float.valueOf(this.getDefaultStrokeThickness()), (Number)Float.valueOf(0.01f), null);
    }

    protected Color getDefaultColor() {
        return Color.BLUE;
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.reset();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color to use for painting.";
    }

    protected float getDefaultStrokeThickness() {
        return 1.0f;
    }

    public void setStrokeThickness(float value) {
        this.m_StrokeThickness = value;
        this.reset();
    }

    public float getStrokeThickness() {
        return this.m_StrokeThickness;
    }

    public String strokeThicknessTipText() {
        return "The thickness of the stroke.";
    }

    protected float applyStroke(Graphics g, float thickness) {
        float result = 1.0f;
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            if (g2d.getStroke() instanceof BasicStroke) {
                result = ((BasicStroke)g2d.getStroke()).getLineWidth();
            }
            g2d.setStroke(new BasicStroke(this.m_StrokeThickness));
        }
        return result;
    }
}

