/*
 * Decompiled with CFR 0.152.
 */
package JSci.mathml;

import JSci.mathml.MathMLDocumentImpl;
import JSci.mathml.MathMLElementImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.mathml.MathMLMatrixElement;
import org.w3c.dom.mathml.MathMLMatrixrowElement;
import org.w3c.dom.mathml.MathMLNodeList;

public class MathMLMatrixElementImpl
extends MathMLElementImpl
implements MathMLMatrixElement {
    public MathMLMatrixElementImpl(MathMLDocumentImpl mathMLDocumentImpl, String string) {
        super(mathMLDocumentImpl, string);
    }

    public int getNrows() {
        return this.getRowsGetLength();
    }

    public int getNcols() {
        return this.getRow(1).getNEntries();
    }

    public MathMLNodeList getRows() {
        return new MathMLNodeList(){

            public int getLength() {
                return MathMLMatrixElementImpl.this.getRowsGetLength();
            }

            public Node item(int n) {
                return MathMLMatrixElementImpl.this.getRowsItem(n);
            }
        };
    }

    public MathMLMatrixrowElement getRow(int n) throws DOMException {
        Node node = this.getRowsItem(n - 1);
        if (node == null) {
            throw new DOMException(1, "Index out of bounds");
        }
        return (MathMLMatrixrowElement)node;
    }

    public MathMLMatrixrowElement setRow(MathMLMatrixrowElement mathMLMatrixrowElement, int n) throws DOMException {
        int n2 = this.getRowsGetLength();
        if (n < 1 || n > n2 + 1) {
            throw new DOMException(1, "Index out of bounds");
        }
        if (n == n2 + 1) {
            return (MathMLMatrixrowElement)this.appendChild((Node)mathMLMatrixrowElement);
        }
        return (MathMLMatrixrowElement)this.replaceChild((Node)mathMLMatrixrowElement, this.getRowsItem(n - 1));
    }

    public MathMLMatrixrowElement insertRow(MathMLMatrixrowElement mathMLMatrixrowElement, int n) throws DOMException {
        int n2 = this.getRowsGetLength();
        if (n < 0 || n > n2 + 1) {
            throw new DOMException(1, "Index out of bounds");
        }
        if (n == 0 || n == n2 + 1) {
            return (MathMLMatrixrowElement)this.appendChild((Node)mathMLMatrixrowElement);
        }
        return (MathMLMatrixrowElement)this.insertBefore((Node)mathMLMatrixrowElement, this.getRowsItem(n - 1));
    }

    public MathMLMatrixrowElement removeRow(int n) throws DOMException {
        Node node = this.getRowsItem(n - 1);
        if (node == null) {
            throw new DOMException(1, "Index out of bounds");
        }
        return (MathMLMatrixrowElement)this.removeChild(node);
    }

    public void deleteRow(int n) throws DOMException {
        this.removeRow(n);
    }

    private int getRowsGetLength() {
        int n = this.getLength();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!(this.item(i) instanceof MathMLMatrixrowElement)) continue;
            ++n2;
        }
        return n2;
    }

    private Node getRowsItem(int n) {
        int n2 = this.getRowsGetLength();
        if (n < 0 || n >= n2) {
            return null;
        }
        Node node = null;
        int n3 = -1;
        int n4 = 0;
        while (n3 < n) {
            node = this.item(n4);
            if (node instanceof MathMLMatrixrowElement) {
                ++n3;
            }
            ++n4;
        }
        return node;
    }
}

