/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.image;

import de.intarsys.pdf.platform.cwt.image.IPlatformImageFactory;
import de.intarsys.pdf.platform.cwt.image.NullPlatformImageFactory;
import de.intarsys.tools.provider.ProviderTools;
import java.util.Iterator;

public class PlatformImageFactory {
    private static IPlatformImageFactory Unique;
    private static boolean lookupProviders;

    static {
        lookupProviders = true;
    }

    protected static IPlatformImageFactory findProviders() {
        Iterator iterator = ProviderTools.providers(IPlatformImageFactory.class);
        while (iterator.hasNext()) {
            try {
                return (IPlatformImageFactory)iterator.next();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static synchronized IPlatformImageFactory get() {
        if (Unique == null) {
            PlatformImageFactory.init();
        }
        return Unique;
    }

    protected static void init() {
        if (lookupProviders) {
            Unique = PlatformImageFactory.findProviders();
        }
        if (Unique == null) {
            Unique = new NullPlatformImageFactory();
        }
    }

    public static boolean isLookupProviders() {
        return lookupProviders;
    }

    public static void set(IPlatformImageFactory iPlatformImageFactory) {
        Unique = iPlatformImageFactory;
    }

    public static void setLookupProviders(boolean bl) {
        lookupProviders = bl;
    }
}

