/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.paintlet;

import adams.data.statistics.StatUtils;
import adams.gui.visualization.stats.paintlet.AbstractZOverlayPaintlet;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class StdDevPaintlet
extends AbstractZOverlayPaintlet {
    private static final long serialVersionUID = -2890647906878535305L;
    protected double m_stdDevNum;
    double m_mean;
    double m_stddev;

    @Override
    protected void drawData(Graphics g) {
        if (this.m_Calculated) {
            g.setColor(this.m_Color);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(new BasicStroke(this.m_StrokeThickness));
            g2d.drawLine(0, this.m_AxisLeft.valueToPos(this.m_mean + this.m_stdDevNum * this.m_stddev), this.m_AxisBottom.valueToPos(this.m_AxisBottom.getMaximum()), this.m_AxisLeft.valueToPos(this.m_mean + this.m_stdDevNum * this.m_stddev));
            g2d.drawLine(0, this.m_AxisLeft.valueToPos(this.m_mean - this.m_stdDevNum * this.m_stddev), this.m_AxisBottom.valueToPos(this.m_AxisBottom.getMaximum()), this.m_AxisLeft.valueToPos(this.m_mean - this.m_stdDevNum * this.m_stddev));
        }
    }

    public String globalInfo() {
        return "paintlet for displaying stddev overlay on the Z score graph";
    }

    @Override
    public void setStd(double val) {
        this.m_stdDevNum = val;
        this.memberChanged();
    }

    @Override
    public void calculate() {
        super.calculate();
        double[] data = this.m_Instances.attributeToDoubleArray(this.m_Ind);
        this.m_mean = StatUtils.mean((double[])data);
        this.m_stddev = StatUtils.stddev((double[])data, (boolean)false);
        this.m_Calculated = true;
    }
}

