/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;
import weka.core.AbstractInstance;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.ArffLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.IncrementalConverter;

public class ArffSaver
extends AbstractFileSaver
implements BatchConverter,
IncrementalConverter {
    static final long serialVersionUID = 2223634248900042228L;
    protected boolean m_CompressOutput = false;
    protected int m_MaxDecimalPlaces = AbstractInstance.s_numericAfterDecimalPoint;

    public ArffSaver() {
        this.resetOptions();
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement((Option)en.nextElement());
        }
        result.addElement(new Option("\tCompresses the data (uses '" + ArffLoader.FILE_EXTENSION_COMPRESSED + "' as extension instead of '" + ArffLoader.FILE_EXTENSION + "')\n" + "\t(default: off)", "compress", 0, "-compress"));
        result.addElement(new Option("\tThe maximum number of digits to print after the decimal\n\tplace for numeric values (default: 6)", "decimal", 1, "-decimal <num>"));
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.getCompressOutput()) {
            result.add("-compress");
        }
        result.add("-decimal");
        result.add("" + this.getMaxDecimalPlaces());
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setCompressOutput(Utils.getFlag("compress", options));
        String tmpStr = Utils.getOption("decimal", options);
        if (tmpStr.length() > 0) {
            this.setMaxDecimalPlaces(Integer.parseInt(tmpStr));
        }
        super.setOptions(options);
    }

    public void setMaxDecimalPlaces(int maxDecimal) {
        this.m_MaxDecimalPlaces = maxDecimal;
    }

    public int getMaxDecimalPlaces() {
        return this.m_MaxDecimalPlaces;
    }

    public String maxDecimalPlacesTipText() {
        return "The maximum number of digits to print after the decimal point for numeric values";
    }

    public String compressOutputTipText() {
        return "Optional compression of the output data";
    }

    public boolean getCompressOutput() {
        return this.m_CompressOutput;
    }

    public void setCompressOutput(boolean value) {
        this.m_CompressOutput = value;
    }

    public String globalInfo() {
        return "Writes to a destination that is in arff (attribute relation file format) format. The data can be compressed with gzip in order to save space.";
    }

    @Override
    public String getFileDescription() {
        return "Arff data files";
    }

    @Override
    public String[] getFileExtensions() {
        return new String[]{ArffLoader.FILE_EXTENSION, ArffLoader.FILE_EXTENSION_COMPRESSED};
    }

    @Override
    public void setFile(File outputFile) throws IOException {
        if (outputFile.getAbsolutePath().endsWith(ArffLoader.FILE_EXTENSION_COMPRESSED)) {
            this.setCompressOutput(true);
        }
        super.setFile(outputFile);
    }

    @Override
    public void setDestination(OutputStream output) throws IOException {
        if (this.getCompressOutput()) {
            super.setDestination(new GZIPOutputStream(output));
        } else {
            super.setDestination(output);
        }
    }

    @Override
    public void resetOptions() {
        super.resetOptions();
        this.setFileExtension(".arff");
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public void writeIncremental(Instance inst) throws IOException {
        int writeMode = this.getWriteMode();
        Instances structure = this.getInstances();
        PrintWriter outW = null;
        if (this.getRetrieval() == 1 || this.getRetrieval() == 0) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        if (this.getWriter() != null) {
            outW = new PrintWriter(this.getWriter());
        }
        if (writeMode == 1) {
            if (structure == null) {
                this.setWriteMode(2);
                if (inst != null) {
                    System.err.println("Structure(Header Information) has to be set in advance");
                }
            } else {
                this.setWriteMode(3);
            }
            writeMode = this.getWriteMode();
        }
        if (writeMode == 2) {
            if (outW != null) {
                outW.close();
            }
            this.cancel();
        }
        if (writeMode == 3) {
            this.setWriteMode(0);
            Instances header = new Instances(structure, 0);
            if (this.retrieveFile() == null && outW == null) {
                System.out.println(header.toString());
            } else {
                outW.print(header.toString());
                outW.print("\n");
                outW.flush();
            }
            writeMode = this.getWriteMode();
        }
        if (writeMode == 0) {
            if (structure == null) {
                throw new IOException("No instances information available.");
            }
            if (inst != null) {
                if (inst instanceof SparseInstance && inst.dataset().checkForStringAttributes()) {
                    for (int i = 0; i < inst.numAttributes(); ++i) {
                        if (!inst.attribute(i).isString() || inst.attribute(i).numValues() != 1) continue;
                        String theVal = inst.stringValue(i);
                        inst.attribute(i).setStringValue("*WEKA*DUMMY*STRING*FOR*STRING*ATTRIBUTES*");
                        inst.attribute(i).addStringValue(theVal);
                        inst.setValue(i, 1.0);
                    }
                }
                if (this.retrieveFile() == null && outW == null) {
                    System.out.println(inst.toStringMaxDecimalDigits(this.m_MaxDecimalPlaces));
                } else {
                    outW.println(inst.toStringMaxDecimalDigits(this.m_MaxDecimalPlaces));
                    ++this.m_incrementalCounter;
                    if (this.m_incrementalCounter > 100) {
                        this.m_incrementalCounter = 0;
                        outW.flush();
                    }
                }
            } else {
                if (outW != null) {
                    outW.flush();
                    outW.close();
                }
                this.m_incrementalCounter = 0;
                this.resetStructure();
                outW = null;
                this.resetWriter();
            }
        }
    }

    @Override
    public void writeBatch() throws IOException {
        if (this.getInstances() == null) {
            throw new IOException("No instances to save");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        this.setRetrieval(1);
        this.setWriteMode(0);
        if (this.retrieveFile() == null && this.getWriter() == null) {
            Instances data = this.getInstances();
            System.out.println(new Instances(data, 0));
            for (int i = 0; i < data.numInstances(); ++i) {
                System.out.println(data.instance(i).toStringMaxDecimalDigits(this.m_MaxDecimalPlaces));
            }
            this.setWriteMode(1);
            return;
        }
        PrintWriter outW = new PrintWriter(this.getWriter());
        Instances data = this.getInstances();
        Instances header = new Instances(data, 0);
        outW.print(header.toString());
        for (int i = 0; i < data.numInstances(); ++i) {
            if (i % 1000 == 0) {
                outW.flush();
            }
            outW.println(data.instance(i).toStringMaxDecimalDigits(this.m_MaxDecimalPlaces));
        }
        outW.flush();
        outW.close();
        this.setWriteMode(1);
        outW = null;
        this.resetWriter();
        this.setWriteMode(2);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 9515 $");
    }

    public static void main(String[] args) {
        ArffSaver.runFileSaver(new ArffSaver(), args);
    }
}

