/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import weka.classifiers.functions.supportVector.Kernel;
import weka.classifiers.functions.supportVector.PolyKernel;
import weka.classifiers.functions.supportVector.RBFKernel;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.MathematicalExpression;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SingleIndex;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.converters.ConverterUtils;
import weka.filters.AllFilter;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.Center;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class KernelFilter
extends SimpleBatchFilter
implements UnsupervisedFilter,
TechnicalInformationHandler {
    static final long serialVersionUID = 213800899640387499L;
    protected int m_NumTrainInstances;
    protected Kernel m_Kernel = new PolyKernel();
    protected Kernel m_ActualKernel = null;
    protected boolean m_checksTurnedOff;
    protected NominalToBinary m_NominalToBinary;
    protected ReplaceMissingValues m_Missing;
    protected File m_InitFile = new File(System.getProperty("user.dir"));
    protected SingleIndex m_InitFileClassIndex = new SingleIndex("last");
    protected boolean m_Initialized = false;
    protected String m_KernelFactorExpression = "1";
    protected double m_KernelFactor = 1.0;
    protected Filter m_Filter = new Center();
    protected Filter m_ActualFilter = null;

    @Override
    public String globalInfo() {
        return "Converts the given set of predictor variables into a kernel matrix. The class value remains unchangedm, as long as the preprocessing filter doesn't change it.\nBy default, the data is preprocessed with the Center filter, but the user can choose any filter (NB: one must be careful that the filter does not alter the class attribute unintentionally). With weka.filters.AllFilter the preprocessing gets disabled.\n\nFor more information regarding preprocessing the data, see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "K.P. Bennett and M.J. Embrechts");
        result.setValue(TechnicalInformation.Field.TITLE, "An Optimization Perspective on Kernel Partial Least Squares Regression");
        result.setValue(TechnicalInformation.Field.YEAR, "2003");
        result.setValue(TechnicalInformation.Field.EDITOR, "J. Suykens et al.");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Advances in Learning Theory: Methods, Models and Applications");
        result.setValue(TechnicalInformation.Field.PAGES, "227-249");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "IOS Press, Amsterdam, The Netherlands");
        result.setValue(TechnicalInformation.Field.SERIES, "NATO Science Series, Series III: Computer and System Sciences");
        result.setValue(TechnicalInformation.Field.VOLUME, "190");
        return result;
    }

    @Override
    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        result.addElement(new Option("\tTurns off all checks - use with caution!\n\tTurning them off assumes that data is purely numeric, doesn't\n\tcontain any missing values, and has a nominal class. Turning them\n\toff also means that no header information will be stored if the\n\tmachine is linear. Finally, it also assumes that no instance has\n\ta weight equal to 0.\n\t(default: checks on)", "no-checks", 0, "-no-checks"));
        result.addElement(new Option("\tThe file to initialize the filter with (optional).", "F", 1, "-F <filename>"));
        result.addElement(new Option("\tThe class index for the file to initialize with,\n\tFirst and last are valid (optional, default: last).", "C", 1, "-C <num>"));
        result.addElement(new Option("\tThe Kernel to use.\n\t(default: weka.classifiers.functions.supportVector.PolyKernel)", "K", 1, "-K <classname and parameters>"));
        result.addElement(new Option("\tDefines a factor for the kernel.\n\t\t- RBFKernel: a factor for gamma\n\t\t\tStandardize: 1/(2*N)\n\t\t\tNormalize..: 6/N\n\tAvailable parameters are:\n\t\tN for # of instances, A for # of attributes\n\t(default: 1)", "kernel-factor", 0, "-kernel-factor"));
        result.addElement(new Option("\tThe Filter used for preprocessing (use weka.filters.AllFilter\n\tto disable preprocessing).\n\t(default: " + Center.class.getName() + ")", "P", 1, "-P <classname and parameters>"));
        result.addElement(new Option("", "", 0, "\nOptions specific to kernel " + this.getKernel().getClass().getName() + ":"));
        enm = this.getKernel().listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        if (this.getPreprocessing() instanceof OptionHandler) {
            result.addElement(new Option("", "", 0, "\nOptions specific to preprocessing filter " + this.getPreprocessing().getClass().getName() + ":"));
            enm = ((OptionHandler)((Object)this.getPreprocessing())).listOptions();
            while (enm.hasMoreElements()) {
                result.addElement(enm.nextElement());
            }
        }
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        if (this.getChecksTurnedOff()) {
            result.add("-no-checks");
        }
        if (this.getInitFile() != null && this.getInitFile().isFile()) {
            result.add("-F");
            result.add("" + this.getInitFile().getAbsolutePath());
            result.add("-C");
            result.add("" + this.getInitFileClassIndex());
        }
        result.add("-K");
        result.add("" + this.getKernel().getClass().getName() + " " + Utils.joinOptions(this.getKernel().getOptions()));
        result.add("-kernel-factor");
        result.add("" + this.getKernelFactorExpression());
        result.add("-P");
        String tmpStr = this.getPreprocessing().getClass().getName();
        if (this.getPreprocessing() instanceof OptionHandler) {
            tmpStr = tmpStr + " " + Utils.joinOptions(((OptionHandler)((Object)this.getPreprocessing())).getOptions());
        }
        result.add("" + tmpStr);
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setChecksTurnedOff(Utils.getFlag("no-checks", options));
        String tmpStr = Utils.getOption('F', options);
        if (tmpStr.length() != 0) {
            this.setInitFile(new File(tmpStr));
        } else {
            this.setInitFile(null);
        }
        tmpStr = Utils.getOption('C', options);
        if (tmpStr.length() != 0) {
            this.setInitFileClassIndex(tmpStr);
        } else {
            this.setInitFileClassIndex("last");
        }
        tmpStr = Utils.getOption('K', options);
        String[] tmpOptions = Utils.splitOptions(tmpStr);
        if (tmpOptions.length != 0) {
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            this.setKernel(Kernel.forName(tmpStr, tmpOptions));
        }
        if ((tmpStr = Utils.getOption("kernel-factor", options)).length() != 0) {
            this.setKernelFactorExpression(tmpStr);
        } else {
            this.setKernelFactorExpression("1");
        }
        tmpStr = Utils.getOption("P", options);
        tmpOptions = Utils.splitOptions(tmpStr);
        if (tmpOptions.length != 0) {
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            this.setPreprocessing((Filter)Utils.forName(Filter.class, tmpStr, tmpOptions));
        } else {
            this.setPreprocessing(new Center());
        }
        super.setOptions(options);
    }

    public String initFileTipText() {
        return "The dataset to initialize the filter with.";
    }

    public File getInitFile() {
        return this.m_InitFile;
    }

    public void setInitFile(File value) {
        this.m_InitFile = value;
    }

    public String initFileClassIndexTipText() {
        return "The class index of the dataset to initialize the filter with (first and last are valid).";
    }

    public String getInitFileClassIndex() {
        return this.m_InitFileClassIndex.getSingleIndex();
    }

    public void setInitFileClassIndex(String value) {
        this.m_InitFileClassIndex.setSingleIndex(value);
    }

    public String kernelTipText() {
        return "The kernel to use.";
    }

    public Kernel getKernel() {
        return this.m_Kernel;
    }

    public void setKernel(Kernel value) {
        this.m_Kernel = value;
    }

    public void setChecksTurnedOff(boolean value) {
        this.m_checksTurnedOff = value;
    }

    public boolean getChecksTurnedOff() {
        return this.m_checksTurnedOff;
    }

    public String checksTurnedOffTipText() {
        return "Turns time-consuming checks off - use with caution.";
    }

    public String kernelFactorExpressionTipText() {
        return "The factor for the kernel, with A = # of attributes and N = # of instances.";
    }

    public String getKernelFactorExpression() {
        return this.m_KernelFactorExpression;
    }

    public void setKernelFactorExpression(String value) {
        this.m_KernelFactorExpression = value;
    }

    public String preprocessingTipText() {
        return "Sets the filter to use for preprocessing (use the AllFilter for no preprocessing).";
    }

    public void setPreprocessing(Filter value) {
        this.m_Filter = value;
        this.m_ActualFilter = null;
    }

    public Filter getPreprocessing() {
        return this.m_Filter;
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Initialized = false;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        return new Instances(inputFormat);
    }

    public void initFilter(Instances instances) throws Exception {
        HashMap<String, Double> symbols = new HashMap<String, Double>();
        symbols.put("A", new Double(instances.numAttributes()));
        symbols.put("N", new Double(instances.numInstances()));
        this.m_KernelFactor = MathematicalExpression.evaluate(this.getKernelFactorExpression(), symbols);
        if (!this.m_checksTurnedOff) {
            this.m_Missing = new ReplaceMissingValues();
            this.m_Missing.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_Missing);
        } else {
            this.m_Missing = null;
        }
        if (this.getKernel().getCapabilities().handles(Capabilities.Capability.NUMERIC_ATTRIBUTES)) {
            boolean onlyNumeric = true;
            if (!this.m_checksTurnedOff) {
                for (int i = 0; i < instances.numAttributes(); ++i) {
                    if (i == instances.classIndex() || instances.attribute(i).isNumeric()) continue;
                    onlyNumeric = false;
                    break;
                }
            }
            if (!onlyNumeric) {
                this.m_NominalToBinary = new NominalToBinary();
                this.m_NominalToBinary.setInputFormat(instances);
                instances = Filter.useFilter(instances, this.m_NominalToBinary);
            } else {
                this.m_NominalToBinary = null;
            }
        } else {
            this.m_NominalToBinary = null;
        }
        if (this.m_Filter != null && this.m_Filter.getClass() != AllFilter.class) {
            this.m_ActualFilter = Filter.makeCopy(this.m_Filter);
            this.m_ActualFilter.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_ActualFilter);
        } else {
            this.m_ActualFilter = null;
        }
        this.m_NumTrainInstances = instances.numInstances();
        this.m_ActualKernel = Kernel.makeCopy(this.m_Kernel);
        if (this.m_ActualKernel instanceof RBFKernel) {
            ((RBFKernel)this.m_ActualKernel).setGamma(this.m_KernelFactor * ((RBFKernel)this.m_ActualKernel).getGamma());
        }
        this.m_ActualKernel.buildKernel(instances);
        this.m_Initialized = true;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result;
        if (this.getKernel() == null) {
            result = super.getCapabilities();
            result.disableAll();
        } else {
            result = this.getKernel().getCapabilities();
        }
        result.setMinimumNumberInstances(0);
        return result;
    }

    @Override
    protected Instances process(Instances instances) throws Exception {
        if (!this.m_Initialized) {
            if (this.getInitFile() != null && this.getInitFile().isFile()) {
                ConverterUtils.DataSource source = new ConverterUtils.DataSource(this.getInitFile().getAbsolutePath());
                Instances data = source.getDataSet();
                this.m_InitFileClassIndex.setUpper(data.numAttributes() - 1);
                data.setClassIndex(this.m_InitFileClassIndex.getIndex());
                this.initFilter(data);
            } else {
                this.initFilter(instances);
            }
        }
        if (this.m_Missing != null) {
            instances = Filter.useFilter(instances, this.m_Missing);
        }
        if (this.m_NominalToBinary != null) {
            instances = Filter.useFilter(instances, this.m_NominalToBinary);
        }
        if (this.m_ActualFilter != null) {
            instances = Filter.useFilter(instances, this.m_ActualFilter);
        }
        double[] classes = instances.attributeToDoubleArray(instances.classIndex());
        int classIndex = instances.classIndex();
        Attribute classAttribute = (Attribute)instances.classAttribute().copy();
        instances.setClassIndex(-1);
        instances.deleteAttributeAt(classIndex);
        FastVector<Attribute> atts = new FastVector<Attribute>();
        for (int j = 0; j < this.m_NumTrainInstances; ++j) {
            atts.addElement(new Attribute("Kernel " + j));
        }
        atts.addElement(classAttribute);
        Instances result = new Instances("Kernel", atts, 0);
        result.setClassIndex(result.numAttributes() - 1);
        for (int i = 0; i < instances.numInstances(); ++i) {
            double[] k = new double[this.m_NumTrainInstances + 1];
            for (int j = 0; j < this.m_NumTrainInstances; ++j) {
                double v;
                k[j] = v = this.m_ActualKernel.eval(-1, j, instances.instance(i));
            }
            k[k.length - 1] = classes[i];
            DenseInstance in = new DenseInstance(1.0, k);
            result.add(in);
        }
        if (!this.isFirstBatchDone()) {
            this.setOutputFormat(result);
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 9561 $");
    }

    public static void main(String[] args) {
        KernelFilter.runFilter(new KernelFilter(), args);
    }
}

