/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.pentaho.packageManagement.Dependency;
import org.pentaho.packageManagement.Package;
import org.pentaho.packageManagement.PackageConstraint;
import org.pentaho.packageManagement.VersionPackageConstraint;
import weka.core.Environment;
import weka.core.RepositoryIndexGenerator;
import weka.core.Utils;
import weka.core.WekaPackageManager;
import weka.core.logging.Logger;
import weka.gui.ETable;
import weka.gui.ExtensionFileFilter;
import weka.gui.LookAndFeel;
import weka.gui.beans.FileEnvironmentField;

public class PackageManager
extends JPanel {
    private static final long serialVersionUID = -7463821313750352385L;
    protected static final String PACKAGE_COLUMN = "Package";
    protected static final String CATEGORY_COLUMN = "Category";
    protected static final String INSTALLED_COLUMN = "Installed version";
    protected static final String REPOSITORY_COLUMN = "Repository version";
    protected static final String LOADED_COLUMN = "Loaded";
    protected JTable m_table = new ETable();
    protected JSplitPane m_splitP;
    protected JEditorPane m_infoPane;
    protected JRadioButton m_installedBut = new JRadioButton("Installed");
    protected JRadioButton m_availableBut = new JRadioButton("Available");
    protected JRadioButton m_allBut = new JRadioButton("All");
    protected JButton m_installBut = new JButton("Install");
    protected JCheckBox m_forceBut = new JCheckBox("Ignore dependencies/conflicts");
    protected JButton m_uninstallBut = new JButton("Uninstall");
    protected JButton m_refreshCacheBut = new JButton("Refresh repository cache");
    protected JProgressBar m_progress = new JProgressBar(0, 100);
    protected JLabel m_detailLabel = new JLabel();
    protected JButton m_backB;
    protected LinkedList<URL> m_browserHistory = new LinkedList();
    protected static final String BROWSER_HOME = "http://www.cs.waikato.ac.nz/ml/weka/index_home_pm.html";
    protected JButton m_homeB;
    protected JToolBar m_browserTools;
    protected JLabel m_newPackagesAvailableL;
    protected DefaultTableModel m_model;
    protected Map<String, List<Object>> m_packageLookupInfo;
    protected List<Package> m_allPackages;
    protected List<Package> m_installedPackages;
    protected List<Package> m_availablePackages;
    protected int m_sortColumn = 0;
    protected boolean m_reverseSort = false;
    protected JButton m_unofficialBut = new JButton("File/URL");
    protected FileEnvironmentField m_unofficialChooser = new FileEnvironmentField("File/URL", Environment.getSystemWide());
    protected JFrame m_unofficialFrame = null;
    public static boolean s_atLeastOnePackageUpgradeHasOccurredInThisSession = false;
    protected Comparator<Package> m_packageComparator = new Comparator<Package>(){

        @Override
        public int compare(Package o1, Package o2) {
            String meta1 = "";
            String meta2 = "";
            if (PackageManager.this.m_sortColumn == 0) {
                meta1 = o1.getName();
                meta2 = o2.getName();
            } else {
                if (o1.getPackageMetaDataElement((Object)PackageManager.CATEGORY_COLUMN) != null) {
                    meta1 = o1.getPackageMetaDataElement((Object)PackageManager.CATEGORY_COLUMN).toString();
                }
                if (o2.getPackageMetaDataElement((Object)PackageManager.CATEGORY_COLUMN) != null) {
                    meta2 = o2.getPackageMetaDataElement((Object)PackageManager.CATEGORY_COLUMN).toString();
                }
            }
            int result = meta1.compareTo(meta2);
            if (PackageManager.this.m_reverseSort) {
                result = -result;
            }
            return result;
        }
    };
    protected boolean m_installing = false;
    protected boolean m_cacheEstablished = false;
    protected boolean m_cacheRefreshInProgress = false;
    public static String PAGE_HEADER = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n<html>\n<head>\n<title>Waikato Environment for Knowledge Analysis (WEKA)</title>\n<!-- CSS Stylesheet -->\n<style>body\n{\nbackground: #ededed;\ncolor: #666666;\nfont: 14px Tahoma, Helvetica, sans-serif;;\nmargin: 5px 10px 5px 10px;\npadding: 0px;\n}\n</style>\n\n</head>\n<body bgcolor=\"#ededed\" text=\"#666666\">\n";

    private void pleaseCloseAppWindowsPopUp() {
        if (!Utils.getDontShowDialog("weka.gui.PackageManager.PleaseCloseApplicationWindows")) {
            JCheckBox dontShow = new JCheckBox("Do not show this message again");
            Object[] stuff = new Object[]{"Please close any open Weka application windows\n(Explorer, Experimenter, KnowledgeFlow, SimpleCLI)\nbefore proceeding.\n", dontShow};
            JOptionPane.showMessageDialog(this, stuff, "Weka Package Manager", 0);
            if (dontShow.isSelected()) {
                try {
                    Utils.setDontShowDialog("weka.gui.PackageManager.PleaseCloseApplicationWindows");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static String initialPage() {
        StringBuffer initialPage = new StringBuffer();
        initialPage.append(PAGE_HEADER);
        initialPage.append("<h1>WEKA Package Manager</h1>\n\n</body></html>\n");
        return initialPage.toString();
    }

    private int getColumnIndex(String columnName) {
        return this.m_table.getColumn(columnName).getModelIndex();
    }

    public PackageManager() {
        if (WekaPackageManager.m_noPackageMetaDataAvailable) {
            JOptionPane.showMessageDialog(this, "The package manager is unavailable due to the fact that there is no cached package meta data and we are offline", "Package manager unavailable", 1);
            return;
        }
        EstablishCache ec = new EstablishCache();
        ec.execute();
        while (!this.m_cacheEstablished) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        }
        this.getAllPackages();
        this.setLayout(new BorderLayout());
        ButtonGroup bGroup = new ButtonGroup();
        bGroup.add(this.m_installedBut);
        bGroup.add(this.m_availableBut);
        bGroup.add(this.m_allBut);
        JPanel butPanel = new JPanel();
        butPanel.setLayout(new BorderLayout());
        JPanel packageDisplayP = new JPanel();
        packageDisplayP.setLayout(new BorderLayout());
        JPanel packageDHolder = new JPanel();
        packageDHolder.setLayout(new FlowLayout());
        packageDHolder.add(this.m_installedBut);
        packageDHolder.add(this.m_availableBut);
        packageDHolder.add(this.m_allBut);
        packageDisplayP.add((Component)packageDHolder, "South");
        packageDisplayP.add((Component)this.m_refreshCacheBut, "North");
        JPanel officialHolder = new JPanel();
        officialHolder.setLayout(new BorderLayout());
        officialHolder.setBorder(BorderFactory.createTitledBorder("Official"));
        officialHolder.add((Component)packageDisplayP, "West");
        butPanel.add((Component)officialHolder, "West");
        this.m_refreshCacheBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RefreshCache r = new RefreshCache();
                r.execute();
            }
        });
        JPanel unofficialHolder = new JPanel();
        unofficialHolder.setLayout(new BorderLayout());
        unofficialHolder.setBorder(BorderFactory.createTitledBorder("Unofficial"));
        unofficialHolder.add((Component)this.m_unofficialBut, "North");
        butPanel.add((Component)unofficialHolder, "East");
        JPanel installP = new JPanel();
        JPanel buttP = new JPanel();
        buttP.setLayout(new GridLayout(1, 2));
        installP.setLayout(new BorderLayout());
        buttP.add(this.m_installBut);
        buttP.add(this.m_uninstallBut);
        this.m_installBut.setEnabled(false);
        this.m_uninstallBut.setEnabled(false);
        installP.add((Component)buttP, "North");
        installP.add((Component)this.m_forceBut, "South");
        this.m_forceBut.setEnabled(false);
        officialHolder.add((Component)installP, "East");
        this.m_installBut.setToolTipText("Install the selected official package(s) from the list");
        this.m_uninstallBut.setToolTipText("Uninstall the selected package(s) from the list");
        this.m_unofficialBut.setToolTipText("Install an unofficial package from a file or URL");
        this.m_unofficialChooser.resetFileFilters();
        this.m_unofficialChooser.addFileFilter(new ExtensionFileFilter(".zip", "Package archive file"));
        this.m_unofficialBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PackageManager.this.m_unofficialFrame == null) {
                    final JFrame jf = new JFrame("Unofficial package install");
                    jf.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            jf.dispose();
                            PackageManager.this.m_unofficialBut.setEnabled(true);
                            PackageManager.this.m_unofficialFrame = null;
                        }
                    });
                    jf.setLayout(new BorderLayout());
                    JButton okBut = new JButton("OK");
                    JButton cancelBut = new JButton("Cancel");
                    JPanel butHolder = new JPanel();
                    butHolder.setLayout(new GridLayout(1, 2));
                    butHolder.add(okBut);
                    butHolder.add(cancelBut);
                    jf.add((Component)PackageManager.this.m_unofficialChooser, "Center");
                    jf.add((Component)butHolder, "South");
                    jf.pack();
                    jf.setVisible(true);
                    PackageManager.this.m_unofficialFrame = jf;
                    PackageManager.this.m_unofficialBut.setEnabled(false);
                    cancelBut.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (PackageManager.this.m_unofficialFrame != null) {
                                jf.dispose();
                                PackageManager.this.m_unofficialBut.setEnabled(true);
                                PackageManager.this.m_unofficialFrame = null;
                            }
                        }
                    });
                    okBut.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            String target = PackageManager.this.m_unofficialChooser.getText();
                            UnofficialInstallTask t = new UnofficialInstallTask();
                            t.setTargetToInstall(target);
                            t.execute();
                            if (PackageManager.this.m_unofficialFrame != null) {
                                jf.dispose();
                                PackageManager.this.m_unofficialBut.setEnabled(true);
                                PackageManager.this.m_unofficialFrame = null;
                            }
                        }
                    });
                }
            }
        });
        this.m_installBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRows = PackageManager.this.m_table.getSelectedRows();
                if (selectedRows.length > 0) {
                    ArrayList<String> packageNames = new ArrayList<String>();
                    ArrayList<Object> versions = new ArrayList<Object>();
                    StringBuffer confirmList = new StringBuffer();
                    for (int i = 0; i < selectedRows.length; ++i) {
                        String packageName = PackageManager.this.m_table.getValueAt(selectedRows[i], PackageManager.this.getColumnIndex(PackageManager.PACKAGE_COLUMN)).toString();
                        packageNames.add(packageName);
                        Object packageVersion = PackageManager.this.m_table.getValueAt(selectedRows[i], PackageManager.this.getColumnIndex(PackageManager.REPOSITORY_COLUMN));
                        versions.add(packageVersion);
                        confirmList.append(packageName + " " + packageVersion.toString() + "\n");
                    }
                    JTextArea jt = new JTextArea("The following packages will be installed/upgraded:\n\n" + confirmList.toString(), 10, 40);
                    int result = JOptionPane.showConfirmDialog(PackageManager.this, new JScrollPane(jt), "Weka Package Manager", 0);
                    if (result == 0) {
                        PackageManager.this.pleaseCloseAppWindowsPopUp();
                        InstallTask task = new InstallTask();
                        task.setPackages(packageNames);
                        task.setVersions(versions);
                        task.execute();
                    }
                }
            }
        });
        this.m_uninstallBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRows = PackageManager.this.m_table.getSelectedRows();
                if (selectedRows.length > 0) {
                    JTextArea jt;
                    int result;
                    ArrayList<String> packageNames = new ArrayList<String>();
                    StringBuffer confirmList = new StringBuffer();
                    for (int i = 0; i < selectedRows.length; ++i) {
                        String packageName = PackageManager.this.m_table.getValueAt(selectedRows[i], PackageManager.this.getColumnIndex(PackageManager.PACKAGE_COLUMN)).toString();
                        Package p = null;
                        try {
                            p = WekaPackageManager.getRepositoryPackageInfo(packageName);
                        }
                        catch (Exception e1) {
                            try {
                                p = WekaPackageManager.getInstalledPackageInfo(packageName);
                            }
                            catch (Exception e2) {
                                e2.printStackTrace();
                                continue;
                            }
                        }
                        if (!p.isInstalled()) continue;
                        packageNames.add(packageName);
                        confirmList.append(packageName + "\n");
                    }
                    if (packageNames.size() > 0 && (result = JOptionPane.showConfirmDialog(PackageManager.this, new JScrollPane(jt = new JTextArea("The following packages will be uninstalled:\n" + confirmList.toString(), 10, 40)), "Weka Package Manager", 0)) == 0) {
                        PackageManager.this.pleaseCloseAppWindowsPopUp();
                        UninstallTask task = new UninstallTask();
                        task.setPackages(packageNames);
                        task.execute();
                    }
                }
            }
        });
        JPanel progressP = new JPanel();
        progressP.setLayout(new BorderLayout());
        progressP.setBorder(BorderFactory.createTitledBorder("Install/Uninstall/Refresh progress"));
        progressP.add((Component)this.m_progress, "North");
        progressP.add((Component)this.m_detailLabel, "Center");
        butPanel.add((Component)progressP, "Center");
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)butPanel, "North");
        this.m_allBut.setSelected(true);
        this.m_allBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PackageManager.this.m_table.clearSelection();
                PackageManager.this.updateTable();
                PackageManager.this.updateInstallUninstallButtonEnablement();
            }
        });
        this.m_availableBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PackageManager.this.m_table.clearSelection();
                PackageManager.this.updateTable();
                PackageManager.this.updateInstallUninstallButtonEnablement();
            }
        });
        this.m_installedBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PackageManager.this.m_table.clearSelection();
                PackageManager.this.updateTable();
                PackageManager.this.updateInstallUninstallButtonEnablement();
            }
        });
        this.m_model = new DefaultTableModel(new String[]{PACKAGE_COLUMN, CATEGORY_COLUMN, INSTALLED_COLUMN, REPOSITORY_COLUMN, LOADED_COLUMN}, 15){
            private static final long serialVersionUID = -2886328542412471039L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 3;
            }
        };
        this.m_table.setSelectionMode(2);
        this.m_table.setColumnSelectionAllowed(false);
        this.m_table.setPreferredScrollableViewportSize(new Dimension(550, 200));
        this.m_table.setModel(this.m_model);
        if (System.getProperty("os.name").contains("Mac")) {
            this.m_table.setShowVerticalLines(true);
        } else {
            this.m_table.setShowVerticalLines(false);
        }
        this.m_table.setShowHorizontalLines(false);
        this.m_table.getColumn(REPOSITORY_COLUMN).setCellEditor(new ComboBoxEditor());
        this.m_table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && !PackageManager.this.m_cacheRefreshInProgress) {
                    ListSelectionModel lm = (ListSelectionModel)e.getSource();
                    boolean infoDisplayed = false;
                    for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                        if (!lm.isSelectedIndex(i) || infoDisplayed) continue;
                        PackageManager.this.displayPackageInfo(i);
                        infoDisplayed = true;
                        break;
                    }
                    PackageManager.this.updateInstallUninstallButtonEnablement();
                }
            }
        });
        JTableHeader header = this.m_table.getTableHeader();
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TableColumnModel colModel = PackageManager.this.m_table.getColumnModel();
                int vColIndex = colModel.getColumnIndexAtX(evt.getX());
                if (vColIndex == -1 || vColIndex > 1) {
                    return;
                }
                PackageManager.this.m_reverseSort = vColIndex == PackageManager.this.m_sortColumn ? !PackageManager.this.m_reverseSort : false;
                PackageManager.this.m_sortColumn = vColIndex;
                PackageManager.this.updateTable();
            }
        });
        topPanel.add((Component)new JScrollPane(this.m_table), "Center");
        try {
            String initialPage = PackageManager.initialPage();
            this.m_infoPane = new JEditorPane("text/html", initialPage);
        }
        catch (Exception ex) {
            this.m_infoPane = new JEditorPane();
        }
        this.m_infoPane.setEditable(false);
        this.m_infoPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent event) {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        if (!event.getURL().toExternalForm().endsWith(".zip") && !event.getURL().toExternalForm().endsWith(".jar")) {
                            if (PackageManager.this.m_browserHistory.size() == 0) {
                                PackageManager.this.m_backB.setEnabled(true);
                            }
                            PackageManager.this.m_browserHistory.add(PackageManager.this.m_infoPane.getPage());
                            PackageManager.this.m_infoPane.setPage(event.getURL());
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        JPanel browserP = new JPanel();
        browserP.setLayout(new BorderLayout());
        this.m_backB = new JButton(new ImageIcon(this.loadImage("weka/gui/images/back.gif")));
        this.m_backB.setToolTipText("Back");
        this.m_backB.setEnabled(false);
        this.m_backB.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.m_homeB = new JButton(new ImageIcon(this.loadImage("weka/gui/images/home.gif")));
        this.m_homeB.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.m_homeB.setToolTipText("Home");
        this.m_browserTools = new JToolBar();
        this.m_browserTools.add(this.m_backB);
        this.m_browserTools.add(this.m_homeB);
        this.m_browserTools.setFloatable(false);
        this.m_newPackagesAvailableL = new JLabel(new ImageIcon(this.loadImage("weka/gui/images/information.gif")));
        HomePageThread homePageThread = new HomePageThread();
        homePageThread.setPriority(1);
        homePageThread.start();
        this.m_backB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                URL previous = PackageManager.this.m_browserHistory.removeLast();
                try {
                    PackageManager.this.m_infoPane.setPage(previous);
                    if (PackageManager.this.m_browserHistory.size() == 0) {
                        PackageManager.this.m_backB.setEnabled(false);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.m_homeB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    URL back = PackageManager.this.m_infoPane.getPage();
                    if (back != null) {
                        PackageManager.this.m_browserHistory.add(back);
                    }
                    String initialPage = PackageManager.initialPage();
                    PackageManager.this.m_infoPane.setContentType("text/html");
                    PackageManager.this.m_infoPane.setText(initialPage);
                    HomePageThread hp = new HomePageThread();
                    hp.setPriority(1);
                    hp.start();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        browserP.add((Component)this.m_browserTools, "North");
        browserP.add((Component)new JScrollPane(this.m_infoPane), "Center");
        this.m_splitP = new JSplitPane(0, topPanel, browserP);
        this.m_splitP.setOneTouchExpandable(true);
        this.add((Component)this.m_splitP, "Center");
        this.updateTable();
        if (!WekaPackageManager.m_offline) {
            System.err.println("Checking for new packages...");
            CheckForNewPackages cp = new CheckForNewPackages();
            cp.execute();
        } else {
            this.m_installBut.setEnabled(false);
            this.m_refreshCacheBut.setEnabled(false);
        }
    }

    private void updateInstallUninstallButtonEnablement() {
        boolean enableInstall = false;
        boolean enableUninstall = false;
        this.m_unofficialBut.setEnabled(true);
        if (!this.m_installing) {
            int[] selectedRows = this.m_table.getSelectedRows();
            for (int i = 0; i < selectedRows.length; ++i) {
                if (enableInstall && enableUninstall) continue;
                enableInstall = true;
                String packageName = this.m_table.getValueAt(selectedRows[i], this.getColumnIndex(PACKAGE_COLUMN)).toString();
                try {
                    Package p = WekaPackageManager.getRepositoryPackageInfo(packageName);
                    if (enableUninstall) continue;
                    enableUninstall = p.isInstalled();
                    continue;
                }
                catch (Exception e1) {
                    enableUninstall = true;
                    enableInstall = false;
                }
            }
        } else {
            this.m_unofficialBut.setEnabled(false);
        }
        this.m_installBut.setEnabled(enableInstall && !WekaPackageManager.m_offline);
        this.m_forceBut.setEnabled(enableInstall);
        this.m_uninstallBut.setEnabled(enableUninstall);
    }

    private Image loadImage(String path) {
        Image pic = null;
        URL imageURL = this.getClass().getClassLoader().getResource(path);
        if (imageURL != null) {
            pic = Toolkit.getDefaultToolkit().getImage(imageURL);
        }
        return pic;
    }

    private void updateTable() {
        String category;
        if (this.m_installedPackages == null || this.m_availablePackages == null) {
            for (Package p : this.m_allPackages) {
                String loadStatus = "";
                if (p.isInstalled()) {
                    File packageRoot = new File(WekaPackageManager.getPackageHome().toString() + File.separator + p.getName());
                    boolean loaded = WekaPackageManager.loadCheck(p, packageRoot, new PrintStream[0]);
                    loadStatus = loaded ? "Yes" : "No - check log";
                }
                List<Object> catAndVers = this.m_packageLookupInfo.get(p.getName());
                catAndVers.set(2, loadStatus);
            }
        }
        if (this.m_allBut.isSelected()) {
            this.m_model.setRowCount(this.m_allPackages.size());
            Collections.sort(this.m_allPackages, this.m_packageComparator);
            int row = 0;
            for (Package p : this.m_allPackages) {
                this.m_model.setValueAt(p.getName(), row, this.getColumnIndex(PACKAGE_COLUMN));
                category = "";
                if (p.getPackageMetaDataElement((Object)CATEGORY_COLUMN) != null) {
                    category = (String)p.getPackageMetaDataElement((Object)CATEGORY_COLUMN);
                }
                this.m_model.setValueAt(category, row, this.getColumnIndex(CATEGORY_COLUMN));
                String installedV = "";
                Object repositoryV = p.getPackageMetaDataElement((Object)"Version");
                if (p.isInstalled()) {
                    try {
                        Package installed = WekaPackageManager.getInstalledPackageInfo(p.getName());
                        installedV = installed.getPackageMetaDataElement((Object)"Version").toString();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        this.displayErrorDialog("An error has occurred while trying to obtain installed package info", ex);
                    }
                }
                this.m_model.setValueAt(installedV, row, this.getColumnIndex(INSTALLED_COLUMN));
                this.m_model.setValueAt(repositoryV, row, this.getColumnIndex(REPOSITORY_COLUMN));
                List<Object> catAndVers = this.m_packageLookupInfo.get(p.getName());
                String loadStatus = (String)catAndVers.get(2);
                this.m_model.setValueAt(loadStatus, row, this.getColumnIndex(LOADED_COLUMN));
                ++row;
            }
            this.m_table.revalidate();
            this.m_table.repaint();
        } else if (this.m_installedBut.isSelected()) {
            try {
                if (this.m_installedPackages == null) {
                    this.m_installedPackages = WekaPackageManager.getInstalledPackages();
                }
                this.m_model.setRowCount(this.m_installedPackages.size());
                int row = 0;
                for (Package p : this.m_installedPackages) {
                    this.m_model.setValueAt(p.getName(), row, this.getColumnIndex(PACKAGE_COLUMN));
                    String installedV = p.getPackageMetaDataElement((Object)"Version").toString();
                    String category2 = "";
                    if (p.getPackageMetaDataElement((Object)CATEGORY_COLUMN) != null) {
                        category2 = p.getPackageMetaDataElement((Object)CATEGORY_COLUMN).toString();
                    }
                    List<Object> catAndVers = this.m_packageLookupInfo.get(p.getName());
                    String repositoryV = "-----";
                    if (catAndVers != null) {
                        List repVersions = (List)catAndVers.get(1);
                        repositoryV = repVersions.get(0);
                    }
                    this.m_model.setValueAt(category2, row, this.getColumnIndex(CATEGORY_COLUMN));
                    this.m_model.setValueAt(installedV, row, this.getColumnIndex(INSTALLED_COLUMN));
                    this.m_model.setValueAt(repositoryV, row, this.getColumnIndex(REPOSITORY_COLUMN));
                    if (catAndVers != null) {
                        String loadStatus = (String)catAndVers.get(2);
                        this.m_model.setValueAt(loadStatus, row, this.getColumnIndex(LOADED_COLUMN));
                    } else {
                        File packageRoot = new File(WekaPackageManager.getPackageHome().toString() + File.separator + p.getName());
                        boolean loaded = WekaPackageManager.loadCheck(p, packageRoot, new PrintStream[0]);
                        String loadStatus = loaded ? "Yes" : "No - check log";
                        this.m_model.setValueAt(loadStatus, row, this.getColumnIndex(LOADED_COLUMN));
                    }
                    ++row;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            try {
                if (this.m_availablePackages == null) {
                    this.m_availablePackages = WekaPackageManager.getAvailablePackages();
                }
                this.m_model.setRowCount(this.m_availablePackages.size());
                int row = 0;
                for (Package p : this.m_availablePackages) {
                    this.m_model.setValueAt(p.getName(), row, this.getColumnIndex(PACKAGE_COLUMN));
                    category = "";
                    if (p.getPackageMetaDataElement((Object)CATEGORY_COLUMN) != null) {
                        category = p.getPackageMetaDataElement((Object)CATEGORY_COLUMN).toString();
                    }
                    String installedV = "";
                    List<Object> catAndVers = this.m_packageLookupInfo.get(p.getName());
                    List repVersions = (List)catAndVers.get(1);
                    Object repositoryV = repVersions.get(0);
                    this.m_model.setValueAt(category, row, this.getColumnIndex(CATEGORY_COLUMN));
                    this.m_model.setValueAt(installedV, row, this.getColumnIndex(INSTALLED_COLUMN));
                    this.m_model.setValueAt(repositoryV, row, this.getColumnIndex(REPOSITORY_COLUMN));
                    String loadStatus = (String)catAndVers.get(2);
                    this.m_model.setValueAt(loadStatus, row, this.getColumnIndex(LOADED_COLUMN));
                    ++row;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void displayPackageInfo(int i) {
        String packageName = this.m_table.getValueAt(i, this.getColumnIndex(PACKAGE_COLUMN)).toString();
        boolean repositoryPackage = true;
        try {
            Package repP = WekaPackageManager.getRepositoryPackageInfo(packageName);
        }
        catch (Exception ex) {
            repositoryPackage = false;
        }
        String versionURL = WekaPackageManager.getPackageRepositoryURL().toString() + "/" + packageName + "/index.html";
        try {
            URL back = this.m_infoPane.getPage();
            if (this.m_browserHistory.size() == 0 && back != null) {
                this.m_backB.setEnabled(true);
            }
            if (back != null) {
                this.m_browserHistory.add(back);
            }
            if (repositoryPackage) {
                this.m_infoPane.setPage(new URL(versionURL));
            } else {
                try {
                    Package p = WekaPackageManager.getInstalledPackageInfo(packageName);
                    Map meta = p.getPackageMetaData();
                    Set keys = meta.keySet();
                    StringBuffer sb = new StringBuffer();
                    sb.append(RepositoryIndexGenerator.HEADER);
                    sb.append("<H1>" + packageName + " (Unofficial) </H1>");
                    for (Object k : keys) {
                        if (k.toString().equals("PackageName")) continue;
                        Object value = meta.get(k);
                        sb.append(k + " : " + value + "<p>");
                    }
                    sb.append("</html>\n");
                    this.m_infoPane.setText(sb.toString());
                }
                catch (Exception e) {}
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.updateInstallUninstallButtonEnablement();
        if (this.m_availableBut.isSelected()) {
            this.m_uninstallBut.setEnabled(false);
        }
    }

    private void getPackagesAndEstablishLookup() throws Exception {
        this.m_allPackages = WekaPackageManager.getAllPackages();
        this.m_packageLookupInfo = new TreeMap<String, List<Object>>();
        for (Package p : this.m_allPackages) {
            String packageName = p.getName();
            String category = "";
            if (p.getPackageMetaDataElement((Object)CATEGORY_COLUMN) != null) {
                category = p.getPackageMetaDataElement((Object)CATEGORY_COLUMN).toString();
            }
            String loadStatus = "";
            if (p.isInstalled()) {
                File packageRoot = new File(WekaPackageManager.getPackageHome().toString());
                boolean loaded = WekaPackageManager.loadCheck(p, packageRoot, new PrintStream[0]);
                loadStatus = loaded ? "Yes" : "No - check log";
            }
            List<Object> versions = WekaPackageManager.getRepositoryPackageVersions(packageName);
            ArrayList<Object> catAndVers = new ArrayList<Object>();
            catAndVers.add(category);
            catAndVers.add(versions);
            catAndVers.add(loadStatus);
            this.m_packageLookupInfo.put(packageName, catAndVers);
        }
    }

    private void getAllPackages() {
        try {
            this.getPackagesAndEstablishLookup();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("A problem has occurred whilst trying to get all package information. Trying a cache refresh...");
            WekaPackageManager.refreshCache(System.out);
            try {
                this.getPackagesAndEstablishLookup();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void displayErrorDialog(String message, Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String result = sw.toString();
        this.displayErrorDialog(message, result);
    }

    private void displayErrorDialog(String message, String stackTrace) {
        Object[] options = null;
        options = stackTrace != null && stackTrace.length() > 0 ? new Object[]{"OK", "Show error"} : new Object[]{"OK"};
        int result = JOptionPane.showOptionDialog(this, message, "Weka Package Manager", 0, 0, null, options, options[0]);
        if (result == 1) {
            JTextArea jt = new JTextArea(stackTrace, 10, 40);
            JOptionPane.showMessageDialog(this, new JScrollPane(jt), "Weka Package Manager", 0);
        }
    }

    public void setInitialSplitPaneDividerLocation() {
        this.m_splitP.setDividerLocation(0.4);
    }

    public static void main(String[] args) {
        Logger.log(Logger.Level.INFO, "Logging started");
        LookAndFeel.setLookAndFeel();
        PackageManager pm = new PackageManager();
        if (!WekaPackageManager.m_noPackageMetaDataAvailable) {
            String offline = "";
            if (WekaPackageManager.m_offline) {
                offline = " (offline)";
            }
            final JFrame jf = new JFrame("Weka Package Manager" + offline);
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)pm, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            Dimension screenSize = jf.getToolkit().getScreenSize();
            int width = screenSize.width * 8 / 10;
            int height = screenSize.height * 8 / 10;
            jf.setBounds(width / 8, height / 8, width, height);
            jf.setVisible(true);
            pm.setInitialSplitPaneDividerLocation();
        }
    }

    protected class HomePageThread
    extends Thread {
        protected HomePageThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                PackageManager.this.m_homeB.setEnabled(false);
                PackageManager.this.m_backB.setEnabled(false);
                URLConnection conn = null;
                URL homeURL = new URL(PackageManager.BROWSER_HOME);
                org.pentaho.packageManagement.PackageManager pm = WekaPackageManager.getUnderlyingPackageManager();
                conn = pm.setProxyAuthentication(homeURL) ? homeURL.openConnection(pm.getProxy()) : homeURL.openConnection();
                conn.setConnectTimeout(10000);
                BufferedReader bi = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                while (bi.readLine() != null) {
                }
                PackageManager.this.m_infoPane.setPage(PackageManager.BROWSER_HOME);
            }
            catch (Exception exception) {
            }
            finally {
                PackageManager.this.m_homeB.setEnabled(true);
                PackageManager.this.m_backB.setEnabled(true);
            }
        }
    }

    protected class ComboBoxEditor
    extends DefaultCellEditor {
        public ComboBoxEditor() {
            super(new JComboBox<String>(new String[]{"one", "two"}));
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            String packageName = PackageManager.this.m_table.getValueAt(row, PackageManager.this.getColumnIndex(PackageManager.PACKAGE_COLUMN)).toString();
            List<Object> catAndVers = PackageManager.this.m_packageLookupInfo.get(packageName);
            List repVersions = (List)catAndVers.get(1);
            String[] versions = repVersions.toArray(new String[1]);
            Component combo = this.getComponent();
            if (combo instanceof JComboBox) {
                ((JComboBox)combo).setModel(new DefaultComboBoxModel<String>(versions));
                ((JComboBox)combo).setSelectedItem(value);
            } else {
                System.err.println("Uh oh!!!!!");
            }
            return combo;
        }
    }

    class InstallTask
    extends SwingWorker<Void, Void>
    implements Progressable {
        private List<String> m_packageNamesToInstall;
        private List<Object> m_versionsToInstall;
        private final List<Package> m_unsuccessfulInstalls = new ArrayList<Package>();
        private int m_progressCount = 0;

        InstallTask() {
        }

        public void setPackages(List<String> packagesToInstall) {
            this.m_packageNamesToInstall = packagesToInstall;
        }

        public void setVersions(List<Object> versionsToInstall) {
            this.m_versionsToInstall = versionsToInstall;
        }

        @Override
        public void makeProgress(String progressMessage) {
            PackageManager.this.m_detailLabel.setText(progressMessage);
            ++this.m_progressCount;
            PackageManager.this.m_progress.setValue(this.m_progressCount);
            if (this.m_progressCount == PackageManager.this.m_progress.getMaximum()) {
                PackageManager.this.m_progress.setMaximum(this.m_progressCount + 5);
            }
        }

        @Override
        public void makeProgressMessageOnly(String progressMessage) {
            PackageManager.this.m_detailLabel.setText(progressMessage);
        }

        @Override
        public Void doInBackground() {
            PackageManager.this.m_installing = true;
            PackageManager.this.m_installBut.setEnabled(false);
            PackageManager.this.m_unofficialBut.setEnabled(true);
            PackageManager.this.m_uninstallBut.setEnabled(false);
            PackageManager.this.m_refreshCacheBut.setEnabled(false);
            PackageManager.this.m_availableBut.setEnabled(false);
            PackageManager.this.m_allBut.setEnabled(false);
            PackageManager.this.m_installedBut.setEnabled(false);
            ProgressPrintStream pps = new ProgressPrintStream(this);
            PackageManager.this.m_progress.setMaximum(this.m_packageNamesToInstall.size() * 30);
            for (int zz = 0; zz < this.m_packageNamesToInstall.size(); ++zz) {
                Object versionToInstall;
                String packageName;
                Package packageToInstall;
                block55: {
                    boolean tempB;
                    block56: {
                        Package installedVersion;
                        block57: {
                            block54: {
                                packageToInstall = null;
                                packageName = this.m_packageNamesToInstall.get(zz);
                                versionToInstall = this.m_versionsToInstall.get(zz);
                                try {
                                    packageToInstall = WekaPackageManager.getRepositoryPackageInfo(packageName, versionToInstall.toString());
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    PackageManager.this.displayErrorDialog("Unable to obtain package info for package: " + packageName, e);
                                    this.m_unsuccessfulInstalls.add(packageToInstall);
                                    continue;
                                }
                                Object specialInstallMessage = packageToInstall.getPackageMetaDataElement((Object)"MessageToDisplayOnInstallation");
                                if (specialInstallMessage != null && specialInstallMessage.toString().length() > 0) {
                                    String siM = specialInstallMessage.toString();
                                    try {
                                        siM = Environment.getSystemWide().substitute(siM);
                                    }
                                    catch (Exception ex) {
                                        // empty catch block
                                    }
                                    JOptionPane.showMessageDialog(PackageManager.this, packageToInstall + "\n\n" + siM, "Weka Package Manager", 0);
                                }
                                if (PackageManager.this.m_forceBut.isSelected()) break block55;
                                try {
                                    if (!packageToInstall.isCompatibleBaseSystem()) {
                                        List baseSysDep = packageToInstall.getBaseSystemDependency();
                                        StringBuffer depList = new StringBuffer();
                                        for (Dependency bd : baseSysDep) {
                                            depList.append(bd.getTarget().toString() + " ");
                                        }
                                        JOptionPane.showMessageDialog(PackageManager.this, "Unable to install package \n" + packageName + " because it requires" + "\n" + depList.toString(), "Weka Package Manager", 0);
                                        this.m_unsuccessfulInstalls.add(packageToInstall);
                                    }
                                    break block54;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    PackageManager.this.displayErrorDialog("Problem determining dependency on base system for package: " + packageName, e);
                                    this.m_unsuccessfulInstalls.add(packageToInstall);
                                }
                                continue;
                            }
                            boolean upOrDowngrading = false;
                            if (!packageToInstall.isInstalled()) break block56;
                            installedVersion = null;
                            try {
                                installedVersion = WekaPackageManager.getInstalledPackageInfo(packageName);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                PackageManager.this.displayErrorDialog("Problem obtaining package info for package: " + packageName, e);
                                this.m_unsuccessfulInstalls.add(packageToInstall);
                                continue;
                            }
                            if (packageToInstall.equals(installedVersion)) break block57;
                            int result = JOptionPane.showConfirmDialog(PackageManager.this, "Package " + installedVersion + " is already installed. Replace with " + packageToInstall + "?", "Weka Package Manager", 0);
                            if (result == 1) {
                                this.m_unsuccessfulInstalls.add(packageToInstall);
                                continue;
                            }
                            if (Utils.getDontShowDialog("weka.gui.PackageManager.RestartAfterUpgrade")) break block56;
                            JCheckBox dontShow = new JCheckBox("Do not show this message again");
                            Object[] stuff = new Object[]{"Weka will need to be restared after installation for\nthe changes to come into effect.\n", dontShow};
                            JOptionPane.showMessageDialog(PackageManager.this, stuff, "Weka Package Manager", 0);
                            if (!dontShow.isSelected()) break block56;
                            try {
                                Utils.setDontShowDialog("weka.gui.PackageManager.RestartAfterUpgrade");
                            }
                            catch (Exception ex) {}
                            break block56;
                        }
                        int result = JOptionPane.showConfirmDialog(PackageManager.this, "Package " + installedVersion + " is already installed. Install again?", "Weka Package Manager", 0);
                        if (result == 1) {
                            this.m_unsuccessfulInstalls.add(packageToInstall);
                            continue;
                        }
                    }
                    HashMap<String, List<Dependency>> conflicts = new HashMap<String, List<Dependency>>();
                    List<Dependency> dependencies = null;
                    try {
                        dependencies = WekaPackageManager.getAllDependenciesForPackage(packageToInstall, conflicts);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        PackageManager.this.displayErrorDialog("Problem determinining dependencies for package: " + packageToInstall.getName(), e);
                        this.m_unsuccessfulInstalls.add(packageToInstall);
                        continue;
                    }
                    if (conflicts.size() > 0) {
                        StringBuffer message = new StringBuffer();
                        message.append("Package " + packageName + " requires the following packages:\n\n");
                        for (Dependency d : dependencies) {
                            message.append("\t" + d + "\n");
                        }
                        message.append("\nThere are conflicting dependencies:\n\n");
                        Set pNames = conflicts.keySet();
                        for (String pName : pNames) {
                            message.append("Conflicts for " + pName + "\n");
                            List confsForPackage = (List)conflicts.get(pName);
                            for (Dependency problem : confsForPackage) {
                                message.append("\t" + problem + "\n");
                            }
                        }
                        JOptionPane.showConfirmDialog(PackageManager.this, message.toString(), "Weka Package Manager", 0);
                        this.m_unsuccessfulInstalls.add(packageToInstall);
                        continue;
                    }
                    ArrayList<PackageConstraint> needsUpgrade = new ArrayList<PackageConstraint>();
                    ArrayList<Package> finalListToInstall = new ArrayList<Package>();
                    Iterator<Dependency> depI = dependencies.iterator();
                    boolean depsOk = true;
                    while (depI.hasNext()) {
                        Dependency toCheck = depI.next();
                        if (toCheck.getTarget().getPackage().isInstalled()) {
                            String toCheckName = toCheck.getTarget().getPackage().getPackageMetaDataElement((Object)"PackageName").toString();
                            try {
                                Package installedVersion = WekaPackageManager.getInstalledPackageInfo(toCheckName);
                                if (toCheck.getTarget().checkConstraint(installedVersion)) continue;
                                needsUpgrade.add(toCheck.getTarget());
                                Package mostRecent = toCheck.getTarget().getPackage();
                                if (toCheck.getTarget() instanceof VersionPackageConstraint) {
                                    mostRecent = WekaPackageManager.mostRecentVersionWithRespectToConstraint(toCheck.getTarget());
                                }
                                finalListToInstall.add(mostRecent);
                                continue;
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                PackageManager.this.displayErrorDialog("An error has occurred while checking package dependencies", ex);
                                depsOk = false;
                                break;
                            }
                        }
                        try {
                            Package mostRecent = toCheck.getTarget().getPackage();
                            if (toCheck.getTarget() instanceof VersionPackageConstraint) {
                                mostRecent = WekaPackageManager.mostRecentVersionWithRespectToConstraint(toCheck.getTarget());
                            }
                            finalListToInstall.add(mostRecent);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            PackageManager.this.displayErrorDialog("An error has occurred while checking package dependencies", ex);
                            depsOk = false;
                            break;
                        }
                    }
                    if (!depsOk) {
                        this.m_unsuccessfulInstalls.add(packageToInstall);
                        continue;
                    }
                    if (needsUpgrade.size() > 0) {
                        StringBuffer temp = new StringBuffer();
                        for (PackageConstraint pc : needsUpgrade) {
                            temp.append(pc + "\n");
                        }
                        int result = JOptionPane.showConfirmDialog(PackageManager.this, "The following packages will be upgraded in order to install:\n\n" + temp.toString(), "Weka Package Manager", 0);
                        if (result == 1) {
                            this.m_unsuccessfulInstalls.add(packageToInstall);
                            continue;
                        }
                        boolean conflictsAfterUpgrade = false;
                        List<Package> installed = null;
                        try {
                            installed = WekaPackageManager.getInstalledPackages();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            PackageManager.this.displayErrorDialog("Unable to determine what packages are installed!", e);
                            this.m_unsuccessfulInstalls.add(packageToInstall);
                            continue;
                        }
                        ArrayList<Package> toUpgrade = new ArrayList<Package>();
                        for (PackageConstraint pc : needsUpgrade) {
                            toUpgrade.add(pc.getPackage());
                        }
                        toUpgrade.add(packageToInstall);
                        StringBuffer tempM = new StringBuffer();
                        depsOk = true;
                        for (int i = 0; i < installed.size(); ++i) {
                            Package tempP = installed.get(i);
                            String tempPName = tempP.getName();
                            boolean checkIt = true;
                            for (int j = 0; j < needsUpgrade.size(); ++j) {
                                if (!tempPName.equals(((PackageConstraint)needsUpgrade.get(j)).getPackage().getName())) continue;
                                checkIt = false;
                                break;
                            }
                            if (!checkIt) continue;
                            List problem = null;
                            try {
                                problem = tempP.getIncompatibleDependencies(toUpgrade);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                PackageManager.this.displayErrorDialog("An error has occurred while checking package dependencies", e);
                                depsOk = false;
                                break;
                            }
                            if (problem.size() <= 0) continue;
                            conflictsAfterUpgrade = true;
                            tempM.append("Package " + tempP.getName() + " will have a compatibility" + "problem with the following packages after upgrading them:\n");
                            Iterator dI = problem.iterator();
                            while (dI.hasNext()) {
                                tempM.append("\t" + ((Dependency)dI.next()).getTarget().getPackage() + "\n");
                            }
                        }
                        if (!depsOk) {
                            this.m_unsuccessfulInstalls.add(packageToInstall);
                            continue;
                        }
                        if (conflictsAfterUpgrade) {
                            JOptionPane.showConfirmDialog(PackageManager.this, tempM.toString() + "\n" + "Unable to continue with installation.", "Weka Package Manager", 0);
                            this.m_unsuccessfulInstalls.add(packageToInstall);
                            continue;
                        }
                    }
                    if (finalListToInstall.size() > 0) {
                        StringBuffer message = new StringBuffer();
                        message.append("To install " + packageName + " the following packages will" + " be installed/upgraded:\n\n");
                        for (Package p : finalListToInstall) {
                            message.append("\t" + p + "\n");
                        }
                        int result = JOptionPane.showConfirmDialog(PackageManager.this, message.toString(), "Weka Package Manager", 0);
                        if (result == 1) {
                            this.m_unsuccessfulInstalls.add(packageToInstall);
                            continue;
                        }
                        PackageManager.this.m_progress.setMaximum(PackageManager.this.m_progress.getMaximum() + finalListToInstall.size() * 30);
                    }
                    try {
                        tempB = WekaPackageManager.installPackages(finalListToInstall, pps);
                        s_atLeastOnePackageUpgradeHasOccurredInThisSession = s_atLeastOnePackageUpgradeHasOccurredInThisSession || tempB;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        PackageManager.this.displayErrorDialog("An error has occurred while installing dependent packages", e);
                        this.m_unsuccessfulInstalls.add(packageToInstall);
                        continue;
                    }
                    try {
                        tempB = WekaPackageManager.installPackageFromRepository(packageName, versionToInstall.toString(), pps);
                        s_atLeastOnePackageUpgradeHasOccurredInThisSession = s_atLeastOnePackageUpgradeHasOccurredInThisSession || tempB;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        PackageManager.this.displayErrorDialog("Problem installing package: " + packageName, e);
                        this.m_unsuccessfulInstalls.add(packageToInstall);
                    }
                    continue;
                }
                try {
                    boolean tempB = WekaPackageManager.installPackageFromRepository(packageName, versionToInstall.toString(), pps);
                    s_atLeastOnePackageUpgradeHasOccurredInThisSession = s_atLeastOnePackageUpgradeHasOccurredInThisSession || tempB;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    PackageManager.this.displayErrorDialog("Problem installing package: " + packageName, e);
                    this.m_unsuccessfulInstalls.add(packageToInstall);
                }
            }
            if (!s_atLeastOnePackageUpgradeHasOccurredInThisSession) {
                WekaPackageManager.refreshGOEProperties();
            }
            return null;
        }

        @Override
        public void done() {
            PackageManager.this.m_progress.setValue(PackageManager.this.m_progress.getMinimum());
            if (this.m_unsuccessfulInstalls.size() == 0) {
                PackageManager.this.m_detailLabel.setText("Package(s) installed successfully.");
            } else {
                StringBuffer failedPackageNames = new StringBuffer();
                for (Package p : this.m_unsuccessfulInstalls) {
                    failedPackageNames.append(p.getName() + "\n");
                }
                PackageManager.this.displayErrorDialog("The following package(s) could not be installed\nfor some reason (check the log)\n" + failedPackageNames.toString(), "");
                PackageManager.this.m_detailLabel.setText("Install complete.");
            }
            PackageManager.this.m_unofficialBut.setEnabled(true);
            PackageManager.this.m_refreshCacheBut.setEnabled(!WekaPackageManager.m_offline);
            PackageManager.this.m_availableBut.setEnabled(true);
            PackageManager.this.m_allBut.setEnabled(true);
            PackageManager.this.m_installedBut.setEnabled(true);
            PackageManager.this.m_installedPackages = null;
            PackageManager.this.m_availablePackages = null;
            PackageManager.this.m_installing = false;
            PackageManager.this.updateTable();
            if (PackageManager.this.m_table.getSelectedRow() >= 0) {
                PackageManager.this.updateInstallUninstallButtonEnablement();
            }
        }
    }

    class UnofficialInstallTask
    extends SwingWorker<Void, Void>
    implements Progressable {
        private String m_target;
        private int m_progressCount = 0;
        private boolean m_errorOccurred = false;

        UnofficialInstallTask() {
        }

        public void setTargetToInstall(String target) {
            this.m_target = target;
        }

        @Override
        public void makeProgress(String progressMessage) {
            PackageManager.this.m_detailLabel.setText(progressMessage);
            ++this.m_progressCount;
            PackageManager.this.m_progress.setValue(this.m_progressCount);
            if (this.m_progressCount == PackageManager.this.m_progress.getMaximum()) {
                PackageManager.this.m_progress.setMaximum(this.m_progressCount + 5);
            }
        }

        @Override
        public void makeProgressMessageOnly(String progressMessage) {
            PackageManager.this.m_detailLabel.setText(progressMessage);
        }

        @Override
        public Void doInBackground() {
            Package installedPackage;
            ProgressPrintStream pps;
            block14: {
                PackageManager.this.m_installing = true;
                PackageManager.this.m_installBut.setEnabled(false);
                PackageManager.this.m_uninstallBut.setEnabled(false);
                PackageManager.this.m_refreshCacheBut.setEnabled(false);
                PackageManager.this.m_unofficialBut.setEnabled(false);
                PackageManager.this.m_availableBut.setEnabled(false);
                PackageManager.this.m_allBut.setEnabled(false);
                PackageManager.this.m_installedBut.setEnabled(false);
                pps = new ProgressPrintStream(this);
                PackageManager.this.m_progress.setMaximum(30);
                installedPackage = null;
                String toInstall = this.m_target;
                try {
                    toInstall = Environment.getSystemWide().substitute(this.m_target);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    String packageName;
                    if (toInstall.toLowerCase().startsWith("http://") || toInstall.toLowerCase().startsWith("https://")) {
                        packageName = WekaPackageManager.installPackageFromURL(new URL(toInstall), pps);
                        installedPackage = WekaPackageManager.getInstalledPackageInfo(packageName);
                        break block14;
                    }
                    if (toInstall.toLowerCase().endsWith(".zip")) {
                        packageName = WekaPackageManager.installPackageFromArchive(toInstall, pps);
                        installedPackage = WekaPackageManager.getInstalledPackageInfo(packageName);
                        break block14;
                    }
                    PackageManager.this.displayErrorDialog("Unable to install package \nfrom " + toInstall + ". Unrecognized as a URL or zip archive.", null);
                    this.m_errorOccurred = true;
                    return null;
                }
                catch (Exception ex) {
                    PackageManager.this.displayErrorDialog("Unable to install package \nfrom " + this.m_target + ". Check the log for error messages.", ex);
                    this.m_errorOccurred = true;
                    return null;
                }
            }
            if (installedPackage != null) {
                if (!Utils.getDontShowDialog("weka.gui.PackageManager.RestartAfterUpgrade")) {
                    JCheckBox dontShow = new JCheckBox("Do not show this message again");
                    Object[] stuff = new Object[]{"Weka will need to be restared after installation for\nthe changes to come into effect.\n", dontShow};
                    JOptionPane.showMessageDialog(PackageManager.this, stuff, "Weka Package Manager", 0);
                    if (dontShow.isSelected()) {
                        try {
                            Utils.setDontShowDialog("weka.gui.PackageManager.RestartAfterUpgrade");
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                }
                try {
                    File packageRoot = new File(WekaPackageManager.getPackageHome() + File.separator + installedPackage.getName());
                    boolean loadCheck = WekaPackageManager.loadCheck(installedPackage, packageRoot, pps);
                    if (!loadCheck) {
                        PackageManager.this.displayErrorDialog("Package was installed correctly but could not be loaded. Check log for details", null);
                    }
                }
                catch (Exception ex) {
                    PackageManager.this.displayErrorDialog("Unable to install package \nfrom " + this.m_target + ".", ex);
                    this.m_errorOccurred = true;
                }
            }
            return null;
        }

        @Override
        public void done() {
            PackageManager.this.m_progress.setValue(PackageManager.this.m_progress.getMinimum());
            if (this.m_errorOccurred) {
                PackageManager.this.m_detailLabel.setText("Problem installing - check log.");
            } else {
                PackageManager.this.m_detailLabel.setText("Package installed successfully.");
            }
            PackageManager.this.m_unofficialBut.setEnabled(true);
            PackageManager.this.m_refreshCacheBut.setEnabled(!WekaPackageManager.m_offline);
            PackageManager.this.m_availableBut.setEnabled(true);
            PackageManager.this.m_allBut.setEnabled(true);
            PackageManager.this.m_installedBut.setEnabled(true);
            PackageManager.this.m_installedPackages = null;
            PackageManager.this.m_availablePackages = null;
            PackageManager.this.m_installing = false;
            PackageManager.this.updateTable();
            if (PackageManager.this.m_table.getSelectedRow() >= 0) {
                PackageManager.this.updateInstallUninstallButtonEnablement();
            }
        }
    }

    class UninstallTask
    extends SwingWorker<Void, Void>
    implements Progressable {
        private List<String> m_packageNamesToUninstall;
        private final List<String> m_unsuccessfulUninstalls = new ArrayList<String>();
        private int m_progressCount = 0;

        UninstallTask() {
        }

        public void setPackages(List<String> packageNames) {
            this.m_packageNamesToUninstall = packageNames;
        }

        @Override
        public void makeProgress(String progressMessage) {
            PackageManager.this.m_detailLabel.setText(progressMessage);
            ++this.m_progressCount;
            PackageManager.this.m_progress.setValue(this.m_progressCount);
            if (this.m_progressCount == PackageManager.this.m_progress.getMaximum()) {
                PackageManager.this.m_progress.setMaximum(this.m_progressCount + 5);
            }
        }

        @Override
        public void makeProgressMessageOnly(String progressMessage) {
            PackageManager.this.m_detailLabel.setText(progressMessage);
        }

        @Override
        public Void doInBackground() {
            PackageManager.this.m_installing = true;
            PackageManager.this.m_installBut.setEnabled(false);
            PackageManager.this.m_unofficialBut.setEnabled(false);
            PackageManager.this.m_uninstallBut.setEnabled(false);
            PackageManager.this.m_refreshCacheBut.setEnabled(false);
            PackageManager.this.m_availableBut.setEnabled(false);
            PackageManager.this.m_allBut.setEnabled(false);
            PackageManager.this.m_installedBut.setEnabled(false);
            ProgressPrintStream pps = new ProgressPrintStream(this);
            PackageManager.this.m_progress.setMaximum(this.m_packageNamesToUninstall.size() * 5);
            for (int zz = 0; zz < this.m_packageNamesToUninstall.size(); ++zz) {
                String packageName = this.m_packageNamesToUninstall.get(zz);
                boolean explorerPropertiesExist = WekaPackageManager.installedPackageResourceExists(packageName, "Explorer.props");
                if (!PackageManager.this.m_forceBut.isSelected()) {
                    List<Package> installedPackages;
                    ArrayList<Package> compromised = new ArrayList<Package>();
                    try {
                        installedPackages = WekaPackageManager.getInstalledPackages();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        PackageManager.this.displayErrorDialog("Can't determine which packages are installed!", e);
                        this.m_unsuccessfulUninstalls.add(packageName);
                        continue;
                    }
                    block7: for (Package p : installedPackages) {
                        List tempDeps;
                        try {
                            tempDeps = p.getDependencies();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            PackageManager.this.displayErrorDialog("Problem determining dependencies for package : " + p.getName(), e);
                            this.m_unsuccessfulUninstalls.add(packageName);
                            continue;
                        }
                        for (Dependency d : tempDeps) {
                            if (!d.getTarget().getPackage().getName().equals(packageName)) continue;
                            compromised.add(p);
                            continue block7;
                        }
                    }
                    if (compromised.size() > 0) {
                        StringBuffer message = new StringBuffer();
                        message.append("The following installed packages depend on " + packageName + " :\n\n");
                        for (Package p : compromised) {
                            message.append("\t" + p.getName() + "\n");
                        }
                        message.append("\nDo you wish to proceed?");
                        int result = JOptionPane.showConfirmDialog(PackageManager.this, message.toString(), "Weka Package Manager", 0);
                        if (result == 1) continue;
                    }
                }
                try {
                    if (explorerPropertiesExist) {
                        WekaPackageManager.removeExplorerProps(packageName);
                    }
                    WekaPackageManager.uninstallPackage(packageName, true, pps);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    PackageManager.this.displayErrorDialog("Unable to uninstall package: " + packageName, e);
                    this.m_unsuccessfulUninstalls.add(packageName);
                }
            }
            WekaPackageManager.refreshGOEProperties();
            return null;
        }

        @Override
        public void done() {
            PackageManager.this.m_progress.setValue(PackageManager.this.m_progress.getMinimum());
            if (this.m_unsuccessfulUninstalls.size() == 0) {
                PackageManager.this.m_detailLabel.setText("Packages removed successfully.");
                if (!Utils.getDontShowDialog("weka.gui.PackageManager.RestartAfterUninstall")) {
                    JCheckBox dontShow = new JCheckBox("Do not show this message again");
                    Object[] stuff = new Object[]{"Weka might need to be restarted for\nthe changes to come into effect.\n", dontShow};
                    JOptionPane.showMessageDialog(PackageManager.this, stuff, "Weka Package Manager", 0);
                    if (dontShow.isSelected()) {
                        try {
                            Utils.setDontShowDialog("weka.gui.PackageManager.RestartAfterUninstall");
                        }
                        catch (Exception ex) {}
                    }
                }
            } else {
                StringBuffer failedPackageNames = new StringBuffer();
                for (String p : this.m_unsuccessfulUninstalls) {
                    failedPackageNames.append(p + "\n");
                }
                PackageManager.this.displayErrorDialog("The following package(s) could not be uninstalled\nfor some reason (check the log)\n" + failedPackageNames.toString(), "");
                PackageManager.this.m_detailLabel.setText("Finished uninstalling.");
            }
            PackageManager.this.m_unofficialBut.setEnabled(true);
            PackageManager.this.m_refreshCacheBut.setEnabled(true);
            PackageManager.this.m_availableBut.setEnabled(true);
            PackageManager.this.m_allBut.setEnabled(true);
            PackageManager.this.m_installedBut.setEnabled(true);
            PackageManager.this.m_installedPackages = null;
            PackageManager.this.m_availablePackages = null;
            PackageManager.this.m_installing = false;
            PackageManager.this.updateTable();
            if (PackageManager.this.m_table.getSelectedRow() >= 0) {
                PackageManager.this.updateInstallUninstallButtonEnablement();
            }
        }
    }

    class RefreshCache
    extends SwingWorker<Void, Void>
    implements Progressable {
        private int m_progressCount = 0;
        private Exception m_error = null;

        RefreshCache() {
        }

        @Override
        public void makeProgress(String progressMessage) {
            PackageManager.this.m_detailLabel.setText(progressMessage);
            if (progressMessage.startsWith("[Default")) {
                String kbs = progressMessage.replace("[DefaultPackageManager] downloaded ", "");
                kbs = kbs.replace(" KB", "");
                this.m_progressCount = Integer.parseInt(kbs);
            } else {
                ++this.m_progressCount;
            }
            PackageManager.this.m_progress.setValue(this.m_progressCount);
        }

        @Override
        public void makeProgressMessageOnly(String progressMessage) {
            PackageManager.this.m_detailLabel.setText(progressMessage);
        }

        @Override
        public Void doInBackground() {
            PackageManager.this.m_cacheRefreshInProgress = true;
            int progressUpper = WekaPackageManager.repoZipArchiveSize();
            if (progressUpper == -1) {
                progressUpper = WekaPackageManager.numRepositoryPackages();
            }
            if (progressUpper < 0) {
                progressUpper = 100;
            }
            PackageManager.this.m_progress.setMaximum(progressUpper);
            PackageManager.this.m_refreshCacheBut.setEnabled(false);
            PackageManager.this.m_installBut.setEnabled(false);
            PackageManager.this.m_unofficialBut.setEnabled(false);
            PackageManager.this.m_installedBut.setEnabled(false);
            PackageManager.this.m_availableBut.setEnabled(false);
            PackageManager.this.m_allBut.setEnabled(false);
            ProgressPrintStream pps = new ProgressPrintStream(this);
            this.m_error = WekaPackageManager.refreshCache(pps);
            PackageManager.this.getAllPackages();
            return null;
        }

        @Override
        public void done() {
            PackageManager.this.m_progress.setValue(PackageManager.this.m_progress.getMinimum());
            if (this.m_error != null) {
                PackageManager.this.displayErrorDialog("There was a problem refreshing the package\nmeta data cache. We'll try to use the repositorydirectly.", this.m_error);
                PackageManager.this.m_detailLabel.setText("");
            } else {
                PackageManager.this.m_detailLabel.setText("Cache refresh completed");
            }
            PackageManager.this.m_installBut.setEnabled(!WekaPackageManager.m_offline);
            PackageManager.this.m_unofficialBut.setEnabled(true);
            PackageManager.this.m_refreshCacheBut.setEnabled(!WekaPackageManager.m_offline);
            PackageManager.this.m_installedBut.setEnabled(true);
            PackageManager.this.m_availableBut.setEnabled(true);
            PackageManager.this.m_allBut.setEnabled(true);
            PackageManager.this.updateTable();
            try {
                PackageManager.this.m_browserTools.remove(PackageManager.this.m_newPackagesAvailableL);
                PackageManager.this.m_browserTools.revalidate();
            }
            catch (Exception exception) {
                // empty catch block
            }
            PackageManager.this.m_cacheRefreshInProgress = false;
        }
    }

    class CheckForNewPackages
    extends SwingWorker<Void, Void> {
        CheckForNewPackages() {
        }

        @Override
        public Void doInBackground() {
            Map<String, String> localPackageNameList = WekaPackageManager.getPackageList(true);
            if (localPackageNameList == null) {
                return null;
            }
            Map<String, String> repositoryPackageNameList = WekaPackageManager.getPackageList(false);
            if (repositoryPackageNameList == null) {
                return null;
            }
            if (repositoryPackageNameList.keySet().size() < localPackageNameList.keySet().size()) {
                RefreshCache r = new RefreshCache();
                r.execute();
                return null;
            }
            StringBuffer newPackagesBuff = new StringBuffer();
            StringBuffer updatedPackagesBuff = new StringBuffer();
            for (String s : repositoryPackageNameList.keySet()) {
                if (localPackageNameList.containsKey(s)) continue;
                newPackagesBuff.append(s + "<br>");
            }
            for (String localPackage : localPackageNameList.keySet()) {
                String localVersion = localPackageNameList.get(localPackage);
                String repoVersion = repositoryPackageNameList.get(localPackage);
                if (repoVersion == null || localVersion.equals(repoVersion)) continue;
                updatedPackagesBuff.append(localPackage + " (" + repoVersion + ")<br>");
            }
            if (newPackagesBuff.length() > 0 || updatedPackagesBuff.length() > 0) {
                String information = "<html><font size=-2>There are new and/or updated packages available on the server (do a cache refresh for more information):";
                if (newPackagesBuff.length() > 0) {
                    information = information + "<br><br><b>New:</b><br>" + newPackagesBuff.toString();
                }
                if (updatedPackagesBuff.length() > 0) {
                    information = information + "<br><br><b>Updated:</b><br>" + updatedPackagesBuff.toString() + "<br><br>";
                }
                information = information + "</font></html>";
                PackageManager.this.m_newPackagesAvailableL.setToolTipText(information);
                PackageManager.this.m_browserTools.add(PackageManager.this.m_newPackagesAvailableL);
                PackageManager.this.m_browserTools.revalidate();
            }
            return null;
        }
    }

    class EstablishCache
    extends SwingWorker<Void, Void>
    implements Progressable {
        private int m_progressCount = 0;
        private Exception m_error = null;
        private ProgressMonitor m_progress;

        EstablishCache() {
        }

        @Override
        public void makeProgress(String progressMessage) {
            this.m_progress.setNote(progressMessage);
            ++this.m_progressCount;
            this.m_progress.setProgress(this.m_progressCount);
        }

        @Override
        public void makeProgressMessageOnly(String progressMessage) {
            this.m_progress.setNote(progressMessage);
        }

        @Override
        public Void doInBackground() {
            int numPackages = WekaPackageManager.numRepositoryPackages();
            if (numPackages < 0) {
                numPackages = 100;
            }
            this.m_progress = new ProgressMonitor(PackageManager.this, "Establising cache...", "", 0, numPackages);
            ProgressPrintStream pps = new ProgressPrintStream(this);
            this.m_error = WekaPackageManager.establishCacheIfNeeded(pps);
            PackageManager.this.m_cacheEstablished = true;
            return null;
        }

        @Override
        public void done() {
            this.m_progress.close();
            if (this.m_error != null) {
                PackageManager.this.displayErrorDialog("There was a problem establishing the package\nmeta data cache. We'll try to use the repositorydirectly.", this.m_error);
            }
        }
    }

    static interface Progressable {
        public void makeProgress(String var1);

        public void makeProgressMessageOnly(String var1);
    }

    class ProgressPrintStream
    extends PrintStream {
        private final Progressable m_listener;

        public ProgressPrintStream(Progressable listener) {
            super(System.out);
            this.m_listener = listener;
        }

        @Override
        public void println(String string) {
            boolean messageOnly = false;
            if (string.startsWith("%%")) {
                string = string.substring(2);
                messageOnly = true;
            }
            if (!messageOnly) {
                System.out.println(string);
                this.m_listener.makeProgress(string);
            } else {
                this.m_listener.makeProgressMessageOnly(string);
            }
        }

        @Override
        public void println(Object obj) {
            this.println(obj.toString());
        }

        @Override
        public void print(String string) {
            boolean messageOnly = false;
            if (string.startsWith("%%")) {
                string = string.substring(2);
                messageOnly = true;
            }
            if (!messageOnly) {
                System.out.print(string);
                this.m_listener.makeProgress(string);
            } else {
                this.m_listener.makeProgressMessageOnly(string);
            }
        }

        @Override
        public void print(Object obj) {
            this.print(obj.toString());
        }
    }
}

