/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.EventSetDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import weka.classifiers.Classifier;
import weka.classifiers.misc.InputMappedClassifier;
import weka.clusterers.Clusterer;
import weka.clusterers.DensityBasedClusterer;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Add;
import weka.gui.Logger;
import weka.gui.beans.BatchClassifierEvent;
import weka.gui.beans.BatchClassifierListener;
import weka.gui.beans.BatchClustererEvent;
import weka.gui.beans.BatchClustererListener;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSource;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.IncrementalClassifierEvent;
import weka.gui.beans.IncrementalClassifierListener;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.InstanceListener;
import weka.gui.beans.StreamThroughput;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TestSetProducer;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.TrainingSetProducer;
import weka.gui.beans.Visible;

public class PredictionAppender
extends JPanel
implements DataSource,
TrainingSetProducer,
TestSetProducer,
Visible,
BeanCommon,
EventConstraints,
BatchClassifierListener,
IncrementalClassifierListener,
BatchClustererListener,
Serializable {
    private static final long serialVersionUID = -2987740065058976673L;
    protected Vector m_dataSourceListeners = new Vector();
    protected Vector m_instanceListeners = new Vector();
    protected Vector m_trainingSetListeners = new Vector();
    protected Vector m_testSetListeners = new Vector();
    protected Object m_listenee = null;
    protected Instances m_format;
    protected BeanVisual m_visual = new BeanVisual("PredictionAppender", "weka/gui/beans/icons/PredictionAppender.gif", "weka/gui/beans/icons/PredictionAppender_animated.gif");
    protected boolean m_appendProbabilities;
    protected transient Logger m_logger;
    protected transient List<Integer> m_stringAttIndexes;
    protected InstanceEvent m_instanceEvent;
    protected transient StreamThroughput m_throughput;

    public String globalInfo() {
        return "Accepts batch or incremental classifier events and produces a new data set with classifier predictions appended.";
    }

    public PredictionAppender() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    public String appendPredictedProbabilitiesTipText() {
        return "append probabilities rather than labels for discrete class predictions";
    }

    public boolean getAppendPredictedProbabilities() {
        return this.m_appendProbabilities;
    }

    public void setAppendPredictedProbabilities(boolean ap) {
        this.m_appendProbabilities = ap;
    }

    @Override
    public void addTrainingSetListener(TrainingSetListener tsl) {
        this.m_trainingSetListeners.addElement(tsl);
        if (this.m_format != null) {
            TrainingSetEvent e = new TrainingSetEvent(this, this.m_format);
            tsl.acceptTrainingSet(e);
        }
    }

    @Override
    public void removeTrainingSetListener(TrainingSetListener tsl) {
        this.m_trainingSetListeners.removeElement(tsl);
    }

    @Override
    public void addTestSetListener(TestSetListener tsl) {
        this.m_testSetListeners.addElement(tsl);
        if (this.m_format != null) {
            TestSetEvent e = new TestSetEvent(this, this.m_format);
            tsl.acceptTestSet(e);
        }
    }

    @Override
    public void removeTestSetListener(TestSetListener tsl) {
        this.m_testSetListeners.removeElement(tsl);
    }

    @Override
    public synchronized void addDataSourceListener(DataSourceListener dsl) {
        this.m_dataSourceListeners.addElement(dsl);
        if (this.m_format != null) {
            DataSetEvent e = new DataSetEvent(this, this.m_format);
            dsl.acceptDataSet(e);
        }
    }

    @Override
    public synchronized void removeDataSourceListener(DataSourceListener dsl) {
        this.m_dataSourceListeners.remove(dsl);
    }

    @Override
    public synchronized void addInstanceListener(InstanceListener dsl) {
        this.m_instanceListeners.addElement(dsl);
        if (this.m_format != null) {
            InstanceEvent e = new InstanceEvent(this, this.m_format);
            dsl.acceptInstance(e);
        }
    }

    @Override
    public synchronized void removeInstanceListener(InstanceListener dsl) {
        this.m_instanceListeners.remove(dsl);
    }

    @Override
    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    @Override
    public BeanVisual getVisual() {
        return this.m_visual;
    }

    @Override
    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/PredictionAppender.gif", "weka/gui/beans/icons/PredictionAppender_animated.gif");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void acceptClassifier(IncrementalClassifierEvent e) {
        classifier = e.getClassifier();
        currentI = e.getCurrentInstance();
        status = e.getStatus();
        oldNumAtts = 0;
        if (status == 0) {
            oldNumAtts = e.getStructure().numAttributes();
            this.m_throughput = new StreamThroughput(this.statusMessagePrefix());
        } else if (currentI != null) {
            oldNumAtts = currentI.dataset().numAttributes();
        }
        if (status == 0) {
            this.m_instanceEvent = new InstanceEvent(this, null, 0);
            oldStructure = new Instances(e.getStructure(), 0);
            this.m_stringAttIndexes = new ArrayList<Integer>();
            for (i = 0; i < e.getStructure().numAttributes(); ++i) {
                if (!e.getStructure().attribute(i).isString()) continue;
                this.m_stringAttIndexes.add(new Integer(i));
            }
            relationNameModifier = "_with predictions";
            if (!this.m_appendProbabilities || oldStructure.classAttribute().isNumeric()) {
                try {
                    this.m_format = this.makeDataSetClass(oldStructure, oldStructure, classifier, relationNameModifier);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return;
                }
            }
            if (this.m_appendProbabilities) {
                try {
                    this.m_format = this.makeDataSetProbabilities(oldStructure, oldStructure, classifier, relationNameModifier);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return;
                }
            }
            this.m_instanceEvent.setStructure(this.m_format);
            this.notifyInstanceAvailable(this.m_instanceEvent);
            return;
        }
        if (currentI != null) {
            this.m_throughput.updateStart();
            instanceVals = new double[this.m_format.numAttributes()];
            newInst = null;
            try {
                for (i = 0; i < oldNumAtts; ++i) {
                    instanceVals[i] = currentI.value(i);
                }
                if (!this.m_appendProbabilities || currentI.dataset().classAttribute().isNumeric()) {
                    instanceVals[instanceVals.length - 1] = predClass = classifier.classifyInstance(currentI);
                }
                if (!this.m_appendProbabilities) ** GOTO lbl73
                preds = classifier.distributionForInstance(currentI);
                for (i = oldNumAtts; i < instanceVals.length; ++i) {
                    instanceVals[i] = preds[i - oldNumAtts];
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
            finally {
                newInst = new DenseInstance(currentI.weight(), instanceVals);
                newInst.setDataset(this.m_format);
                if (this.m_stringAttIndexes != null) {
                    for (i = 0; i < this.m_stringAttIndexes.size(); ++i) {
                        index = this.m_stringAttIndexes.get(i);
                        this.m_format.attribute(this.m_stringAttIndexes.get(i)).setStringValue(currentI.stringValue(index));
                    }
                }
                this.m_instanceEvent.setInstance(newInst);
                this.m_instanceEvent.setStatus(status);
                this.m_throughput.updateEnd(this.m_logger);
                this.notifyInstanceAvailable(this.m_instanceEvent);
            }
        } else {
            this.m_instanceEvent.setInstance(null);
            this.notifyInstanceAvailable(this.m_instanceEvent);
        }
lbl73:
        // 4 sources

        if (status == 2 || currentI == null) {
            this.m_instanceEvent = null;
            this.m_throughput.finished(this.m_logger);
        }
    }

    @Override
    public void acceptClassifier(BatchClassifierEvent e) {
        if (this.m_dataSourceListeners.size() > 0 || this.m_trainingSetListeners.size() > 0 || this.m_testSetListeners.size() > 0) {
            if (e.getTestSet() == null) {
                return;
            }
            if ((e.getTestSet().isStructureOnly() || e.getTestSet().getDataSet().numInstances() == 0) && e.getTestSet().getDataSet().classIndex() < 0) {
                return;
            }
            if (e.getTestSet().getDataSet().classIndex() < 0) {
                if (this.m_logger != null) {
                    this.m_logger.logMessage("[PredictionAppender] " + this.statusMessagePrefix() + "No class attribute set in the data!");
                    this.m_logger.statusMessage(this.statusMessagePrefix() + "ERROR: Can't append probablities - see log.");
                }
                this.stop();
                return;
            }
            Instances testSet = e.getTestSet().getDataSet();
            Instances trainSet = e.getTrainSet().getDataSet();
            int setNum = e.getSetNumber();
            int maxNum = e.getMaxSetNumber();
            Classifier classifier = e.getClassifier();
            String relationNameModifier = "_set_" + e.getSetNumber() + "_of_" + e.getMaxSetNumber();
            if (!this.m_appendProbabilities || testSet.classAttribute().isNumeric()) {
                try {
                    double predClass;
                    EventObject tse;
                    Instances newTestSetInstances = this.makeDataSetClass(testSet, trainSet, classifier, relationNameModifier);
                    Instances newTrainingSetInstances = this.makeDataSetClass(trainSet, trainSet, classifier, relationNameModifier);
                    if (this.m_trainingSetListeners.size() > 0) {
                        tse = new TrainingSetEvent(this, new Instances(newTrainingSetInstances, 0));
                        tse.m_setNumber = setNum;
                        tse.m_maxSetNumber = maxNum;
                        this.notifyTrainingSetAvailable((TrainingSetEvent)tse);
                        for (int i = 0; i < trainSet.numInstances(); ++i) {
                            predClass = classifier.classifyInstance(trainSet.instance(i));
                            newTrainingSetInstances.instance(i).setValue(newTrainingSetInstances.numAttributes() - 1, predClass);
                        }
                        tse = new TrainingSetEvent(this, newTrainingSetInstances);
                        tse.m_setNumber = setNum;
                        tse.m_maxSetNumber = maxNum;
                        this.notifyTrainingSetAvailable((TrainingSetEvent)tse);
                    }
                    if (this.m_testSetListeners.size() > 0) {
                        tse = new TestSetEvent(this, new Instances(newTestSetInstances, 0));
                        ((TestSetEvent)tse).m_setNumber = setNum;
                        ((TestSetEvent)tse).m_maxSetNumber = maxNum;
                        this.notifyTestSetAvailable((TestSetEvent)tse);
                    }
                    if (this.m_dataSourceListeners.size() > 0) {
                        this.notifyDataSetAvailable(new DataSetEvent(this, new Instances(newTestSetInstances, 0)));
                    }
                    if (e.getTestSet().isStructureOnly()) {
                        this.m_format = newTestSetInstances;
                    }
                    if (this.m_dataSourceListeners.size() > 0 || this.m_testSetListeners.size() > 0) {
                        for (int i = 0; i < testSet.numInstances(); ++i) {
                            Instance tempInst = testSet.instance(i);
                            if (tempInst.isMissing(tempInst.classIndex()) && !(classifier instanceof InputMappedClassifier)) {
                                tempInst = (Instance)testSet.instance(i).copy();
                                tempInst.setDataset(trainSet);
                            }
                            predClass = classifier.classifyInstance(tempInst);
                            newTestSetInstances.instance(i).setValue(newTestSetInstances.numAttributes() - 1, predClass);
                        }
                    }
                    if (this.m_testSetListeners.size() > 0) {
                        TestSetEvent tse2 = new TestSetEvent(this, newTestSetInstances);
                        tse2.m_setNumber = setNum;
                        tse2.m_maxSetNumber = maxNum;
                        this.notifyTestSetAvailable(tse2);
                    }
                    if (this.m_dataSourceListeners.size() > 0) {
                        this.notifyDataSetAvailable(new DataSetEvent(this, newTestSetInstances));
                    }
                    return;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (this.m_appendProbabilities) {
                try {
                    int j;
                    double[] preds;
                    EventObject tse;
                    Instances newTestSetInstances = this.makeDataSetProbabilities(testSet, trainSet, classifier, relationNameModifier);
                    Instances newTrainingSetInstances = this.makeDataSetProbabilities(trainSet, trainSet, classifier, relationNameModifier);
                    if (this.m_trainingSetListeners.size() > 0) {
                        tse = new TrainingSetEvent(this, new Instances(newTrainingSetInstances, 0));
                        tse.m_setNumber = setNum;
                        tse.m_maxSetNumber = maxNum;
                        this.notifyTrainingSetAvailable((TrainingSetEvent)tse);
                        for (int i = 0; i < trainSet.numInstances(); ++i) {
                            preds = classifier.distributionForInstance(trainSet.instance(i));
                            for (j = 0; j < trainSet.classAttribute().numValues(); ++j) {
                                newTrainingSetInstances.instance(i).setValue(trainSet.numAttributes() + j, preds[j]);
                            }
                        }
                        tse = new TrainingSetEvent(this, newTrainingSetInstances);
                        tse.m_setNumber = setNum;
                        tse.m_maxSetNumber = maxNum;
                        this.notifyTrainingSetAvailable((TrainingSetEvent)tse);
                    }
                    if (this.m_testSetListeners.size() > 0) {
                        tse = new TestSetEvent(this, new Instances(newTestSetInstances, 0));
                        ((TestSetEvent)tse).m_setNumber = setNum;
                        ((TestSetEvent)tse).m_maxSetNumber = maxNum;
                        this.notifyTestSetAvailable((TestSetEvent)tse);
                    }
                    if (this.m_dataSourceListeners.size() > 0) {
                        this.notifyDataSetAvailable(new DataSetEvent(this, new Instances(newTestSetInstances, 0)));
                    }
                    if (e.getTestSet().isStructureOnly()) {
                        this.m_format = newTestSetInstances;
                    }
                    if (this.m_dataSourceListeners.size() > 0 || this.m_testSetListeners.size() > 0) {
                        for (int i = 0; i < testSet.numInstances(); ++i) {
                            Instance tempInst = testSet.instance(i);
                            if (tempInst.isMissing(tempInst.classIndex()) && !(classifier instanceof InputMappedClassifier)) {
                                tempInst = (Instance)testSet.instance(i).copy();
                                tempInst.setDataset(trainSet);
                            }
                            preds = classifier.distributionForInstance(tempInst);
                            for (j = 0; j < tempInst.classAttribute().numValues(); ++j) {
                                newTestSetInstances.instance(i).setValue(testSet.numAttributes() + j, preds[j]);
                            }
                        }
                    }
                    if (this.m_testSetListeners.size() > 0) {
                        TestSetEvent tse3 = new TestSetEvent(this, newTestSetInstances);
                        tse3.m_setNumber = setNum;
                        tse3.m_maxSetNumber = maxNum;
                        this.notifyTestSetAvailable(tse3);
                    }
                    if (this.m_dataSourceListeners.size() > 0) {
                        this.notifyDataSetAvailable(new DataSetEvent(this, newTestSetInstances));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    @Override
    public void acceptClusterer(BatchClustererEvent e) {
        if (this.m_dataSourceListeners.size() > 0 || this.m_trainingSetListeners.size() > 0 || this.m_testSetListeners.size() > 0) {
            if (e.getTestSet().isStructureOnly()) {
                return;
            }
            Instances testSet = e.getTestSet().getDataSet();
            Clusterer clusterer = e.getClusterer();
            String test = e.getTestOrTrain() == 0 ? "test" : "training";
            String relationNameModifier = "_" + test + "_" + e.getSetNumber() + "_of_" + e.getMaxSetNumber();
            if (!this.m_appendProbabilities || !(clusterer instanceof DensityBasedClusterer)) {
                if (this.m_appendProbabilities && !(clusterer instanceof DensityBasedClusterer)) {
                    System.err.println("Only density based clusterers can append probabilities. Instead cluster will be assigned for each instance.");
                    if (this.m_logger != null) {
                        this.m_logger.logMessage("[PredictionAppender] " + this.statusMessagePrefix() + " Only density based clusterers can " + "append probabilities. Instead cluster will be assigned for each " + "instance.");
                        this.m_logger.statusMessage(this.statusMessagePrefix() + "WARNING: Only density based clusterers can append probabilities. " + "Instead cluster will be assigned for each instance.");
                    }
                }
                try {
                    EventObject tse;
                    Instances newInstances = this.makeClusterDataSetClass(testSet, clusterer, relationNameModifier);
                    if (this.m_dataSourceListeners.size() > 0) {
                        this.notifyDataSetAvailable(new DataSetEvent(this, new Instances(newInstances, 0)));
                    }
                    if (this.m_trainingSetListeners.size() > 0 && e.getTestOrTrain() > 0) {
                        tse = new TrainingSetEvent(this, new Instances(newInstances, 0));
                        tse.m_setNumber = e.getSetNumber();
                        tse.m_maxSetNumber = e.getMaxSetNumber();
                        this.notifyTrainingSetAvailable((TrainingSetEvent)tse);
                    }
                    if (this.m_testSetListeners.size() > 0 && e.getTestOrTrain() == 0) {
                        tse = new TestSetEvent(this, new Instances(newInstances, 0));
                        ((TestSetEvent)tse).m_setNumber = e.getSetNumber();
                        ((TestSetEvent)tse).m_maxSetNumber = e.getMaxSetNumber();
                        this.notifyTestSetAvailable((TestSetEvent)tse);
                    }
                    for (int i = 0; i < testSet.numInstances(); ++i) {
                        double predCluster = clusterer.clusterInstance(testSet.instance(i));
                        newInstances.instance(i).setValue(newInstances.numAttributes() - 1, predCluster);
                    }
                    if (this.m_dataSourceListeners.size() > 0) {
                        this.notifyDataSetAvailable(new DataSetEvent(this, newInstances));
                    }
                    if (this.m_trainingSetListeners.size() > 0 && e.getTestOrTrain() > 0) {
                        TrainingSetEvent tse2 = new TrainingSetEvent(this, newInstances);
                        tse2.m_setNumber = e.getSetNumber();
                        tse2.m_maxSetNumber = e.getMaxSetNumber();
                        this.notifyTrainingSetAvailable(tse2);
                    }
                    if (this.m_testSetListeners.size() > 0 && e.getTestOrTrain() == 0) {
                        TestSetEvent tse3 = new TestSetEvent(this, newInstances);
                        tse3.m_setNumber = e.getSetNumber();
                        tse3.m_maxSetNumber = e.getMaxSetNumber();
                        this.notifyTestSetAvailable(tse3);
                    }
                    return;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                try {
                    Instances newInstances = this.makeClusterDataSetProbabilities(testSet, clusterer, relationNameModifier);
                    this.notifyDataSetAvailable(new DataSetEvent(this, new Instances(newInstances, 0)));
                    for (int i = 0; i < testSet.numInstances(); ++i) {
                        double[] probs = clusterer.distributionForInstance(testSet.instance(i));
                        for (int j = 0; j < clusterer.numberOfClusters(); ++j) {
                            newInstances.instance(i).setValue(testSet.numAttributes() + j, probs[j]);
                        }
                    }
                    this.notifyDataSetAvailable(new DataSetEvent(this, newInstances));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private Instances makeDataSetProbabilities(Instances insts, Instances format, Classifier classifier, String relationNameModifier) throws Exception {
        if (classifier instanceof InputMappedClassifier) {
            format = ((InputMappedClassifier)classifier).getModelHeader(new Instances(format, 0));
        }
        String classifierName = classifier.getClass().getName();
        classifierName = classifierName.substring(classifierName.lastIndexOf(46) + 1, classifierName.length());
        int numOrigAtts = insts.numAttributes();
        Instances newInstances = new Instances(insts);
        for (int i = 0; i < format.classAttribute().numValues(); ++i) {
            Add addF = new Add();
            addF.setAttributeIndex("last");
            addF.setAttributeName(classifierName + "_prob_" + format.classAttribute().value(i));
            addF.setInputFormat(newInstances);
            newInstances = Filter.useFilter(newInstances, addF);
        }
        newInstances.setRelationName(insts.relationName() + relationNameModifier);
        return newInstances;
    }

    private Instances makeDataSetClass(Instances insts, Instances structure, Classifier classifier, String relationNameModifier) throws Exception {
        if (classifier instanceof InputMappedClassifier) {
            structure = ((InputMappedClassifier)classifier).getModelHeader(new Instances(structure, 0));
        }
        Add addF = new Add();
        addF.setAttributeIndex("last");
        String classifierName = classifier.getClass().getName();
        classifierName = classifierName.substring(classifierName.lastIndexOf(46) + 1, classifierName.length());
        addF.setAttributeName("class_predicted_by: " + classifierName);
        if (structure.classAttribute().isNominal()) {
            String classLabels = "";
            Enumeration enu = structure.classAttribute().enumerateValues();
            classLabels = classLabels + (String)enu.nextElement();
            while (enu.hasMoreElements()) {
                classLabels = classLabels + "," + (String)enu.nextElement();
            }
            addF.setNominalLabels(classLabels);
        }
        addF.setInputFormat(insts);
        Instances newInstances = Filter.useFilter(insts, addF);
        newInstances.setRelationName(insts.relationName() + relationNameModifier);
        return newInstances;
    }

    private Instances makeClusterDataSetProbabilities(Instances format, Clusterer clusterer, String relationNameModifier) throws Exception {
        int numOrigAtts = format.numAttributes();
        Instances newInstances = new Instances(format);
        for (int i = 0; i < clusterer.numberOfClusters(); ++i) {
            Add addF = new Add();
            addF.setAttributeIndex("last");
            addF.setAttributeName("prob_cluster" + i);
            addF.setInputFormat(newInstances);
            newInstances = Filter.useFilter(newInstances, addF);
        }
        newInstances.setRelationName(format.relationName() + relationNameModifier);
        return newInstances;
    }

    private Instances makeClusterDataSetClass(Instances format, Clusterer clusterer, String relationNameModifier) throws Exception {
        Add addF = new Add();
        addF.setAttributeIndex("last");
        String clustererName = clusterer.getClass().getName();
        clustererName = clustererName.substring(clustererName.lastIndexOf(46) + 1, clustererName.length());
        addF.setAttributeName("assigned_cluster: " + clustererName);
        String clusterLabels = "0";
        for (int i = 1; i <= clusterer.numberOfClusters() - 1; ++i) {
            clusterLabels = clusterLabels + "," + i;
        }
        addF.setNominalLabels(clusterLabels);
        addF.setInputFormat(format);
        Instances newInstances = Filter.useFilter(format, addF);
        newInstances.setRelationName(format.relationName() + relationNameModifier);
        return newInstances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyInstanceAvailable(InstanceEvent e) {
        Vector l;
        PredictionAppender predictionAppender = this;
        synchronized (predictionAppender) {
            l = (Vector)this.m_instanceListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((InstanceListener)l.elementAt(i)).acceptInstance(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyDataSetAvailable(DataSetEvent e) {
        Vector l;
        PredictionAppender predictionAppender = this;
        synchronized (predictionAppender) {
            l = (Vector)this.m_dataSourceListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((DataSourceListener)l.elementAt(i)).acceptDataSet(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyTestSetAvailable(TestSetEvent e) {
        Vector l;
        PredictionAppender predictionAppender = this;
        synchronized (predictionAppender) {
            l = (Vector)this.m_testSetListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((TestSetListener)l.elementAt(i)).acceptTestSet(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyTrainingSetAvailable(TrainingSetEvent e) {
        Vector l;
        PredictionAppender predictionAppender = this;
        synchronized (predictionAppender) {
            l = (Vector)this.m_trainingSetListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((TrainingSetListener)l.elementAt(i)).acceptTrainingSet(e);
            }
        }
    }

    @Override
    public void setLog(Logger logger) {
        this.m_logger = logger;
    }

    @Override
    public void stop() {
        if (this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
    }

    @Override
    public boolean isBusy() {
        return false;
    }

    @Override
    public boolean connectionAllowed(String eventName) {
        return this.m_listenee == null;
    }

    @Override
    public boolean connectionAllowed(EventSetDescriptor esd) {
        return this.connectionAllowed(esd.getName());
    }

    @Override
    public synchronized void connectionNotification(String eventName, Object source) {
        if (this.connectionAllowed(eventName)) {
            this.m_listenee = source;
        }
    }

    @Override
    public synchronized void disconnectionNotification(String eventName, Object source) {
        if (this.m_listenee == source) {
            this.m_listenee = null;
            this.m_format = null;
        }
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        if (this.m_listenee == null) {
            return false;
        }
        if (this.m_listenee instanceof EventConstraints) {
            if (eventName.equals("instance") && !((EventConstraints)this.m_listenee).eventGeneratable("incrementalClassifier")) {
                return false;
            }
            if (eventName.equals("dataSet") || eventName.equals("trainingSet") || eventName.equals("testSet")) {
                if (((EventConstraints)this.m_listenee).eventGeneratable("batchClassifier")) {
                    return true;
                }
                return ((EventConstraints)this.m_listenee).eventGeneratable("batchClusterer");
            }
        }
        return true;
    }

    private String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|";
    }
}

