/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.awt.Color;
import java.io.Serializable;
import weka.core.FastVector;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Add;

public class PlotData2D
implements Serializable {
    private static final long serialVersionUID = -3979972167982697979L;
    protected Instances m_plotInstances = null;
    protected String m_plotName = "new plot";
    protected String m_plotNameHTML = null;
    public boolean m_useCustomColour = false;
    public Color m_customColour = null;
    public boolean m_displayAllPoints = false;
    public int m_alwaysDisplayPointsOfThisSize = -1;
    protected double[][] m_pointLookup;
    protected int[] m_shapeSize;
    protected int[] m_shapeType;
    protected boolean[] m_connectPoints;
    private int m_xIndex;
    private int m_yIndex;
    private int m_cIndex;
    protected double m_maxX;
    protected double m_minX;
    protected double m_maxY;
    protected double m_minY;
    protected double m_maxC;
    protected double m_minC;

    public PlotData2D(Instances insts) {
        this.m_plotInstances = insts;
        this.m_cIndex = 0;
        this.m_yIndex = 0;
        this.m_xIndex = 0;
        this.m_pointLookup = new double[this.m_plotInstances.numInstances()][4];
        this.m_shapeSize = new int[this.m_plotInstances.numInstances()];
        this.m_shapeType = new int[this.m_plotInstances.numInstances()];
        this.m_connectPoints = new boolean[this.m_plotInstances.numInstances()];
        for (int i = 0; i < this.m_plotInstances.numInstances(); ++i) {
            this.m_shapeSize[i] = 2;
            this.m_shapeType[i] = -1;
        }
        this.determineBounds();
    }

    public void addInstanceNumberAttribute() {
        String originalRelationName = this.m_plotInstances.relationName();
        int originalClassIndex = this.m_plotInstances.classIndex();
        try {
            Add addF = new Add();
            addF.setAttributeName("Instance_number");
            addF.setAttributeIndex("first");
            addF.setInputFormat(this.m_plotInstances);
            this.m_plotInstances = Filter.useFilter(this.m_plotInstances, addF);
            this.m_plotInstances.setClassIndex(originalClassIndex + 1);
            for (int i = 0; i < this.m_plotInstances.numInstances(); ++i) {
                this.m_plotInstances.instance(i).setValue(0, (double)i);
            }
            this.m_plotInstances.setRelationName(originalRelationName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Instances getPlotInstances() {
        return new Instances(this.m_plotInstances);
    }

    public void setPlotName(String name) {
        this.m_plotName = name;
    }

    public String getPlotName() {
        return this.m_plotName;
    }

    public void setPlotNameHTML(String name) {
        this.m_plotNameHTML = name;
    }

    public String getPlotNameHTML() {
        if (this.m_plotNameHTML == null) {
            return this.m_plotName;
        }
        return this.m_plotNameHTML;
    }

    public void setShapeType(int[] st) throws Exception {
        this.m_shapeType = st;
        if (this.m_shapeType.length != this.m_plotInstances.numInstances()) {
            throw new Exception("PlotData2D: Shape type array must have the same number of entries as number of data points!");
        }
    }

    public int[] getShapeType() {
        return this.m_shapeType;
    }

    public void setShapeType(FastVector st) throws Exception {
        if (st.size() != this.m_plotInstances.numInstances()) {
            throw new Exception("PlotData2D: Shape type vector must have the same number of entries as number of data points!");
        }
        this.m_shapeType = new int[st.size()];
        for (int i = 0; i < st.size(); ++i) {
            this.m_shapeType[i] = (Integer)st.elementAt(i);
        }
    }

    public void setShapeSize(int[] ss) throws Exception {
        this.m_shapeSize = ss;
        if (this.m_shapeType.length != this.m_plotInstances.numInstances()) {
            throw new Exception("PlotData2D: Shape size array must have the same number of entries as number of data points!");
        }
    }

    public int[] getShapeSize() {
        return this.m_shapeSize;
    }

    public void setShapeSize(FastVector ss) throws Exception {
        if (ss.size() != this.m_plotInstances.numInstances()) {
            throw new Exception("PlotData2D: Shape size vector must have the same number of entries as number of data points!");
        }
        this.m_shapeSize = new int[ss.size()];
        for (int i = 0; i < ss.size(); ++i) {
            this.m_shapeSize[i] = (Integer)ss.elementAt(i);
        }
    }

    public void setConnectPoints(boolean[] cp) throws Exception {
        this.m_connectPoints = cp;
        if (this.m_connectPoints.length != this.m_plotInstances.numInstances()) {
            throw new Exception("PlotData2D: connect points array must have the same number of entries as number of data points!");
        }
        this.m_connectPoints[0] = false;
    }

    public void setConnectPoints(FastVector cp) throws Exception {
        if (cp.size() != this.m_plotInstances.numInstances()) {
            throw new Exception("PlotData2D: connect points array must have the same number of entries as number of data points!");
        }
        this.m_shapeSize = new int[cp.size()];
        for (int i = 0; i < cp.size(); ++i) {
            this.m_connectPoints[i] = (Boolean)cp.elementAt(i);
        }
        this.m_connectPoints[0] = false;
    }

    public void setCustomColour(Color c) {
        this.m_customColour = c;
        this.m_useCustomColour = c != null;
    }

    public void setXindex(int x) {
        this.m_xIndex = x;
        this.determineBounds();
    }

    public void setYindex(int y) {
        this.m_yIndex = y;
        this.determineBounds();
    }

    public void setCindex(int c) {
        this.m_cIndex = c;
        this.determineBounds();
    }

    public int getXindex() {
        return this.m_xIndex;
    }

    public int getYindex() {
        return this.m_yIndex;
    }

    public int getCindex() {
        return this.m_cIndex;
    }

    private void determineBounds() {
        if (this.m_plotInstances != null && this.m_plotInstances.numAttributes() > 0 && this.m_plotInstances.numInstances() > 0) {
            double value;
            int i;
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            if (this.m_plotInstances.attribute(this.m_xIndex).isNominal()) {
                this.m_minX = 0.0;
                this.m_maxX = this.m_plotInstances.attribute(this.m_xIndex).numValues() - 1;
            } else {
                for (i = 0; i < this.m_plotInstances.numInstances(); ++i) {
                    if (this.m_plotInstances.instance(i).isMissing(this.m_xIndex)) continue;
                    value = this.m_plotInstances.instance(i).value(this.m_xIndex);
                    if (value < min) {
                        min = value;
                    }
                    if (!(value > max)) continue;
                    max = value;
                }
                if (min == Double.POSITIVE_INFINITY) {
                    max = 0.0;
                    min = 0.0;
                }
                this.m_minX = min;
                this.m_maxX = max;
                if (min == max) {
                    this.m_maxX += 0.05;
                    this.m_minX -= 0.05;
                }
            }
            min = Double.POSITIVE_INFINITY;
            max = Double.NEGATIVE_INFINITY;
            if (this.m_plotInstances.attribute(this.m_yIndex).isNominal()) {
                this.m_minY = 0.0;
                this.m_maxY = this.m_plotInstances.attribute(this.m_yIndex).numValues() - 1;
            } else {
                for (i = 0; i < this.m_plotInstances.numInstances(); ++i) {
                    if (this.m_plotInstances.instance(i).isMissing(this.m_yIndex)) continue;
                    value = this.m_plotInstances.instance(i).value(this.m_yIndex);
                    if (value < min) {
                        min = value;
                    }
                    if (!(value > max)) continue;
                    max = value;
                }
                if (min == Double.POSITIVE_INFINITY) {
                    max = 0.0;
                    min = 0.0;
                }
                this.m_minY = min;
                this.m_maxY = max;
                if (min == max) {
                    this.m_maxY += 0.05;
                    this.m_minY -= 0.05;
                }
            }
            min = Double.POSITIVE_INFINITY;
            max = Double.NEGATIVE_INFINITY;
            for (i = 0; i < this.m_plotInstances.numInstances(); ++i) {
                if (this.m_plotInstances.instance(i).isMissing(this.m_cIndex)) continue;
                value = this.m_plotInstances.instance(i).value(this.m_cIndex);
                if (value < min) {
                    min = value;
                }
                if (!(value > max)) continue;
                max = value;
            }
            if (min == Double.POSITIVE_INFINITY) {
                max = 0.0;
                min = 0.0;
            }
            this.m_minC = min;
            this.m_maxC = max;
        }
    }
}

