/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractInPlaceSpreadSheetConversion;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;

public class RenameSpreadSheetColumn
extends AbstractInPlaceSpreadSheetConversion {
    private static final long serialVersionUID = -5364554292793461868L;
    protected SpreadSheetColumnIndex m_Column;
    protected String m_NewName;

    public String globalInfo() {
        return "Renames a single column in a spreadsheet.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("column", "column", (Object)new SpreadSheetColumnIndex("first"));
        this.m_OptionManager.add("new-name", "newName", (Object)"Blah");
    }

    public void setColumn(SpreadSheetColumnIndex value) {
        this.m_Column = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColumn() {
        return this.m_Column;
    }

    public String columnTipText() {
        return "The index of the column to rename; " + this.m_Column.getExample();
    }

    public void setNewName(String value) {
        this.m_NewName = value;
        this.reset();
    }

    public String getNewName() {
        return this.m_NewName;
    }

    public String newNameTipText() {
        return "The new name of the column.";
    }

    @Override
    protected SpreadSheet convert(SpreadSheet input) throws Exception {
        SpreadSheet result = this.m_NoCopy ? input : input.getClone();
        this.m_Column.setSpreadSheet(input);
        int index = this.m_Column.getIntIndex();
        if (index == -1) {
            throw new IllegalStateException("Not a valid column index: " + this.m_Column.getIndex());
        }
        result.getHeaderRow().getCell(index).setContent(this.m_NewName);
        return result;
    }
}

