/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.data.io.input.AbstractMultiSheetSpreadSheetReaderWithMissingValueSupport;
import adams.data.io.input.AbstractSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GnumericSpreadSheetReader
extends AbstractMultiSheetSpreadSheetReaderWithMissingValueSupport {
    private static final long serialVersionUID = -2259236765510690348L;
    public static final String VERSION = "1.10.13";
    protected boolean m_UncompressedOutput;

    public String globalInfo() {
        return "Reads Gnumeric workbook files (GZIP compressed or uncompressed XML), version 1.10.13.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("uncompressed", "uncompressedOutput", (Object)false);
    }

    public void setUncompressedOutput(boolean value) {
        this.m_UncompressedOutput = value;
        this.reset();
    }

    public boolean getUncompressedOutput() {
        return this.m_UncompressedOutput;
    }

    public String uncompressedOutputTipText() {
        return "If enabled, file is assumed to be uncompressed XML rather than GZIP compressed.";
    }

    public String getFormatDescription() {
        return "Gnumeric (XML files)";
    }

    public String[] getFormatExtensions() {
        return new String[]{"gnumeric"};
    }

    protected AbstractSpreadSheetReader.InputType getInputType() {
        return AbstractSpreadSheetReader.InputType.STREAM;
    }

    @Override
    protected List<SpreadSheet> doReadRange(InputStream in) {
        ArrayList<SpreadSheet> result = new ArrayList<SpreadSheet>();
        try {
            if (!this.m_UncompressedOutput) {
                in = new GZIPInputStream(in);
            }
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(in);
            doc.getDocumentElement().normalize();
            NodeList sheetList = doc.getElementsByTagName("gnm:Sheet");
            this.m_SheetRange.setMax(sheetList.getLength());
            int[] indices = this.m_SheetRange.getIntIndices();
            for (int i = 0; i < indices.length; ++i) {
                Object row;
                Node node;
                int n;
                SpreadSheet sheet = new SpreadSheet();
                sheet.setDataRowClass(this.m_DataRowType.getRowClass());
                result.add(sheet);
                Node sheetNode = sheetList.item(indices[i]);
                String name = "Sheet" + (indices[i] + 1);
                int rows = -1;
                int cols = -1;
                for (n = 0; n < sheetNode.getChildNodes().getLength(); ++n) {
                    node = sheetNode.getChildNodes().item(n);
                    String nname = node.getNodeName();
                    if ("gnm:Name".equals(nname) || "Name".equals(nname)) {
                        name = node.getTextContent();
                        continue;
                    }
                    if ("gnm:MaxRow".equals(nname) || "MaxRow".equals(nname)) {
                        rows = Integer.parseInt(node.getTextContent());
                        continue;
                    }
                    if (!"gnm:MaxCol".equals(nname) && !"MaxCol".equals(nname)) continue;
                    cols = Integer.parseInt(node.getTextContent());
                }
                sheet.setName(name);
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Sheet: " + name);
                    this.getLogger().info("Rows: " + rows);
                    this.getLogger().info("Cols: " + cols);
                }
                if (cols != -1) {
                    row = sheet.getHeaderRow();
                    for (n = 0; n < cols; ++n) {
                        row.addCell("" + n).setContent("Col" + (n + 1));
                    }
                }
                if (rows != -1) {
                    for (n = 0; n < rows; ++n) {
                        sheet.addRow();
                    }
                }
                NodeList cellList = ((Element)sheetNode).getElementsByTagName("gnm:Cell");
                for (n = 0; n < cellList.getLength(); ++n) {
                    Node cellNode = cellList.item(n);
                    String type = "60";
                    int cellCol = -1;
                    int cellRow = -1;
                    String content = cellNode.getTextContent();
                    node = cellNode.getAttributes().getNamedItem("ValueType");
                    if (node == null) {
                        node = cellNode.getAttributes().getNamedItem("gnm:ValueType");
                    }
                    if (node != null) {
                        type = node.getTextContent();
                    }
                    if ((node = cellNode.getAttributes().getNamedItem("Col")) == null) {
                        node = cellNode.getAttributes().getNamedItem("gnm:Col");
                    }
                    if (node != null) {
                        cellCol = Integer.parseInt(node.getTextContent());
                    }
                    if ((node = cellNode.getAttributes().getNamedItem("Row")) == null) {
                        node = cellNode.getAttributes().getNamedItem("gnm:Row");
                    }
                    if (node != null) {
                        cellRow = Integer.parseInt(node.getTextContent());
                    }
                    if (cellCol == -1 || cellRow == -1) continue;
                    while (sheet.getColumnCount() <= cellCol) {
                        sheet.getHeaderRow().addCell("" + sheet.getColumnCount()).setContent("Col" + sheet.getColumnCount());
                    }
                    while (sheet.getRowCount() < cellRow) {
                        sheet.addRow();
                    }
                    row = cellRow == 0 ? sheet.getHeaderRow() : sheet.getRow(cellRow - 1);
                    if (content.equals(this.m_MissingValue)) {
                        content = null;
                    }
                    if (content == null) {
                        row.addCell(cellCol).setMissing();
                    } else if (type.equals("40") && content.length() > 0) {
                        row.addCell(cellCol).setContent(Double.valueOf(Double.parseDouble(content)));
                    } else {
                        row.addCell(cellCol).setContent(content);
                    }
                    if (!this.isLoggingEnabled()) continue;
                    this.getLogger().info(SpreadSheet.getCellPosition((int)cellRow, (int)cellCol) + ": " + content);
                }
            }
        }
        catch (Exception e) {
            result = null;
            this.getLogger().log(Level.SEVERE, "Failed to read data!", e);
        }
        return result;
    }
}

