/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowfinder;

import adams.core.DateUtils;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.DateFormatString;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.rowfinder.AbstractRowFinder;
import gnu.trove.list.array.TIntArrayList;
import java.util.Date;

public class ByDateValue
extends AbstractRowFinder {
    private static final long serialVersionUID = 235661615457187608L;
    protected SpreadSheetColumnIndex m_AttributeIndex;
    protected DateFormatString m_Format;
    protected String m_Minimum;
    protected boolean m_MinimumIncluded;
    protected String m_Maximum;
    protected boolean m_MaximumIncluded;
    protected Date m_DateMin;
    protected Date m_DateMax;

    public String globalInfo() {
        return "Returns the indices of rows of columns which date/time values fall inside the minimum and maximum.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("att-index", "attributeIndex", (Object)new SpreadSheetColumnIndex("last"));
        this.m_OptionManager.add("format", "format", (Object)new DateFormatString("yyyy-MM-dd"));
        this.m_OptionManager.add("minimum", "minimum", (Object)"-INF");
        this.m_OptionManager.add("minimum-included", "minimumIncluded", (Object)false);
        this.m_OptionManager.add("maximum", "maximum", (Object)"+INF");
        this.m_OptionManager.add("maximum-included", "maximumIncluded", (Object)false);
    }

    protected void reset() {
        super.reset();
        this.m_DateMin = null;
        this.m_DateMax = null;
    }

    public void setAttributeIndex(SpreadSheetColumnIndex value) {
        this.m_AttributeIndex = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getAttributeIndex() {
        return this.m_AttributeIndex;
    }

    public String attributeIndexTipText() {
        return "The index of the column to use for matching; " + this.m_AttributeIndex.getExample();
    }

    public void setFormat(DateFormatString value) {
        this.m_Format = value;
        this.reset();
    }

    public DateFormatString getFormat() {
        return this.m_Format;
    }

    public String formatTipText() {
        return "The format string to use for parsing minimum and maximum.";
    }

    public void setMinimum(String value) {
        this.m_Minimum = value;
        this.reset();
    }

    public String getMinimum() {
        return this.m_Minimum;
    }

    public String minimumTipText() {
        return "The minimum value that the values must satisfy; use -INF to ignore.";
    }

    public void setMinimumIncluded(boolean value) {
        this.m_MinimumIncluded = value;
        this.reset();
    }

    public boolean getMinimumIncluded() {
        return this.m_MinimumIncluded;
    }

    public String minimumIncludedTipText() {
        return "If enabled, then the minimum value gets included (testing '<=' rather than '<').";
    }

    public void setMaximum(String value) {
        this.m_Maximum = value;
        this.reset();
    }

    public String getMaximum() {
        return this.m_Maximum;
    }

    public String maximumTipText() {
        return "The maximum value that the values must satisfy; use +INF to ignore.";
    }

    public void setMaximumIncluded(boolean value) {
        this.m_MaximumIncluded = value;
        this.reset();
    }

    public boolean getMaximumIncluded() {
        return this.m_MaximumIncluded;
    }

    public String maximumIncludedTipText() {
        return "If enabled, then the maximum value gets included (testing '>=' rather than '>').";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"attributeIndex", (Object)((Object)this.m_AttributeIndex), (String)"col: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"format", (Object)this.m_Format, (String)", format: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"minimum", (Object)this.m_Minimum, (String)", min: ");
        result = result + " [" + QuickInfoHelper.toString((OptionHandler)this, (String)"minimumIncluded", (Object)(this.m_MinimumIncluded ? "incl" : "excl")) + "]";
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"maximum", (Object)this.m_Maximum, (String)", max: ");
        result = result + " [" + QuickInfoHelper.toString((OptionHandler)this, (String)"maximumIncluded", (Object)(this.m_MaximumIncluded ? "incl" : "excl")) + "]";
        return result;
    }

    @Override
    protected int[] doFindRows(SpreadSheet data) {
        boolean useMax;
        TIntArrayList result = new TIntArrayList();
        this.m_AttributeIndex.setSpreadSheet(data);
        int index = this.m_AttributeIndex.getIntIndex();
        if (index == -1) {
            throw new IllegalStateException("Invalid index '" + this.m_AttributeIndex.getIndex() + "'?");
        }
        boolean useMin = !this.m_Minimum.equals("-INF");
        boolean bl = useMax = !this.m_Maximum.equals("+INF");
        if (useMin && this.m_DateMin == null) {
            this.m_DateMin = this.m_Format.toDateFormat().parse(this.m_Minimum);
            if (this.m_DateMin == null) {
                throw new IllegalStateException("Failed to parse minimum '" + this.m_Minimum + "' with '" + this.m_Format + "'!");
            }
        }
        if (useMax && this.m_DateMax == null) {
            this.m_DateMax = this.m_Format.toDateFormat().parse(this.m_Maximum);
            if (this.m_DateMax == null) {
                throw new IllegalStateException("Failed to parse maximum '" + this.m_Maximum + "' with '" + this.m_Format + "'!");
            }
        }
        for (int i = 0; i < data.getRowCount(); ++i) {
            Date value;
            Cell cell;
            DataRow row = data.getRow(i);
            if (!row.hasCell(index) || (cell = row.getCell(index)).isMissing() || !cell.isAnyDateType() || (value = cell.toAnyDateType()) == null) continue;
            boolean add = true;
            if (useMin) {
                if (this.m_MinimumIncluded) {
                    if (DateUtils.isBefore((Date)this.m_DateMin, (Date)value)) {
                        add = false;
                    }
                } else if (DateUtils.isBefore((Date)this.m_DateMin, (Date)value) || this.m_DateMin.equals(value)) {
                    add = false;
                }
            }
            if (useMax) {
                if (this.m_MaximumIncluded) {
                    if (DateUtils.isAfter((Date)this.m_DateMax, (Date)value)) {
                        add = false;
                    }
                } else if (DateUtils.isAfter((Date)this.m_DateMax, (Date)value) || this.m_DateMax.equals(value)) {
                    add = false;
                }
            }
            if (!add) continue;
            result.add(i);
        }
        return result.toArray();
    }
}

