/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.ColumnNameConversion;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SqlUtils;
import adams.db.AbstractDatabaseConnection;
import adams.db.SQL;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.sink.AbstractSink;
import adams.flow.standalone.DatabaseConnection;

public class SpreadSheetDbWriter
extends AbstractSink {
    private static final long serialVersionUID = 393925191813730213L;
    protected AbstractDatabaseConnection m_DatabaseConnection;
    protected String m_Table;
    protected Cell.ContentType[] m_Types;
    protected int m_MaxColumnLength;
    protected String[] m_ColumnNames;
    protected ColumnNameConversion m_ColumnNameConversion;
    protected String m_StringColumnSQL;
    protected int m_MaxStringLength;

    public String globalInfo() {
        return "Transfers a SpreadSheet object into a database.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("table", "table", (Object)"blah");
        this.m_OptionManager.add("column-name-conversion", "columnNameConversion", (Object)ColumnNameConversion.UPPER_CASE);
        this.m_OptionManager.add("max-string-length", "maxStringLength", (Object)50, (Number)1, null);
        this.m_OptionManager.add("string-column-sql", "stringColumnSQL", (Object)"VARCHAR(@MAX)");
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"table", (Object)this.m_Table, (String)"table: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"columnNameConversion", (Object)((Object)this.m_ColumnNameConversion), (String)", conversion: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"maxStringLength", (Object)this.m_MaxStringLength, (String)", max string: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"stringColumnSQL", (Object)this.m_StringColumnSQL, (String)", string type: ");
        return result;
    }

    public void setTable(String value) {
        this.m_Table = value;
        this.reset();
    }

    public String getTable() {
        return this.m_Table;
    }

    public String tableTipText() {
        return "The table to write the data to (gets automatically created).";
    }

    public void setColumnNameConversion(ColumnNameConversion value) {
        this.m_ColumnNameConversion = value;
        this.reset();
    }

    public ColumnNameConversion getColumnNameConversion() {
        return this.m_ColumnNameConversion;
    }

    public String columnNameConversionTipText() {
        return "How to convert the column headers into SQL table column names.";
    }

    public void setMaxStringLength(int value) {
        this.m_MaxStringLength = value;
        this.reset();
    }

    public int getMaxStringLength() {
        return this.m_MaxStringLength;
    }

    public String maxStringLengthTipText() {
        return "The maximum length for strings to enforce; can be used as @MAX in the 'stringColumnsSQL' property.";
    }

    public void setStringColumnSQL(String value) {
        this.m_StringColumnSQL = value;
        this.reset();
    }

    public String getStringColumnSQL() {
        return this.m_StringColumnSQL;
    }

    public String stringColumnSQLTipText() {
        return "The SQL type to use for STRING columns in the CREATE statement; you can use the @MAX placeholder to tie the type to the 'naxStringLength' property; see also: http://en.wikipedia.org/wiki/SQL";
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    protected AbstractDatabaseConnection getDatabaseConnection() {
        return ActorUtils.getDatabaseConnection((AbstractActor)this, DatabaseConnection.class, (AbstractDatabaseConnection)adams.db.DatabaseConnection.getSingleton());
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_DatabaseConnection = this.getDatabaseConnection();
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        SQL sql = new SQL(this.m_DatabaseConnection);
        SqlUtils.Writer writer = null;
        try {
            writer = new SqlUtils.Writer(sheet, this.m_Table, sql.getMaxColumnNameLength(), this.m_ColumnNameConversion, this.m_StringColumnSQL, this.m_MaxStringLength);
        }
        catch (Exception e) {
            writer = null;
            result = this.handleException("Failed to determine max column name length", e);
        }
        if (writer != null) {
            if (!sql.tableExists(this.m_Table)) {
                result = writer.createTable(sql);
            }
            if (result == null) {
                result = writer.writeData(sql);
            }
        }
        return result;
    }

    public void wrapUp() {
        this.m_DatabaseConnection = null;
        super.wrapUp();
    }
}

