/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractSpreadSheetTransformer;
import java.util.Hashtable;

public class SpreadSheetSubsetByValue
extends AbstractSpreadSheetTransformer {
    private static final long serialVersionUID = -253714973019682939L;
    public static final String BACKUP_SORTED = "sorted";
    public static final String BACKUP_ROWINDEX = "row index";
    public static final String BACKUP_COLINDEX = "col index";
    protected SpreadSheetColumnIndex m_Column;
    protected SpreadSheet m_Sorted;
    protected int m_RowIndex;
    protected int m_ColIndex;

    public String globalInfo() {
        return "Generates subsets from a spreadsheet, grouped by the same string value in the specified column.\nFor instance, if a spreadsheet has 3 unique values (A, B, C) in column 2, then 3 subsheets will generated, each containing the rows that have the value A, B or C.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("col", "column", (Object)new SpreadSheetColumnIndex("first"));
    }

    protected void initialize() {
        super.initialize();
        this.m_Column = new SpreadSheetColumnIndex();
    }

    protected void reset() {
        super.reset();
        this.m_Sorted = null;
        this.m_RowIndex = -1;
        this.m_ColIndex = -1;
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"column", (Object)((Object)this.m_Column), (String)"col: ");
    }

    public void setColumn(SpreadSheetColumnIndex value) {
        this.m_Column = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColumn() {
        return this.m_Column;
    }

    public String columnTipText() {
        return "The column which unique string values identify the subsets; " + this.m_Column.getExample();
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_SORTED);
        this.pruneBackup(BACKUP_ROWINDEX);
        this.pruneBackup(BACKUP_COLINDEX);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_Sorted != null) {
            result.put(BACKUP_SORTED, this.m_Sorted);
        }
        if (this.m_RowIndex != -1) {
            result.put(BACKUP_ROWINDEX, this.m_RowIndex);
        }
        if (this.m_ColIndex != -1) {
            result.put(BACKUP_COLINDEX, this.m_ColIndex);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_SORTED)) {
            this.m_Sorted = (SpreadSheet)state.get(BACKUP_SORTED);
            state.remove(BACKUP_SORTED);
        }
        if (state.containsKey(BACKUP_ROWINDEX)) {
            this.m_RowIndex = (Integer)state.get(BACKUP_ROWINDEX);
            state.remove(BACKUP_ROWINDEX);
        }
        if (state.containsKey(BACKUP_COLINDEX)) {
            this.m_ColIndex = (Integer)state.get(BACKUP_COLINDEX);
            state.remove(BACKUP_COLINDEX);
        }
        super.restoreState(state);
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        this.m_Column.setSpreadSheet(sheet);
        this.m_ColIndex = this.m_Column.getIntIndex();
        if (this.m_ColIndex == -1) {
            result = "No column selected!";
        } else {
            this.m_Sorted = sheet.getClone();
            this.m_Sorted.sort(this.m_ColIndex, true);
            this.m_RowIndex = 0;
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_Sorted != null;
    }

    protected String getCellValue(Row row, int col) {
        if (!row.hasCell(col) || row.getCell(col).isMissing()) {
            return null;
        }
        return row.getCell(col).getContent();
    }

    public Token output() {
        Token result = null;
        String current = "";
        String old = "";
        SpreadSheet sheet = null;
        boolean finished = false;
        boolean first = true;
        do {
            DataRow row;
            if ((old = current).equals(current = this.getCellValue((Row)(row = this.m_Sorted.getRow(this.m_RowIndex)), this.m_ColIndex)) || first) {
                if (sheet == null) {
                    sheet = this.m_Sorted.getHeader();
                    first = false;
                }
                sheet.addRow().assign((Row)row);
                ++this.m_RowIndex;
                continue;
            }
            finished = true;
        } while (!finished && !this.m_Stopped && this.m_RowIndex < this.m_Sorted.getRowCount());
        if (sheet != null) {
            result = new Token((Object)sheet);
        }
        if (this.m_RowIndex == this.m_Sorted.getRowCount()) {
            this.m_Sorted = null;
        }
        return result;
    }
}

