/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer.chart;

import adams.core.NamedCounter;
import adams.core.QuickInfoSupporter;
import adams.core.logging.LoggingHelper;
import adams.core.option.AbstractOption;
import adams.core.option.AbstractOptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.rowfinder.ByIndex;
import adams.data.spreadsheet.rowfinder.RowFinder;
import adams.flow.control.Flow;
import adams.flow.control.StorageName;
import adams.flow.core.AbstractActor;
import adams.flow.source.StorageValue;
import adams.flow.transformer.SpreadSheetRowFilter;
import adams.gui.visualization.core.axis.FancyTickGenerator;
import adams.gui.visualization.core.axis.SimpleFixedLabelTickGenerator;
import adams.gui.visualization.core.axis.TickGenerator;
import adams.gui.visualization.core.axis.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;

public abstract class AbstractChartGenerator
extends AbstractOptionHandler
implements QuickInfoSupporter {
    private static final long serialVersionUID = -177068671614931447L;
    public static final String STORAGE_NAME = "sheet";
    protected int m_Width;
    protected int m_Height;
    protected RowFinder m_RowFinder;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("width", "width", (Object)this.getDefaultWidth(), (Number)-1, null);
        this.m_OptionManager.add("height", "height", (Object)this.getDefaultHeight(), (Number)-1, null);
        this.m_OptionManager.add("row-finder", "rowFinder", (Object)new ByIndex());
    }

    protected int getDefaultWidth() {
        return 800;
    }

    public void setWidth(int value) {
        this.m_Width = value;
        this.reset();
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the chart dialog.";
    }

    protected int getDefaultHeight() {
        return 600;
    }

    public void setHeight(int value) {
        this.m_Height = value;
        this.reset();
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the chart dialog.";
    }

    public void setRowFinder(RowFinder value) {
        this.m_RowFinder = value;
        this.reset();
    }

    public RowFinder getRowFinder() {
        return this.m_RowFinder;
    }

    public String rowFinderTipText() {
        return "The row finder to use for restricting the rows used for the chart.";
    }

    public String getQuickInfo() {
        return null;
    }

    protected Type columnTypeToAxisType(SpreadSheet sheet, int colIndex) {
        Type result = Type.ABSOLUTE;
        if (colIndex < 0 || colIndex >= sheet.getColumnCount()) {
            return result;
        }
        Collection types = sheet.getContentTypes(colIndex);
        types.remove(Cell.ContentType.MISSING);
        Cell.ContentType type = Cell.ContentType.STRING;
        if (types.size() == 1) {
            type = (Cell.ContentType)types.iterator().next();
        } else if (types.size() == 2 && types.contains(Cell.ContentType.LONG) && types.contains(Cell.ContentType.DOUBLE)) {
            type = Cell.ContentType.DOUBLE;
        }
        switch (type) {
            case DOUBLE: 
            case LONG: {
                result = Type.ABSOLUTE;
                break;
            }
            case DATE: {
                result = Type.DATE;
                break;
            }
            case TIME: {
                result = Type.TIME;
                break;
            }
            case DATETIME: {
                result = Type.DATETIME;
                break;
            }
            default: {
                result = Type.ABSOLUTE;
            }
        }
        return result;
    }

    protected Type columnTypesToAxisType(SpreadSheet sheet, int[] colIndices) {
        Type result = Type.ABSOLUTE;
        NamedCounter counter = new NamedCounter();
        for (int index : colIndices) {
            counter.next(this.columnTypeToAxisType(sheet, index).toRaw());
        }
        Iterator types = counter.names(false);
        if (types.hasNext()) {
            result = Type.valueOf((AbstractOption)null, (String)((String)types.next()));
        }
        return result;
    }

    protected TickGenerator columnTypeToTickGenerator(SpreadSheet sheet, int colIndex) {
        FancyTickGenerator result = new FancyTickGenerator();
        if (colIndex < 0 || colIndex >= sheet.getColumnCount()) {
            return result;
        }
        Collection types = sheet.getContentTypes(colIndex);
        types.remove(Cell.ContentType.MISSING);
        Cell.ContentType type = Cell.ContentType.STRING;
        if (types.size() == 1) {
            type = (Cell.ContentType)types.iterator().next();
        } else if (types.size() == 2 && types.contains(Cell.ContentType.LONG) && types.contains(Cell.ContentType.DOUBLE)) {
            type = Cell.ContentType.DOUBLE;
        }
        switch (type) {
            case OBJECT: 
            case STRING: {
                result = new SimpleFixedLabelTickGenerator();
                break;
            }
            default: {
                result = new FancyTickGenerator();
            }
        }
        return result;
    }

    protected TickGenerator columnTypesToTickGenerator(SpreadSheet sheet, int[] colIndices) {
        FancyTickGenerator result = new FancyTickGenerator();
        NamedCounter counter = new NamedCounter();
        for (int index : colIndices) {
            counter.next(this.columnTypeToTickGenerator(sheet, index).getClass().getName());
        }
        Iterator types = counter.names(false);
        if (types.hasNext()) {
            try {
                result = (TickGenerator)Class.forName((String)types.next()).newInstance();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    protected void check(String name, SpreadSheet sheet) {
        if (sheet == null) {
            throw new IllegalArgumentException("No spreadsheet supplied!");
        }
    }

    protected abstract void addChartGeneration(Flow var1, String var2, SpreadSheet var3);

    protected Flow doGenerate(String name, SpreadSheet sheet) {
        Flow result = new Flow();
        if (sheet.getName() != null) {
            result.setName(sheet.getName());
        }
        StorageValue sv = new StorageValue();
        sv.setStorageName(new StorageName(STORAGE_NAME));
        result.add((AbstractActor)sv);
        SpreadSheetRowFilter rf = new SpreadSheetRowFilter();
        rf.setFinder(this.m_RowFinder);
        result.add((AbstractActor)rf);
        this.addChartGeneration(result, name, sheet);
        result.getStorage().put(new StorageName(STORAGE_NAME), (Object)sheet);
        if (LoggingHelper.isAtLeast((Level)this.getLoggingLevel().getLevel(), (Level)Level.FINE)) {
            this.getLogger().fine(result.toCommandLine());
        }
        return result;
    }

    public Flow generate(String name, SpreadSheet sheet) {
        this.check(name, sheet);
        return this.doGenerate(name, sheet);
    }
}

