/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.JPod;
import adams.core.io.PlaceholderFile;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;

public class PDFPageCount
extends AbstractTransformer {
    private static final long serialVersionUID = -5712406930007899590L;

    public String globalInfo() {
        return "Actor for extracting the page count from a PDF file.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{Integer.class};
    }

    protected String doExecute() {
        int count;
        String result = null;
        File file = this.m_InputToken.getPayload() instanceof File ? (File)this.m_InputToken.getPayload() : new PlaceholderFile((String)this.m_InputToken.getPayload());
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Determining page count of '" + file + "'");
        }
        if ((count = JPod.getPageCount(file)) == -1) {
            result = "Failed to determine page count of '" + file + "'!";
        } else {
            this.m_OutputToken = new Token((Object)count);
        }
        return result;
    }
}

