/*
 * Decompiled with CFR 0.152.
 */
package adams.data.heatmap;

import adams.core.Utils;
import adams.data.Notes;
import adams.data.NotesHandler;
import adams.data.container.DataContainer;
import adams.data.container.DataPointComparator;
import adams.data.heatmap.HeatmapStatistic;
import adams.data.heatmap.HeatmapValue;
import adams.data.id.MutableIDHandler;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.MutableReportHandler;
import adams.data.report.Report;
import adams.data.statistics.InformativeStatisticSupporter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class Heatmap
implements Serializable,
MutableIDHandler,
MutableReportHandler<Report>,
NotesHandler,
DataContainer<HeatmapValue>,
InformativeStatisticSupporter<HeatmapStatistic> {
    private static final long serialVersionUID = 2380816899974969042L;
    public static final String FIELD_FILENAME = "Filename";
    public static final String FIELD_TIMESTAMP = "Timestamp";
    protected static DataPointComparator<HeatmapValue> m_Comparator;
    protected String m_ID = "";
    protected double[][] m_Map;
    protected Report m_Report = Heatmap.createEmptyReport();
    protected Notes m_Notes = new Notes();
    protected double m_Min;
    protected double m_Max;

    private Heatmap() {
        this.resetMinMax();
    }

    public Heatmap(int rows, int cols) {
        this();
        this.m_Map = new double[rows][cols];
    }

    public Heatmap(double[][] map) {
        this();
        this.m_Map = (double[][])map.clone();
        this.resetMinMax();
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                this.updateMinMax(this.m_Map[y][x]);
            }
        }
    }

    public void setID(String value) {
        this.m_ID = value;
    }

    public String getID() {
        return this.m_ID;
    }

    public void setReport(Report value) {
        this.m_Report = value;
    }

    public boolean hasReport() {
        return this.m_Report != null;
    }

    public Report getReport() {
        return this.m_Report;
    }

    protected void resetMinMax() {
        this.m_Min = Double.MAX_VALUE;
        this.m_Max = Double.MIN_VALUE;
    }

    protected void updateMinMax(double value) {
        if (value > 0.0) {
            this.m_Min = Math.min(this.m_Min, value);
            this.m_Max = Math.max(this.m_Max, value);
        }
    }

    public double getMin() {
        return this.m_Min;
    }

    public double getMax() {
        return this.m_Max;
    }

    public int getHeight() {
        return this.m_Map.length;
    }

    public int getWidth() {
        if (this.m_Map.length > 0) {
            return this.m_Map[0].length;
        }
        return 0;
    }

    public int size() {
        return this.getWidth() * this.getHeight();
    }

    public int getX(int pos) {
        int y = pos / this.getWidth();
        int x = pos - y * this.getWidth();
        return x;
    }

    public int getY(int pos) {
        return pos / this.getWidth();
    }

    public double get(int row, int col) {
        return this.m_Map[row][col];
    }

    public double get(int pos) {
        return this.get(this.getY(pos), this.getX(pos));
    }

    public void set(int row, int col, double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException("Value cannot be less than 0.0 (y=" + row + ", x=" + col + "): " + value);
        }
        this.updateMinMax(value);
        this.m_Map[row][col] = value;
    }

    public void set(int pos, double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException("Value cannot be less than 0.0 (pos=" + pos + "): " + value);
        }
        this.set(this.getY(pos), this.getX(pos), value);
    }

    public void set(double[] values) {
        if (values.length != this.size()) {
            throw new IllegalArgumentException("Length of array does not match heatmap size: " + values.length + " != " + this.size());
        }
        int index = 0;
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                this.set(y, x, values[index]);
                ++index;
            }
        }
    }

    public void set(Double[] values) {
        if (values.length != this.size()) {
            throw new IllegalArgumentException("Length of array does not match heatmap size: " + values.length + " != " + this.size());
        }
        int index = 0;
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                this.set(y, x, values[index]);
                ++index;
            }
        }
    }

    public Notes getNotes() {
        return this.m_Notes;
    }

    public Heatmap getClone() {
        Heatmap result = new Heatmap((double[][])this.m_Map.clone());
        result.setID(new String(this.getID()));
        result.setReport(this.getReport().getClone());
        result.m_Notes = this.getNotes().getClone();
        return result;
    }

    public String toString() {
        return "ID=" + this.m_ID + ", width=" + this.getWidth() + ", height=" + this.getHeight();
    }

    public HeatmapValue[] toArray() {
        HeatmapValue[] result = new HeatmapValue[this.size()];
        int index = 0;
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                result[index] = new HeatmapValue(y, x, this.get(y, x));
                result[index].setParent(this);
                ++index;
            }
        }
        return result;
    }

    public Double[] toDoubleArray() {
        Double[] result = new Double[this.size()];
        int index = 0;
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                result[index] = this.get(y, x);
                ++index;
            }
        }
        return result;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        int result = 0;
        if (!(o instanceof Heatmap)) {
            return -1;
        }
        Heatmap other = (Heatmap)o;
        result = new Integer(this.size()).compareTo(new Integer(other.size()));
        if (result == 0) {
            result = this.compareToHeader(o);
        }
        if (result == 0) {
            Iterator<HeatmapValue> iter = this.iterator();
            Iterator<HeatmapValue> iterOther = other.iterator();
            while (iter.hasNext() && result == 0) {
                result = iter.next().compareTo(iterOther.next());
            }
        }
        return result;
    }

    public int compareToHeader(Object o) {
        if (o == null) {
            return 1;
        }
        int result = 0;
        Heatmap c = (Heatmap)o;
        if (result == 0) {
            result = Utils.compare((Comparable)((Object)this.getID()), (Comparable)((Object)c.getID()));
        }
        if (result == 0) {
            result = Utils.compare((Comparable)this.getReport(), (Comparable)c.getReport());
        }
        return result;
    }

    public boolean equalsHeader(Object obj) {
        return this.compareToHeader(obj) == 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Heatmap) {
            return this.compareTo(obj) == 0;
        }
        return false;
    }

    public Iterator<HeatmapValue> iterator() {
        Iterator result = new Iterator(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < Heatmap.this.size();
            }

            public Object next() {
                int x = Heatmap.this.getX(this.index);
                int y = Heatmap.this.getY(this.index);
                HeatmapValue result = new HeatmapValue(y, x, Heatmap.this.get(y, x));
                ++this.index;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return result;
    }

    public void clear() {
        this.resetMinMax();
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                this.set(y, x, 0.0);
            }
        }
    }

    public boolean isEmpty() {
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                if (!(this.get(y, x) > 0.0)) continue;
                return false;
            }
        }
        return true;
    }

    public <HeatmapValue> HeatmapValue[] toArray(HeatmapValue[] a) {
        return this.toArray();
    }

    public boolean add(HeatmapValue e) {
        double old = this.get(e.getY(), e.getX());
        this.set(e.getY(), e.getX(), e.getValue());
        return old != e.getValue();
    }

    public boolean addAll(Collection<? extends HeatmapValue> c) {
        boolean result = false;
        for (HeatmapValue heatmapValue : c) {
            result = this.add(heatmapValue) || result;
        }
        return result;
    }

    public boolean remove(Object o) {
        HeatmapValue v = (HeatmapValue)o;
        double old = this.get(v.getY(), v.getX());
        this.set(v.getY(), v.getX(), 0.0);
        return old > 0.0;
    }

    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        Iterator<?> iter = c.iterator();
        while (iter.hasNext()) {
            result = this.remove(iter.next()) || result;
        }
        return result;
    }

    public boolean contains(Object o) {
        HeatmapValue v;
        boolean result = false;
        if (o instanceof HeatmapValue && (v = (HeatmapValue)o).getY() < this.getHeight() && v.getX() < this.getWidth()) {
            result = v.getValue() == this.get(v.getY(), v.getX());
        }
        return result;
    }

    public boolean containsAll(Collection<?> c) {
        boolean result = true;
        Iterator<?> iter = c.iterator();
        while (iter.hasNext() && (result = this.contains(iter.next()))) {
        }
        return result;
    }

    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public void mergeWith(DataContainer other) {
        for (HeatmapValue v : other) {
            if (v.getY() >= this.getHeight() || v.getX() >= this.getWidth() || this.get(v.getY(), v.getX()) != 0.0) continue;
            this.set(v.getY(), v.getX(), v.getValue());
        }
    }

    public DataPointComparator<HeatmapValue> newComparator() {
        return new DataPointComparator<HeatmapValue>(){
            private static final long serialVersionUID = -7729686147234670766L;

            public int compare(HeatmapValue o1, HeatmapValue o2) {
                int result = new Integer(o1.getY()).compareTo(new Integer(o2.getY()));
                if (result == 0) {
                    result = new Integer(o1.getX()).compareTo(new Integer(o2.getX()));
                }
                if (result == 0) {
                    result = new Double(o1.getValue()).compareTo(new Double(o2.getValue()));
                }
                return result;
            }
        };
    }

    public synchronized DataPointComparator<HeatmapValue> getComparator() {
        if (m_Comparator == null) {
            m_Comparator = this.newComparator();
        }
        return m_Comparator;
    }

    public HeatmapValue newPoint() {
        return new HeatmapValue();
    }

    public Heatmap getHeader() {
        return this.getHeader(this.getHeight(), this.getWidth());
    }

    public Heatmap getHeader(int height, int width) {
        Heatmap result = new Heatmap(height, width);
        result.assign(this);
        return result;
    }

    public void assign(DataContainer<HeatmapValue> other) {
        Heatmap map = (Heatmap)other;
        this.setID(map.getID());
        this.setReport(map.getReport().getClone());
        this.m_Notes.mergeWith(map.getNotes());
    }

    public List<HeatmapValue> toList() {
        ArrayList<HeatmapValue> result = new ArrayList<HeatmapValue>();
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                result.add(new HeatmapValue(y, x, this.get(y, x)));
            }
        }
        return result;
    }

    public List<HeatmapValue> toList(DataPointComparator comparator) {
        ArrayList<HeatmapValue> result = new ArrayList<HeatmapValue>(this.toList());
        Collections.sort(result, comparator);
        return result;
    }

    public TreeSet<HeatmapValue> toTreeSet() {
        return this.toTreeSet(null);
    }

    public TreeSet<HeatmapValue> toTreeSet(DataPointComparator<HeatmapValue> comparator) {
        TreeSet<Object> result = comparator == null ? new TreeSet() : new TreeSet<HeatmapValue>((Comparator<HeatmapValue>)comparator);
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                result.add(new HeatmapValue(y, x, this.get(y, x)));
            }
        }
        return result;
    }

    public Heatmap submap(int row, int col, int height, int width) {
        if (row + height > this.getHeight()) {
            throw new IllegalArgumentException("Submap exceeds height: " + (row + height) + " > " + this.getHeight());
        }
        if (col + width > this.getWidth()) {
            throw new IllegalArgumentException("Submap exceeds width: " + (col + width) + " > " + this.getWidth());
        }
        Heatmap result = this.getHeader(height, width);
        for (int y = row; y < row + height; ++y) {
            for (int x = col; x < col + width; ++x) {
                result.set(y - row, x - col, this.get(y, x));
            }
        }
        return result;
    }

    public String toIntensityString() {
        StringBuilder result = new StringBuilder();
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                if (result.length() > 0) {
                    result.append(",");
                }
                result.append(Utils.doubleToString((double)this.get(y, x), (int)6));
            }
        }
        return result.toString();
    }

    public static Heatmap fromIntensityString(int rows, int cols, String intensity) {
        double[][] map = new double[rows][cols];
        String[] parts = intensity.split(",");
        int x = 0;
        int y = 0;
        for (int i = 0; i < parts.length; ++i) {
            map[y][x] = Utils.toDouble((String)parts[i]);
            if (++x != cols) continue;
            x = 0;
            if (++y == rows) break;
        }
        Heatmap result = new Heatmap(map);
        return result;
    }

    public static Report createEmptyReport() {
        Report result = new Report();
        result.addField((AbstractField)new Field("Parent ID", DataType.NUMERIC));
        result.addField((AbstractField)new Field(FIELD_FILENAME, DataType.STRING));
        result.addField((AbstractField)new Field(FIELD_TIMESTAMP, DataType.STRING));
        result.setValue((AbstractField)new Field("Parent ID", DataType.NUMERIC), (Object)-1);
        return result;
    }

    public HeatmapStatistic toStatistic() {
        return new HeatmapStatistic(this);
    }
}

