/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.DateTime;
import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;

public class TimeseriesToSpreadSheet
extends AbstractConversion {
    private static final long serialVersionUID = -7385757807406641857L;

    public String globalInfo() {
        return "Turns a timeseries into a SpreadSheet object.";
    }

    public Class accepts() {
        return Timeseries.class;
    }

    public Class generates() {
        return SpreadSheet.class;
    }

    protected Object doConvert() throws Exception {
        Timeseries series = (Timeseries)((Object)this.m_Input);
        SpreadSheet result = new SpreadSheet();
        result.setName(series.getID());
        HeaderRow row = result.getHeaderRow();
        row.addCell("T").setContent("Timestamp");
        row.addCell("V").setContent("Value");
        for (Object obj : series.toList()) {
            TimeseriesPoint point = (TimeseriesPoint)((Object)obj);
            row = result.addRow();
            row.addCell("T").setContent(new DateTime(point.getTimestamp()));
            row.addCell("V").setContent(Double.valueOf(point.getValue()));
        }
        return result;
    }
}

