/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.core.Utils;
import adams.data.io.output.AbstractTimeseriesWriter;
import adams.data.report.Report;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.zip.GZIPOutputStream;

public class SimpleTimeseriesWriter
extends AbstractTimeseriesWriter {
    private static final long serialVersionUID = 2779645040618901178L;

    public String globalInfo() {
        return "Writer for the simple timeseries format.";
    }

    public String getFormatDescription() {
        return "Simple timeseries";
    }

    public String[] getFormatExtensions() {
        return new String[]{"sts", "sts.gz"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean writeData(List<Timeseries> data) {
        boolean result;
        BufferedWriter writer = null;
        DateFormat dformat = DateUtils.getTimestampFormatterMsecs();
        try {
            Timeseries series = data.get(0);
            writer = this.m_Output.getName().endsWith(".gz") ? new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(this.m_Output.getAbsolutePath())))) : new BufferedWriter(new FileWriter(this.m_Output.getAbsolutePath()));
            if (series.hasReport()) {
                Report report = series.getReport().getClone();
                report.setStringValue("ID", series.getID());
                Object[] lines = report.toProperties().toComment().split("\n");
                Arrays.sort(lines);
                writer.write(Utils.flatten((Object[])lines, (String)"\n"));
                writer.newLine();
            }
            writer.write("Timestamp,Value");
            writer.newLine();
            Iterator iter = series.iterator();
            while (iter.hasNext()) {
                TimeseriesPoint point = (TimeseriesPoint)((Object)iter.next());
                writer.write(Utils.doubleQuote((String)dformat.format(point.getTimestamp())));
                writer.write(",");
                writer.write(Double.toString(point.getValue()));
                writer.newLine();
            }
            writer.flush();
            result = true;
        }
        catch (Exception e) {
            result = false;
            this.getLogger().log(Level.SEVERE, "Failed to write timeseries to: " + this.m_Output, e);
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {}
        }
        return result;
    }
}

