/*
 * Decompiled with CFR 0.152.
 */
package adams.data.timeseries;

import adams.core.Properties;
import adams.data.timeseries.PeriodicityType;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.Calendar;
import java.util.Date;

public class PeriodicityHelper {
    public static final String FILENAME = "adams/data/timeseries/Periodicity.props";
    protected static Properties m_Properties;

    protected static synchronized Properties getProperties() {
        if (m_Properties == null) {
            Properties result;
            try {
                result = Properties.read((String)FILENAME);
            }
            catch (Exception e) {
                result = new Properties();
            }
            m_Properties = result;
        }
        return m_Properties;
    }

    protected static TDoubleArrayList calculateYearly(double left, Date leftDate, Calendar leftCal, double right, Date rightDate, Calendar rightCal) {
        TDoubleArrayList result = new TDoubleArrayList();
        leftCal.set(11, 0);
        leftCal.set(12, 0);
        leftCal.set(13, 0);
        leftCal.set(5, 1);
        leftCal.set(2, 0);
        leftCal.add(1, -1);
        rightCal.set(11, 23);
        rightCal.set(12, 59);
        rightCal.set(13, 59);
        rightCal.set(5, 1);
        rightCal.set(2, 0);
        rightCal.add(1, 1);
        while (leftCal.getTimeInMillis() <= rightCal.getTimeInMillis()) {
            result.add((double)leftCal.getTimeInMillis());
            leftCal.add(1, 1);
        }
        return result;
    }

    protected static TDoubleArrayList calculateQuarterly(double left, Date leftDate, Calendar leftCal, double right, Date rightDate, Calendar rightCal) {
        TDoubleArrayList result = new TDoubleArrayList();
        leftCal.set(11, 0);
        leftCal.set(12, 0);
        leftCal.set(13, 0);
        leftCal.set(5, 1);
        if (leftCal.get(2) == 0) {
            leftCal.add(2, -3);
        } else {
            leftCal.add(2, -(leftCal.get(2) % 3));
        }
        rightCal.set(11, 23);
        rightCal.set(12, 59);
        rightCal.set(13, 59);
        rightCal.set(5, 1);
        if (rightCal.get(2) == 11) {
            rightCal.add(2, 3);
        } else {
            rightCal.add(2, rightCal.get(2) % 3);
        }
        while (leftCal.getTimeInMillis() <= rightCal.getTimeInMillis()) {
            result.add((double)leftCal.getTimeInMillis());
            leftCal.add(2, 3);
        }
        return result;
    }

    protected static TDoubleArrayList calculateMonthly(double left, Date leftDate, Calendar leftCal, double right, Date rightDate, Calendar rightCal) {
        TDoubleArrayList result = new TDoubleArrayList();
        leftCal.set(11, 0);
        leftCal.set(12, 0);
        leftCal.set(13, 0);
        leftCal.set(5, 1);
        leftCal.add(2, -1);
        rightCal.set(11, 23);
        rightCal.set(12, 59);
        rightCal.set(13, 59);
        rightCal.set(5, 1);
        rightCal.add(2, 1);
        while (leftCal.getTimeInMillis() <= rightCal.getTimeInMillis()) {
            result.add((double)leftCal.getTimeInMillis());
            leftCal.add(2, 1);
        }
        return result;
    }

    protected static TDoubleArrayList calculateWeekly(double left, Date leftDate, Calendar leftCal, double right, Date rightDate, Calendar rightCal) {
        TDoubleArrayList result = new TDoubleArrayList();
        leftCal.set(11, 0);
        leftCal.set(12, 0);
        leftCal.set(13, 0);
        leftCal.set(7, 2);
        leftCal.add(6, -7);
        rightCal.set(11, 23);
        rightCal.set(12, 59);
        rightCal.set(13, 59);
        rightCal.set(7, 2);
        rightCal.add(6, 7);
        while (leftCal.getTimeInMillis() <= rightCal.getTimeInMillis()) {
            result.add((double)leftCal.getTimeInMillis());
            leftCal.add(6, 7);
        }
        return result;
    }

    protected static TDoubleArrayList calculateDaily(double left, Date leftDate, Calendar leftCal, double right, Date rightDate, Calendar rightCal) {
        TDoubleArrayList result = new TDoubleArrayList();
        leftCal.set(11, 0);
        leftCal.set(12, 0);
        leftCal.set(13, 0);
        leftCal.add(6, -1);
        rightCal.set(11, 23);
        rightCal.set(12, 59);
        rightCal.set(13, 59);
        rightCal.add(6, 1);
        while (leftCal.getTimeInMillis() <= rightCal.getTimeInMillis()) {
            result.add((double)leftCal.getTimeInMillis());
            leftCal.add(6, 1);
        }
        return result;
    }

    protected static TDoubleArrayList calculateHalfDaily(double left, Date leftDate, Calendar leftCal, double right, Date rightDate, Calendar rightCal) {
        TDoubleArrayList result = new TDoubleArrayList();
        if (leftCal.get(11) < 12) {
            leftCal.set(11, 0);
        } else {
            leftCal.set(11, 12);
        }
        leftCal.set(12, 0);
        leftCal.set(13, 0);
        leftCal.add(11, -12);
        if (rightCal.get(11) >= 12) {
            rightCal.set(11, 23);
        } else {
            rightCal.set(11, 12);
        }
        rightCal.set(12, 59);
        rightCal.set(13, 59);
        rightCal.add(11, 12);
        while (leftCal.getTimeInMillis() <= rightCal.getTimeInMillis()) {
            result.add((double)leftCal.getTimeInMillis());
            leftCal.add(11, 12);
        }
        return result;
    }

    protected static TDoubleArrayList calculateHourly(double left, Date leftDate, Calendar leftCal, double right, Date rightDate, Calendar rightCal) {
        TDoubleArrayList result = new TDoubleArrayList();
        leftCal.set(12, 0);
        leftCal.set(13, 0);
        leftCal.add(11, -1);
        rightCal.set(12, 59);
        rightCal.set(13, 59);
        rightCal.add(11, 1);
        while (leftCal.getTimeInMillis() <= rightCal.getTimeInMillis()) {
            result.add((double)leftCal.getTimeInMillis());
            leftCal.add(11, 1);
        }
        return result;
    }

    protected static TDoubleArrayList calculateHalfHourly(double left, Date leftDate, Calendar leftCal, double right, Date rightDate, Calendar rightCal) {
        TDoubleArrayList result = new TDoubleArrayList();
        if (leftCal.get(12) < 30) {
            leftCal.set(12, 0);
        } else {
            leftCal.set(12, 30);
        }
        leftCal.set(13, 0);
        leftCal.add(11, -1);
        if (rightCal.get(11) >= 30) {
            rightCal.set(12, 59);
        } else {
            rightCal.set(12, 30);
        }
        rightCal.set(13, 59);
        rightCal.add(11, 1);
        while (leftCal.getTimeInMillis() <= rightCal.getTimeInMillis()) {
            result.add((double)leftCal.getTimeInMillis());
            leftCal.add(12, 30);
        }
        return result;
    }

    protected static TDoubleArrayList calculatePerMinute(double left, Date leftDate, Calendar leftCal, double right, Date rightDate, Calendar rightCal) {
        TDoubleArrayList result = new TDoubleArrayList();
        leftCal.set(13, 0);
        leftCal.add(12, -1);
        rightCal.set(13, 59);
        rightCal.add(12, 1);
        while (leftCal.getTimeInMillis() <= rightCal.getTimeInMillis()) {
            result.add((double)leftCal.getTimeInMillis());
            leftCal.add(12, 1);
        }
        return result;
    }

    public static TDoubleArrayList calculate(PeriodicityType type, double left, Date leftDate, Calendar leftCal, double right, Date rightDate, Calendar rightCal) {
        switch (type) {
            case YEARLY: {
                return PeriodicityHelper.calculateYearly(left, leftDate, leftCal, right, rightDate, rightCal);
            }
            case QUARTERLY: {
                return PeriodicityHelper.calculateQuarterly(left, leftDate, leftCal, right, rightDate, rightCal);
            }
            case MONTHLY: {
                return PeriodicityHelper.calculateMonthly(left, leftDate, leftCal, right, rightDate, rightCal);
            }
            case WEEKLY: {
                return PeriodicityHelper.calculateWeekly(left, leftDate, leftCal, right, rightDate, rightCal);
            }
            case DAILY: {
                return PeriodicityHelper.calculateDaily(left, leftDate, leftCal, right, rightDate, rightCal);
            }
            case HALF_DAILY: {
                return PeriodicityHelper.calculateHalfDaily(left, leftDate, leftCal, right, rightDate, rightCal);
            }
            case HOURLY: {
                return PeriodicityHelper.calculateHourly(left, leftDate, leftCal, right, rightDate, rightCal);
            }
            case HALF_HOURLY: {
                return PeriodicityHelper.calculateHalfHourly(left, leftDate, leftCal, right, rightDate, rightCal);
            }
            case PER_MINUTE: {
                return PeriodicityHelper.calculatePerMinute(left, leftDate, leftCal, right, rightDate, rightCal);
            }
        }
        return new TDoubleArrayList();
    }

    public static String getFormat(PeriodicityType type) {
        return PeriodicityHelper.getProperties().getProperty("Format." + (Object)((Object)type), "y/M/d H:mm");
    }
}

