/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.WekaModelContainer;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorHelper;
import adams.flow.core.GlobalActorReference;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.source.WekaForecasterSetup;
import adams.flow.transformer.AbstractTransformer;
import weka.classifiers.timeseries.AbstractForecaster;
import weka.classifiers.timeseries.core.IncrementallyPrimeable;
import weka.core.Instance;
import weka.core.Instances;

public class WekaPrimeForecaster
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = -3019442578354930841L;
    protected GlobalActorReference m_Forecaster;

    public String globalInfo() {
        return "Primes a forecaster with the incoming data and outputs the updated forecaster alongside the training header (in a model container).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("forecaster", "forecaster", (Object)new GlobalActorReference(WekaForecasterSetup.class.getSimpleName()));
    }

    public void setForecaster(GlobalActorReference value) {
        this.m_Forecaster = value;
        this.reset();
    }

    public GlobalActorReference getForecaster() {
        return this.m_Forecaster;
    }

    public String forecasterTipText() {
        return "The Weka forecaster to prime on the input data; can be a " + WekaModelContainer.class.getName() + " or a " + AbstractForecaster.class.getName() + ".";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"forecaster", (Object)this.m_Forecaster);
    }

    public Class[] accepts() {
        return new Class[]{Instances.class, Instance.class};
    }

    public Class[] generates() {
        return new Class[]{WekaModelContainer.class};
    }

    protected AbstractForecaster getForecasterInstance() {
        AbstractForecaster result = null;
        Object obj = GlobalActorHelper.getSetup(Object.class, (GlobalActorReference)this.m_Forecaster, (AbstractActor)this);
        if (obj instanceof WekaModelContainer) {
            result = (AbstractForecaster)((WekaModelContainer)obj).getValue("Model");
        } else if (obj instanceof AbstractForecaster) {
            result = (AbstractForecaster)obj;
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        try {
            AbstractForecaster cls = this.getForecasterInstance();
            if (cls == null) {
                result = "Failed to obtain forecaster!";
            }
            if (result == null) {
                if (this.m_InputToken != null && this.m_InputToken.getPayload() instanceof Instances) {
                    Instances data = (Instances)this.m_InputToken.getPayload();
                    cls.primeForecaster(data);
                    this.m_OutputToken = new Token((Object)new WekaModelContainer((Object)cls, new Instances(data, 0), data));
                } else if (this.m_InputToken != null && this.m_InputToken.getPayload() instanceof Instance) {
                    Instance inst = (Instance)this.m_InputToken.getPayload();
                    Instances data = inst.dataset();
                    if (cls instanceof IncrementallyPrimeable) {
                        ((IncrementallyPrimeable)cls).primeForecasterIncremental(inst);
                        this.m_OutputToken = new Token((Object)new WekaModelContainer((Object)cls, new Instances(data, 0), data));
                    } else {
                        result = this.m_Forecaster.getValue() + " (= " + cls.getClass().getName() + ") does not implement " + IncrementallyPrimeable.class.getName() + "! Cannot prime incrementally!";
                    }
                }
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to process data:", e);
        }
        if (this.m_OutputToken != null) {
            this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.MODEL_GENERATOR, this.m_InputToken.getPayload().getClass(), (AbstractActor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

