/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;

public class MimeTypeHelper {
    public static MediaType getMimeType(File file) {
        return MimeTypeHelper.getMimeType(file.getAbsolutePath());
    }

    public static MediaType getMimeType(String filename) {
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(filename));
            AutoDetectParser parser = new AutoDetectParser();
            Detector detector = parser.getDetector();
            Metadata md = new Metadata();
            md.add("resourceName", filename);
            MediaType result = detector.detect((InputStream)bis, md);
            bis.close();
            return result;
        }
        catch (Exception e) {
            return MediaType.OCTET_STREAM;
        }
    }
}

