/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.base.HtmlCode;
import adams.core.net.HtmlUtils;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;

public class SpreadSheetToHTML
extends AbstractConversion {
    private static final long serialVersionUID = -6497336681092989013L;
    protected String m_Title;
    protected HtmlCode m_HtmlBeforeTable;
    protected HtmlCode m_HtmlAfterTable;
    protected boolean m_OnlyTableCode;

    public String globalInfo() {
        return "Turns a spreadsheet into an HTML table.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("title", "title", (Object)"");
        this.m_OptionManager.add("html-before-table", "htmlBeforeTable", (Object)new HtmlCode());
        this.m_OptionManager.add("html-after-table", "htmlAfterTable", (Object)new HtmlCode());
        this.m_OptionManager.add("only-table-code", "onlyTableCode", (Object)false);
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"onlyTableModel", (boolean)this.m_OnlyTableCode, (String)"only table");
    }

    public void setTitle(String value) {
        this.m_Title = value;
        this.reset();
    }

    public String getTitle() {
        return this.m_Title;
    }

    public String titleTipText() {
        return "The title to use for the HTML title tag.";
    }

    public void setHtmlBeforeTable(HtmlCode value) {
        this.m_HtmlBeforeTable = value;
        this.reset();
    }

    public HtmlCode getHtmlBeforeTable() {
        return this.m_HtmlBeforeTable;
    }

    public String htmlBeforeTableTipText() {
        return "The HTML code to inject before the table.";
    }

    public void setHtmlAfterTable(HtmlCode value) {
        this.m_HtmlAfterTable = value;
        this.reset();
    }

    public HtmlCode getHtmlAfterTable() {
        return this.m_HtmlAfterTable;
    }

    public String htmlAfterTableTipText() {
        return "The HTML code to inect after the table.";
    }

    public void setOnlyTableCode(boolean value) {
        this.m_OnlyTableCode = value;
        this.reset();
    }

    public boolean getOnlyTableCode() {
        return this.m_OnlyTableCode;
    }

    public String onlyTableCodeTipText() {
        return "If enabled, only the table code gets generated without surrounding body/html tags.";
    }

    public Class accepts() {
        return SpreadSheet.class;
    }

    public Class generates() {
        return String.class;
    }

    protected Object doConvert() throws Exception {
        int i;
        StringBuilder result = new StringBuilder();
        SpreadSheet input = (SpreadSheet)this.m_Input;
        if (!this.m_OnlyTableCode) {
            result.append("<html>\n");
            result.append("  <title>" + this.m_Title + "</title>\n");
            result.append("  <body>\n");
            result.append((Object)((Object)this.m_HtmlBeforeTable) + "\n");
        }
        result.append("  <table>\n");
        result.append("    <tr>\n");
        for (i = 0; i < input.getHeaderRow().getCellCount(); ++i) {
            result.append("      <th>" + HtmlUtils.toHTML((String)input.getHeaderRow().getCell(i).getContent()) + "</th>\n");
        }
        result.append("    </tr>\n");
        for (DataRow row : input.rows()) {
            result.append("    <tr>\n");
            for (i = 0; i < row.getCellCount(); ++i) {
                result.append("      <td>" + HtmlUtils.toHTML((String)row.getCell(i).getContent()) + "</td>\n");
            }
            result.append("    </tr>\n");
        }
        result.append("  </table>\n");
        if (!this.m_OnlyTableCode) {
            result.append((Object)((Object)this.m_HtmlAfterTable) + "\n");
            result.append("  </body>\n");
            result.append("</html>\n");
        }
        return result.toString();
    }
}

