/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.BufferedInputStream;
import java.net.URL;

public class DownloadContent
extends AbstractTransformer {
    private static final long serialVersionUID = 8688918591152139449L;
    protected int m_BufferSize;

    public String globalInfo() {
        return "Downloads the raw, textual content from a URL and forwards it.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("buffer-size", "bufferSize", (Object)1024, (Number)1, null);
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"bufferSize", (Object)this.m_BufferSize, (String)"Buffer: ");
    }

    public void setBufferSize(int value) {
        if (value > 0) {
            this.m_BufferSize = value;
            this.reset();
        } else {
            this.getLogger().severe("Buffer must be >0, provided: " + value);
        }
    }

    public int getBufferSize() {
        return this.m_BufferSize;
    }

    public String bufferSizeTipText() {
        return "The size of byte-buffer used for reading the content.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, URL.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doExecute() {
        String result;
        BufferedInputStream input = null;
        StringBuilder content = new StringBuilder();
        try {
            int len;
            URL url = this.m_InputToken.getPayload() instanceof String ? new URL((String)this.m_InputToken.getPayload()) : (URL)this.m_InputToken.getPayload();
            input = new BufferedInputStream(url.openStream());
            byte[] buffer = new byte[this.m_BufferSize];
            while ((len = input.read(buffer)) > 0) {
                if (len < this.m_BufferSize) {
                    byte[] bufferSmall = new byte[len];
                    System.arraycopy(buffer, 0, bufferSmall, 0, len);
                    content.append(new String(bufferSmall));
                    continue;
                }
                content.append(new String(buffer));
            }
            this.m_OutputToken = new Token((Object)content.toString());
            content = null;
            result = null;
        }
        catch (Exception e) {
            result = this.handleException("Problem downloading '" + this.m_InputToken.getPayload() + "': ", e);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Exception e) {}
        }
        return result;
    }
}

