/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.alg;

import java.util.List;

public class ExhaustiveNeighbor {
    int N;
    List<double[]> points;
    double bestDistance;

    public ExhaustiveNeighbor(int n) {
        this.N = n;
    }

    public ExhaustiveNeighbor() {
    }

    public void setN(int n) {
        this.N = n;
    }

    public void setPoints(List<double[]> points) {
        this.points = points;
    }

    public int findClosest(double[] p, double maxDistance) {
        int best = -1;
        this.bestDistance = maxDistance * maxDistance;
        for (int i = 0; i < this.points.size(); ++i) {
            double[] c = this.points.get(i);
            double distanceC = 0.0;
            for (int j = 0; j < this.N; ++j) {
                double d = p[j] - c[j];
                distanceC += d * d;
            }
            if (!(distanceC < this.bestDistance)) continue;
            this.bestDistance = distanceC;
            best = i;
        }
        return best;
    }

    public double getBestDistance() {
        return this.bestDistance;
    }
}

