/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.alg;

import org.ddogleg.nn.alg.KdTree;
import org.ddogleg.nn.alg.KdTreeSearch;

public class KdTreeSearchStandard
implements KdTreeSearch {
    private KdTree tree;
    private double[] target;
    private double maxDistanceSq = Double.MAX_VALUE;
    private double bestDistanceSq;
    private KdTree.Node closest;

    @Override
    public void setTree(KdTree tree) {
        this.tree = tree;
    }

    @Override
    public void setMaxDistance(double maxDistance) {
        this.maxDistanceSq = maxDistance * maxDistance;
    }

    @Override
    public KdTree.Node findClosest(double[] target) {
        if (this.tree.root == null) {
            return null;
        }
        this.target = target;
        this.closest = null;
        this.bestDistanceSq = this.maxDistanceSq;
        this.stepClosest(this.tree.root);
        return this.closest;
    }

    @Override
    public double getDistance() {
        return this.bestDistanceSq;
    }

    private void stepClosest(KdTree.Node node) {
        KdTree.Node further;
        KdTree.Node nearer;
        double distSq = KdTree.distanceSq(node, this.target, this.tree.N);
        if (distSq < this.bestDistanceSq) {
            this.closest = node;
            this.bestDistanceSq = distSq;
        }
        if (node.isLeaf()) {
            return;
        }
        double splitValue = node.point[node.split];
        if (this.target[node.split] <= splitValue) {
            nearer = node.left;
            further = node.right;
        } else {
            nearer = node.right;
            further = node.left;
        }
        this.stepClosest(nearer);
        double dx = splitValue - this.target[node.split];
        if (dx * dx < this.bestDistanceSq) {
            this.stepClosest(further);
        }
    }
}

