/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.wrap;

import java.util.List;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.nn.alg.AxisSplitter;
import org.ddogleg.nn.alg.AxisSplitterMedian;
import org.ddogleg.nn.alg.KdTree;
import org.ddogleg.nn.alg.KdTreeConstructor;
import org.ddogleg.nn.alg.KdTreeMemory;
import org.ddogleg.nn.alg.KdTreeSearch;
import org.ddogleg.nn.alg.KdTreeSearchStandard;

public class KdTreeNearestNeighbor<D>
implements NearestNeighbor<D> {
    KdTree tree;
    KdTreeConstructor<D> constructor;
    KdTreeSearch search;
    AxisSplitter<D> splitter;
    KdTreeMemory memory = new KdTreeMemory();

    public KdTreeNearestNeighbor(KdTreeSearch search, AxisSplitter<D> splitter) {
        this.search = search;
        this.splitter = splitter;
    }

    public KdTreeNearestNeighbor() {
        this(new KdTreeSearchStandard(), new AxisSplitterMedian());
    }

    @Override
    public void init(int N) {
        this.constructor = new KdTreeConstructor<D>(this.memory, N, this.splitter);
    }

    @Override
    public void setPoints(List<double[]> points, List<D> data) {
        if (this.tree != null) {
            this.memory.recycleGraph(this.tree);
        }
        this.tree = this.constructor.construct(points, data);
        this.search.setTree(this.tree);
    }

    @Override
    public boolean findNearest(double[] point, double maxDistance, NnData<D> result) {
        if (maxDistance <= 0.0) {
            this.search.setMaxDistance(Double.MAX_VALUE);
        } else {
            this.search.setMaxDistance(maxDistance);
        }
        KdTree.Node found = this.search.findClosest(point);
        if (found == null) {
            return false;
        }
        result.point = found.point;
        result.data = found.data;
        result.distance = this.search.getDistance();
        return true;
    }
}

