/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.wrap;

import org.ddogleg.optimization.OptimizationException;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.functions.FunctionNtoMxN;
import org.ddogleg.optimization.impl.LevenbergDenseBase;
import org.ddogleg.optimization.impl.NumericalJacobianForward;
import org.ddogleg.optimization.wrap.WrapCoupledJacobian;

public class WrapLevenbergDampened
implements UnconstrainedLeastSquares {
    LevenbergDenseBase alg;

    public WrapLevenbergDampened(LevenbergDenseBase alg) {
        this.alg = alg;
    }

    @Override
    public void setFunction(FunctionNtoM function, FunctionNtoMxN jacobian) {
        if (jacobian == null) {
            jacobian = new NumericalJacobianForward(function);
        }
        this.alg.setFunction(new WrapCoupledJacobian(function, jacobian));
    }

    @Override
    public void initialize(double[] initial, double ftol, double gtol) {
        this.alg.setConvergence(ftol, gtol);
        this.alg.initialize(initial);
    }

    @Override
    public double[] getParameters() {
        return this.alg.getParameters();
    }

    @Override
    public boolean iterate() throws OptimizationException {
        return this.alg.iterate();
    }

    @Override
    public boolean isConverged() {
        return this.alg.isConverged();
    }

    @Override
    public String getWarning() {
        return this.alg.getMessage();
    }

    @Override
    public double getFunctionValue() {
        return this.alg.getFnorm();
    }

    @Override
    public boolean isUpdated() {
        return this.alg.isUpdatedParameters();
    }
}

