/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.rand;

import java.util.Random;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionCommon;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionInner;
import org.ejml.alg.dense.linsol.chol.LinearSolverChol;
import org.ejml.alg.dense.mult.VectorVectorMult;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.LinearSolver;
import org.ejml.ops.CommonOps;

public class MultivariateGaussianDraw {
    private LinearSolver<DenseMatrix64F> solver;
    private DenseMatrix64F mean;
    private DenseMatrix64F A;
    private Random rand;
    private DenseMatrix64F r;
    private DenseMatrix64F Q_inv;
    double likelihoodLeft;

    public MultivariateGaussianDraw(Random rand, DenseMatrix64F mean, DenseMatrix64F cov) {
        this.mean = mean != null ? new DenseMatrix64F(mean) : new DenseMatrix64F(cov.numCols, 1);
        this.r = new DenseMatrix64F(cov.numRows, 1);
        this.Q_inv = new DenseMatrix64F(cov.numRows, cov.numCols);
        CholeskyDecompositionInner cholesky = new CholeskyDecompositionInner(true);
        this.solver = new LinearSolverChol((CholeskyDecompositionCommon)cholesky);
        this.solver.setA((Matrix64F)cov);
        this.A = cholesky.getT(null);
        this.solver.invert((Matrix64F)this.Q_inv);
        this.likelihoodLeft = Math.pow(Math.PI * 2, (double)(-this.mean.numRows) / 2.0) * Math.sqrt(CommonOps.det((DenseMatrix64F)cov));
        this.rand = rand;
    }

    public void assignMean(DenseMatrix64F mean) {
        this.mean = mean;
    }

    public DenseMatrix64F next(DenseMatrix64F x) {
        for (int i = 0; i < this.r.numRows; ++i) {
            this.r.set(i, 0, this.rand.nextGaussian());
        }
        x.set((D1Matrix64F)this.mean);
        CommonOps.multAdd((RowD1Matrix64F)this.A, (RowD1Matrix64F)this.r, (RowD1Matrix64F)x);
        return x;
    }

    public double computeLikelihoodP() {
        double inner = VectorVectorMult.innerProdA((D1Matrix64F)this.r, (D1Matrix64F)this.Q_inv, (D1Matrix64F)this.r);
        return this.likelihoodLeft * Math.exp(-0.5 * inner);
    }
}

